
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "params",
    "requests"
})
@Generated("jsonschema2pojo")
public class ExchangeSource implements Serializable
{

    @JsonProperty("params")
    private SourceParams params;
    @JsonProperty("requests")
    private List<SourceRequest> requests;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -4932243030035112074L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ExchangeSource() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ExchangeSource(ExchangeSource source) {
        super();
        this.params = source.params;
        this.requests = source.requests;
    }

    public ExchangeSource(SourceParams params, List<SourceRequest> requests) {
        super();
        this.params = params;
        this.requests = requests;
    }

    @JsonProperty("params")
    public Optional<SourceParams> getParams() {
        return Optional.ofNullable(params);
    }

    @JsonProperty("params")
    public void setParams(SourceParams params) {
        this.params = params;
    }

    public ExchangeSource withParams(SourceParams params) {
        this.params = params;
        return this;
    }

    @JsonProperty("requests")
    public Optional<List<SourceRequest>> getRequests() {
        return Optional.ofNullable(requests);
    }

    @JsonProperty("requests")
    public void setRequests(List<SourceRequest> requests) {
        this.requests = requests;
    }

    public ExchangeSource withRequests(List<SourceRequest> requests) {
        this.requests = requests;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ExchangeSource withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("params".equals(name)) {
            if (value instanceof SourceParams) {
                setParams(((SourceParams) value));
            } else {
                throw new IllegalArgumentException(("property \"params\" is of type \"org.hisp.dhis.api.model.v40_2_2.SourceParams\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("requests".equals(name)) {
                if (value instanceof List) {
                    setRequests(((List<SourceRequest> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"requests\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.SourceRequest>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                return false;
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("params".equals(name)) {
            return getParams();
        } else {
            if ("requests".equals(name)) {
                return getRequests();
            } else {
                return notFoundValue;
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ExchangeSource.NOT_FOUND_VALUE);
        if (ExchangeSource.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ExchangeSource with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ExchangeSource.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("params");
        sb.append('=');
        sb.append(((this.params == null)?"<null>":this.params));
        sb.append(',');
        sb.append("requests");
        sb.append('=');
        sb.append(((this.requests == null)?"<null>":this.requests));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.requests == null)? 0 :this.requests.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.params == null)? 0 :this.params.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ExchangeSource) == false) {
            return false;
        }
        ExchangeSource rhs = ((ExchangeSource) other);
        return ((((this.requests == rhs.requests)||((this.requests!= null)&&this.requests.equals(rhs.requests)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.params == rhs.params)||((this.params!= null)&&this.params.equals(rhs.params))));
    }

}
