
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "api",
    "request",
    "type"
})
@Generated("jsonschema2pojo")
public class ExchangeTarget implements Serializable
{

    @JsonProperty("api")
    private Api api;
    @JsonProperty("request")
    private TargetRequest request;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("type")
    private ExchangeTarget.TypeRef type;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -6509281886256151854L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ExchangeTarget() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ExchangeTarget(ExchangeTarget source) {
        super();
        this.api = source.api;
        this.request = source.request;
        this.type = source.type;
    }

    public ExchangeTarget(Api api, TargetRequest request, ExchangeTarget.TypeRef type) {
        super();
        this.api = api;
        this.request = request;
        this.type = type;
    }

    @JsonProperty("api")
    public Optional<Api> getApi() {
        return Optional.ofNullable(api);
    }

    @JsonProperty("api")
    public void setApi(Api api) {
        this.api = api;
    }

    public ExchangeTarget withApi(Api api) {
        this.api = api;
        return this;
    }

    @JsonProperty("request")
    public Optional<TargetRequest> getRequest() {
        return Optional.ofNullable(request);
    }

    @JsonProperty("request")
    public void setRequest(TargetRequest request) {
        this.request = request;
    }

    public ExchangeTarget withRequest(TargetRequest request) {
        this.request = request;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("type")
    public ExchangeTarget.TypeRef getType() {
        return type;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("type")
    public void setType(ExchangeTarget.TypeRef type) {
        this.type = type;
    }

    public ExchangeTarget withType(ExchangeTarget.TypeRef type) {
        this.type = type;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ExchangeTarget withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("api".equals(name)) {
            if (value instanceof Api) {
                setApi(((Api) value));
            } else {
                throw new IllegalArgumentException(("property \"api\" is of type \"org.hisp.dhis.api.model.v40_2_2.Api\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("request".equals(name)) {
                if (value instanceof TargetRequest) {
                    setRequest(((TargetRequest) value));
                } else {
                    throw new IllegalArgumentException(("property \"request\" is of type \"org.hisp.dhis.api.model.v40_2_2.TargetRequest\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("type".equals(name)) {
                    if (value instanceof ExchangeTarget.TypeRef) {
                        setType(((ExchangeTarget.TypeRef) value));
                    } else {
                        throw new IllegalArgumentException(("property \"type\" is of type \"org.hisp.dhis.api.model.v40_2_2.ExchangeTarget.TypeRef\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    return false;
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("api".equals(name)) {
            return getApi();
        } else {
            if ("request".equals(name)) {
                return getRequest();
            } else {
                if ("type".equals(name)) {
                    return getType();
                } else {
                    return notFoundValue;
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ExchangeTarget.NOT_FOUND_VALUE);
        if (ExchangeTarget.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ExchangeTarget with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ExchangeTarget.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("api");
        sb.append('=');
        sb.append(((this.api == null)?"<null>":this.api));
        sb.append(',');
        sb.append("request");
        sb.append('=');
        sb.append(((this.request == null)?"<null>":this.request));
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.request == null)? 0 :this.request.hashCode()));
        result = ((result* 31)+((this.api == null)? 0 :this.api.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ExchangeTarget) == false) {
            return false;
        }
        ExchangeTarget rhs = ((ExchangeTarget) other);
        return (((((this.request == rhs.request)||((this.request!= null)&&this.request.equals(rhs.request)))&&((this.api == rhs.api)||((this.api!= null)&&this.api.equals(rhs.api))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type))));
    }

    @Generated("jsonschema2pojo")
    public enum TypeRef {

        INTERNAL("INTERNAL"),
        EXTERNAL("EXTERNAL");
        private final String value;
        private final static Map<String, ExchangeTarget.TypeRef> CONSTANTS = new HashMap<String, ExchangeTarget.TypeRef>();

        static {
            for (ExchangeTarget.TypeRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        TypeRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ExchangeTarget.TypeRef fromValue(String value) {
            ExchangeTarget.TypeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
