
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "confidential",
    "encode",
    "header",
    "key",
    "value"
})
@Generated("jsonschema2pojo")
public class GenericGatewayParameter implements Serializable
{

    @JsonProperty("confidential")
    private Boolean confidential;
    @JsonProperty("encode")
    private Boolean encode;
    @JsonProperty("header")
    private Boolean header;
    @JsonProperty("key")
    private String key;
    @JsonProperty("value")
    private String value;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -8584782465100669285L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public GenericGatewayParameter() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public GenericGatewayParameter(GenericGatewayParameter source) {
        super();
        this.confidential = source.confidential;
        this.encode = source.encode;
        this.header = source.header;
        this.key = source.key;
        this.value = source.value;
    }

    public GenericGatewayParameter(Boolean confidential, Boolean encode, Boolean header, String key, String value) {
        super();
        this.confidential = confidential;
        this.encode = encode;
        this.header = header;
        this.key = key;
        this.value = value;
    }

    @JsonProperty("confidential")
    public Optional<Boolean> getConfidential() {
        return Optional.ofNullable(confidential);
    }

    @JsonProperty("confidential")
    public void setConfidential(Boolean confidential) {
        this.confidential = confidential;
    }

    public GenericGatewayParameter withConfidential(Boolean confidential) {
        this.confidential = confidential;
        return this;
    }

    @JsonProperty("encode")
    public Optional<Boolean> getEncode() {
        return Optional.ofNullable(encode);
    }

    @JsonProperty("encode")
    public void setEncode(Boolean encode) {
        this.encode = encode;
    }

    public GenericGatewayParameter withEncode(Boolean encode) {
        this.encode = encode;
        return this;
    }

    @JsonProperty("header")
    public Optional<Boolean> getHeader() {
        return Optional.ofNullable(header);
    }

    @JsonProperty("header")
    public void setHeader(Boolean header) {
        this.header = header;
    }

    public GenericGatewayParameter withHeader(Boolean header) {
        this.header = header;
        return this;
    }

    @JsonProperty("key")
    public Optional<String> getKey() {
        return Optional.ofNullable(key);
    }

    @JsonProperty("key")
    public void setKey(String key) {
        this.key = key;
    }

    public GenericGatewayParameter withKey(String key) {
        this.key = key;
        return this;
    }

    @JsonProperty("value")
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    @JsonProperty("value")
    public void setValue(String value) {
        this.value = value;
    }

    public GenericGatewayParameter withValue(String value) {
        this.value = value;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public GenericGatewayParameter withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("confidential".equals(name)) {
            if (value instanceof Boolean) {
                setConfidential(((Boolean) value));
            } else {
                throw new IllegalArgumentException(("property \"confidential\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("encode".equals(name)) {
                if (value instanceof Boolean) {
                    setEncode(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"encode\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("header".equals(name)) {
                    if (value instanceof Boolean) {
                        setHeader(((Boolean) value));
                    } else {
                        throw new IllegalArgumentException(("property \"header\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("key".equals(name)) {
                        if (value instanceof String) {
                            setKey(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"key\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("value".equals(name)) {
                            if (value instanceof String) {
                                setValue(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"value\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            return false;
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("confidential".equals(name)) {
            return getConfidential();
        } else {
            if ("encode".equals(name)) {
                return getEncode();
            } else {
                if ("header".equals(name)) {
                    return getHeader();
                } else {
                    if ("key".equals(name)) {
                        return getKey();
                    } else {
                        if ("value".equals(name)) {
                            return getValue();
                        } else {
                            return notFoundValue;
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, GenericGatewayParameter.NOT_FOUND_VALUE);
        if (GenericGatewayParameter.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public GenericGatewayParameter with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GenericGatewayParameter.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("confidential");
        sb.append('=');
        sb.append(((this.confidential == null)?"<null>":this.confidential));
        sb.append(',');
        sb.append("encode");
        sb.append('=');
        sb.append(((this.encode == null)?"<null>":this.encode));
        sb.append(',');
        sb.append("header");
        sb.append('=');
        sb.append(((this.header == null)?"<null>":this.header));
        sb.append(',');
        sb.append("key");
        sb.append('=');
        sb.append(((this.key == null)?"<null>":this.key));
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(((this.value == null)?"<null>":this.value));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.encode == null)? 0 :this.encode.hashCode()));
        result = ((result* 31)+((this.header == null)? 0 :this.header.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.value == null)? 0 :this.value.hashCode()));
        result = ((result* 31)+((this.key == null)? 0 :this.key.hashCode()));
        result = ((result* 31)+((this.confidential == null)? 0 :this.confidential.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof GenericGatewayParameter) == false) {
            return false;
        }
        GenericGatewayParameter rhs = ((GenericGatewayParameter) other);
        return (((((((this.encode == rhs.encode)||((this.encode!= null)&&this.encode.equals(rhs.encode)))&&((this.header == rhs.header)||((this.header!= null)&&this.header.equals(rhs.header))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.value == rhs.value)||((this.value!= null)&&this.value.equals(rhs.value))))&&((this.key == rhs.key)||((this.key!= null)&&this.key.equals(rhs.key))))&&((this.confidential == rhs.confidential)||((this.confidential!= null)&&this.confidential.equals(rhs.confidential))));
    }

}
