
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "async",
    "categoryIdScheme",
    "categoryOptionComboIdScheme",
    "categoryOptionIdScheme",
    "dataElementIdScheme",
    "dataSet",
    "dataSetIdScheme",
    "datasetAllowsPeriods",
    "dryRun",
    "eventIdScheme",
    "filename",
    "firstRowIsHeader",
    "force",
    "idScheme",
    "ignoreEmptyCollection",
    "importStrategy",
    "mergeDataValues",
    "mergeMode",
    "notificationLevel",
    "orgUnitIdScheme",
    "preheatCache",
    "programIdScheme",
    "programStageIdScheme",
    "reportMode",
    "requireAttributeOptionCombo",
    "requireCategoryOptionCombo",
    "sharing",
    "skipAudit",
    "skipCache",
    "skipExistingCheck",
    "skipLastUpdated",
    "skipNotifications",
    "skipPatternValidation",
    "strictAttributeOptionCombos",
    "strictCategoryOptionCombos",
    "strictDataElements",
    "strictDataSetApproval",
    "strictDataSetInputPeriods",
    "strictDataSetLocking",
    "strictOrganisationUnits",
    "strictPeriods",
    "trackedEntityAttributeIdScheme",
    "trackedEntityIdScheme"
})
@Generated("jsonschema2pojo")
public class ImportOptions implements Serializable
{

    @JsonProperty("async")
    private Boolean async;
    @JsonProperty("categoryIdScheme")
    private String categoryIdScheme;
    @JsonProperty("categoryOptionComboIdScheme")
    private String categoryOptionComboIdScheme;
    @JsonProperty("categoryOptionIdScheme")
    private String categoryOptionIdScheme;
    @JsonProperty("dataElementIdScheme")
    private String dataElementIdScheme;
    @JsonProperty("dataSet")
    private String dataSet;
    @JsonProperty("dataSetIdScheme")
    private String dataSetIdScheme;
    @JsonProperty("datasetAllowsPeriods")
    private Boolean datasetAllowsPeriods;
    @JsonProperty("dryRun")
    private Boolean dryRun;
    @JsonProperty("eventIdScheme")
    private String eventIdScheme;
    @JsonProperty("filename")
    private String filename;
    @JsonProperty("firstRowIsHeader")
    private Boolean firstRowIsHeader;
    @JsonProperty("force")
    private Boolean force;
    @JsonProperty("idScheme")
    private String idScheme;
    @JsonProperty("ignoreEmptyCollection")
    private Boolean ignoreEmptyCollection;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("importStrategy")
    private ImportOptions.ImportStrategyRef importStrategy;
    @JsonProperty("mergeDataValues")
    private Boolean mergeDataValues;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mergeMode")
    private ImportOptions.MergeModeRef mergeMode;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("notificationLevel")
    private ImportOptions.NotificationLevelRef notificationLevel;
    @JsonProperty("orgUnitIdScheme")
    private String orgUnitIdScheme;
    @JsonProperty("preheatCache")
    private Boolean preheatCache;
    @JsonProperty("programIdScheme")
    private String programIdScheme;
    @JsonProperty("programStageIdScheme")
    private String programStageIdScheme;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("reportMode")
    private ImportOptions.ReportModeRef reportMode;
    @JsonProperty("requireAttributeOptionCombo")
    private Boolean requireAttributeOptionCombo;
    @JsonProperty("requireCategoryOptionCombo")
    private Boolean requireCategoryOptionCombo;
    @JsonProperty("sharing")
    private Boolean sharing;
    @JsonProperty("skipAudit")
    private Boolean skipAudit;
    @JsonProperty("skipCache")
    private Boolean skipCache;
    @JsonProperty("skipExistingCheck")
    private Boolean skipExistingCheck;
    @JsonProperty("skipLastUpdated")
    private Boolean skipLastUpdated;
    @JsonProperty("skipNotifications")
    private Boolean skipNotifications;
    @JsonProperty("skipPatternValidation")
    private Boolean skipPatternValidation;
    @JsonProperty("strictAttributeOptionCombos")
    private Boolean strictAttributeOptionCombos;
    @JsonProperty("strictCategoryOptionCombos")
    private Boolean strictCategoryOptionCombos;
    @JsonProperty("strictDataElements")
    private Boolean strictDataElements;
    @JsonProperty("strictDataSetApproval")
    private Boolean strictDataSetApproval;
    @JsonProperty("strictDataSetInputPeriods")
    private Boolean strictDataSetInputPeriods;
    @JsonProperty("strictDataSetLocking")
    private Boolean strictDataSetLocking;
    @JsonProperty("strictOrganisationUnits")
    private Boolean strictOrganisationUnits;
    @JsonProperty("strictPeriods")
    private Boolean strictPeriods;
    @JsonProperty("trackedEntityAttributeIdScheme")
    private String trackedEntityAttributeIdScheme;
    @JsonProperty("trackedEntityIdScheme")
    private String trackedEntityIdScheme;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -430902112819133814L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ImportOptions() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ImportOptions(ImportOptions source) {
        super();
        this.async = source.async;
        this.categoryIdScheme = source.categoryIdScheme;
        this.categoryOptionComboIdScheme = source.categoryOptionComboIdScheme;
        this.categoryOptionIdScheme = source.categoryOptionIdScheme;
        this.dataElementIdScheme = source.dataElementIdScheme;
        this.dataSet = source.dataSet;
        this.dataSetIdScheme = source.dataSetIdScheme;
        this.datasetAllowsPeriods = source.datasetAllowsPeriods;
        this.dryRun = source.dryRun;
        this.eventIdScheme = source.eventIdScheme;
        this.filename = source.filename;
        this.firstRowIsHeader = source.firstRowIsHeader;
        this.force = source.force;
        this.idScheme = source.idScheme;
        this.ignoreEmptyCollection = source.ignoreEmptyCollection;
        this.importStrategy = source.importStrategy;
        this.mergeDataValues = source.mergeDataValues;
        this.mergeMode = source.mergeMode;
        this.notificationLevel = source.notificationLevel;
        this.orgUnitIdScheme = source.orgUnitIdScheme;
        this.preheatCache = source.preheatCache;
        this.programIdScheme = source.programIdScheme;
        this.programStageIdScheme = source.programStageIdScheme;
        this.reportMode = source.reportMode;
        this.requireAttributeOptionCombo = source.requireAttributeOptionCombo;
        this.requireCategoryOptionCombo = source.requireCategoryOptionCombo;
        this.sharing = source.sharing;
        this.skipAudit = source.skipAudit;
        this.skipCache = source.skipCache;
        this.skipExistingCheck = source.skipExistingCheck;
        this.skipLastUpdated = source.skipLastUpdated;
        this.skipNotifications = source.skipNotifications;
        this.skipPatternValidation = source.skipPatternValidation;
        this.strictAttributeOptionCombos = source.strictAttributeOptionCombos;
        this.strictCategoryOptionCombos = source.strictCategoryOptionCombos;
        this.strictDataElements = source.strictDataElements;
        this.strictDataSetApproval = source.strictDataSetApproval;
        this.strictDataSetInputPeriods = source.strictDataSetInputPeriods;
        this.strictDataSetLocking = source.strictDataSetLocking;
        this.strictOrganisationUnits = source.strictOrganisationUnits;
        this.strictPeriods = source.strictPeriods;
        this.trackedEntityAttributeIdScheme = source.trackedEntityAttributeIdScheme;
        this.trackedEntityIdScheme = source.trackedEntityIdScheme;
    }

    public ImportOptions(Boolean async, String categoryIdScheme, String categoryOptionComboIdScheme, String categoryOptionIdScheme, String dataElementIdScheme, String dataSet, String dataSetIdScheme, Boolean datasetAllowsPeriods, Boolean dryRun, String eventIdScheme, String filename, Boolean firstRowIsHeader, Boolean force, String idScheme, Boolean ignoreEmptyCollection, ImportOptions.ImportStrategyRef importStrategy, Boolean mergeDataValues, ImportOptions.MergeModeRef mergeMode, ImportOptions.NotificationLevelRef notificationLevel, String orgUnitIdScheme, Boolean preheatCache, String programIdScheme, String programStageIdScheme, ImportOptions.ReportModeRef reportMode, Boolean requireAttributeOptionCombo, Boolean requireCategoryOptionCombo, Boolean sharing, Boolean skipAudit, Boolean skipCache, Boolean skipExistingCheck, Boolean skipLastUpdated, Boolean skipNotifications, Boolean skipPatternValidation, Boolean strictAttributeOptionCombos, Boolean strictCategoryOptionCombos, Boolean strictDataElements, Boolean strictDataSetApproval, Boolean strictDataSetInputPeriods, Boolean strictDataSetLocking, Boolean strictOrganisationUnits, Boolean strictPeriods, String trackedEntityAttributeIdScheme, String trackedEntityIdScheme) {
        super();
        this.async = async;
        this.categoryIdScheme = categoryIdScheme;
        this.categoryOptionComboIdScheme = categoryOptionComboIdScheme;
        this.categoryOptionIdScheme = categoryOptionIdScheme;
        this.dataElementIdScheme = dataElementIdScheme;
        this.dataSet = dataSet;
        this.dataSetIdScheme = dataSetIdScheme;
        this.datasetAllowsPeriods = datasetAllowsPeriods;
        this.dryRun = dryRun;
        this.eventIdScheme = eventIdScheme;
        this.filename = filename;
        this.firstRowIsHeader = firstRowIsHeader;
        this.force = force;
        this.idScheme = idScheme;
        this.ignoreEmptyCollection = ignoreEmptyCollection;
        this.importStrategy = importStrategy;
        this.mergeDataValues = mergeDataValues;
        this.mergeMode = mergeMode;
        this.notificationLevel = notificationLevel;
        this.orgUnitIdScheme = orgUnitIdScheme;
        this.preheatCache = preheatCache;
        this.programIdScheme = programIdScheme;
        this.programStageIdScheme = programStageIdScheme;
        this.reportMode = reportMode;
        this.requireAttributeOptionCombo = requireAttributeOptionCombo;
        this.requireCategoryOptionCombo = requireCategoryOptionCombo;
        this.sharing = sharing;
        this.skipAudit = skipAudit;
        this.skipCache = skipCache;
        this.skipExistingCheck = skipExistingCheck;
        this.skipLastUpdated = skipLastUpdated;
        this.skipNotifications = skipNotifications;
        this.skipPatternValidation = skipPatternValidation;
        this.strictAttributeOptionCombos = strictAttributeOptionCombos;
        this.strictCategoryOptionCombos = strictCategoryOptionCombos;
        this.strictDataElements = strictDataElements;
        this.strictDataSetApproval = strictDataSetApproval;
        this.strictDataSetInputPeriods = strictDataSetInputPeriods;
        this.strictDataSetLocking = strictDataSetLocking;
        this.strictOrganisationUnits = strictOrganisationUnits;
        this.strictPeriods = strictPeriods;
        this.trackedEntityAttributeIdScheme = trackedEntityAttributeIdScheme;
        this.trackedEntityIdScheme = trackedEntityIdScheme;
    }

    @JsonProperty("async")
    public Optional<Boolean> getAsync() {
        return Optional.ofNullable(async);
    }

    @JsonProperty("async")
    public void setAsync(Boolean async) {
        this.async = async;
    }

    public ImportOptions withAsync(Boolean async) {
        this.async = async;
        return this;
    }

    @JsonProperty("categoryIdScheme")
    public Optional<String> getCategoryIdScheme() {
        return Optional.ofNullable(categoryIdScheme);
    }

    @JsonProperty("categoryIdScheme")
    public void setCategoryIdScheme(String categoryIdScheme) {
        this.categoryIdScheme = categoryIdScheme;
    }

    public ImportOptions withCategoryIdScheme(String categoryIdScheme) {
        this.categoryIdScheme = categoryIdScheme;
        return this;
    }

    @JsonProperty("categoryOptionComboIdScheme")
    public Optional<String> getCategoryOptionComboIdScheme() {
        return Optional.ofNullable(categoryOptionComboIdScheme);
    }

    @JsonProperty("categoryOptionComboIdScheme")
    public void setCategoryOptionComboIdScheme(String categoryOptionComboIdScheme) {
        this.categoryOptionComboIdScheme = categoryOptionComboIdScheme;
    }

    public ImportOptions withCategoryOptionComboIdScheme(String categoryOptionComboIdScheme) {
        this.categoryOptionComboIdScheme = categoryOptionComboIdScheme;
        return this;
    }

    @JsonProperty("categoryOptionIdScheme")
    public Optional<String> getCategoryOptionIdScheme() {
        return Optional.ofNullable(categoryOptionIdScheme);
    }

    @JsonProperty("categoryOptionIdScheme")
    public void setCategoryOptionIdScheme(String categoryOptionIdScheme) {
        this.categoryOptionIdScheme = categoryOptionIdScheme;
    }

    public ImportOptions withCategoryOptionIdScheme(String categoryOptionIdScheme) {
        this.categoryOptionIdScheme = categoryOptionIdScheme;
        return this;
    }

    @JsonProperty("dataElementIdScheme")
    public Optional<String> getDataElementIdScheme() {
        return Optional.ofNullable(dataElementIdScheme);
    }

    @JsonProperty("dataElementIdScheme")
    public void setDataElementIdScheme(String dataElementIdScheme) {
        this.dataElementIdScheme = dataElementIdScheme;
    }

    public ImportOptions withDataElementIdScheme(String dataElementIdScheme) {
        this.dataElementIdScheme = dataElementIdScheme;
        return this;
    }

    @JsonProperty("dataSet")
    public Optional<String> getDataSet() {
        return Optional.ofNullable(dataSet);
    }

    @JsonProperty("dataSet")
    public void setDataSet(String dataSet) {
        this.dataSet = dataSet;
    }

    public ImportOptions withDataSet(String dataSet) {
        this.dataSet = dataSet;
        return this;
    }

    @JsonProperty("dataSetIdScheme")
    public Optional<String> getDataSetIdScheme() {
        return Optional.ofNullable(dataSetIdScheme);
    }

    @JsonProperty("dataSetIdScheme")
    public void setDataSetIdScheme(String dataSetIdScheme) {
        this.dataSetIdScheme = dataSetIdScheme;
    }

    public ImportOptions withDataSetIdScheme(String dataSetIdScheme) {
        this.dataSetIdScheme = dataSetIdScheme;
        return this;
    }

    @JsonProperty("datasetAllowsPeriods")
    public Optional<Boolean> getDatasetAllowsPeriods() {
        return Optional.ofNullable(datasetAllowsPeriods);
    }

    @JsonProperty("datasetAllowsPeriods")
    public void setDatasetAllowsPeriods(Boolean datasetAllowsPeriods) {
        this.datasetAllowsPeriods = datasetAllowsPeriods;
    }

    public ImportOptions withDatasetAllowsPeriods(Boolean datasetAllowsPeriods) {
        this.datasetAllowsPeriods = datasetAllowsPeriods;
        return this;
    }

    @JsonProperty("dryRun")
    public Optional<Boolean> getDryRun() {
        return Optional.ofNullable(dryRun);
    }

    @JsonProperty("dryRun")
    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public ImportOptions withDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    @JsonProperty("eventIdScheme")
    public Optional<String> getEventIdScheme() {
        return Optional.ofNullable(eventIdScheme);
    }

    @JsonProperty("eventIdScheme")
    public void setEventIdScheme(String eventIdScheme) {
        this.eventIdScheme = eventIdScheme;
    }

    public ImportOptions withEventIdScheme(String eventIdScheme) {
        this.eventIdScheme = eventIdScheme;
        return this;
    }

    @JsonProperty("filename")
    public Optional<String> getFilename() {
        return Optional.ofNullable(filename);
    }

    @JsonProperty("filename")
    public void setFilename(String filename) {
        this.filename = filename;
    }

    public ImportOptions withFilename(String filename) {
        this.filename = filename;
        return this;
    }

    @JsonProperty("firstRowIsHeader")
    public Optional<Boolean> getFirstRowIsHeader() {
        return Optional.ofNullable(firstRowIsHeader);
    }

    @JsonProperty("firstRowIsHeader")
    public void setFirstRowIsHeader(Boolean firstRowIsHeader) {
        this.firstRowIsHeader = firstRowIsHeader;
    }

    public ImportOptions withFirstRowIsHeader(Boolean firstRowIsHeader) {
        this.firstRowIsHeader = firstRowIsHeader;
        return this;
    }

    @JsonProperty("force")
    public Optional<Boolean> getForce() {
        return Optional.ofNullable(force);
    }

    @JsonProperty("force")
    public void setForce(Boolean force) {
        this.force = force;
    }

    public ImportOptions withForce(Boolean force) {
        this.force = force;
        return this;
    }

    @JsonProperty("idScheme")
    public Optional<String> getIdScheme() {
        return Optional.ofNullable(idScheme);
    }

    @JsonProperty("idScheme")
    public void setIdScheme(String idScheme) {
        this.idScheme = idScheme;
    }

    public ImportOptions withIdScheme(String idScheme) {
        this.idScheme = idScheme;
        return this;
    }

    @JsonProperty("ignoreEmptyCollection")
    public Optional<Boolean> getIgnoreEmptyCollection() {
        return Optional.ofNullable(ignoreEmptyCollection);
    }

    @JsonProperty("ignoreEmptyCollection")
    public void setIgnoreEmptyCollection(Boolean ignoreEmptyCollection) {
        this.ignoreEmptyCollection = ignoreEmptyCollection;
    }

    public ImportOptions withIgnoreEmptyCollection(Boolean ignoreEmptyCollection) {
        this.ignoreEmptyCollection = ignoreEmptyCollection;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("importStrategy")
    public ImportOptions.ImportStrategyRef getImportStrategy() {
        return importStrategy;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("importStrategy")
    public void setImportStrategy(ImportOptions.ImportStrategyRef importStrategy) {
        this.importStrategy = importStrategy;
    }

    public ImportOptions withImportStrategy(ImportOptions.ImportStrategyRef importStrategy) {
        this.importStrategy = importStrategy;
        return this;
    }

    @JsonProperty("mergeDataValues")
    public Optional<Boolean> getMergeDataValues() {
        return Optional.ofNullable(mergeDataValues);
    }

    @JsonProperty("mergeDataValues")
    public void setMergeDataValues(Boolean mergeDataValues) {
        this.mergeDataValues = mergeDataValues;
    }

    public ImportOptions withMergeDataValues(Boolean mergeDataValues) {
        this.mergeDataValues = mergeDataValues;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mergeMode")
    public ImportOptions.MergeModeRef getMergeMode() {
        return mergeMode;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mergeMode")
    public void setMergeMode(ImportOptions.MergeModeRef mergeMode) {
        this.mergeMode = mergeMode;
    }

    public ImportOptions withMergeMode(ImportOptions.MergeModeRef mergeMode) {
        this.mergeMode = mergeMode;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("notificationLevel")
    public ImportOptions.NotificationLevelRef getNotificationLevel() {
        return notificationLevel;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("notificationLevel")
    public void setNotificationLevel(ImportOptions.NotificationLevelRef notificationLevel) {
        this.notificationLevel = notificationLevel;
    }

    public ImportOptions withNotificationLevel(ImportOptions.NotificationLevelRef notificationLevel) {
        this.notificationLevel = notificationLevel;
        return this;
    }

    @JsonProperty("orgUnitIdScheme")
    public Optional<String> getOrgUnitIdScheme() {
        return Optional.ofNullable(orgUnitIdScheme);
    }

    @JsonProperty("orgUnitIdScheme")
    public void setOrgUnitIdScheme(String orgUnitIdScheme) {
        this.orgUnitIdScheme = orgUnitIdScheme;
    }

    public ImportOptions withOrgUnitIdScheme(String orgUnitIdScheme) {
        this.orgUnitIdScheme = orgUnitIdScheme;
        return this;
    }

    @JsonProperty("preheatCache")
    public Optional<Boolean> getPreheatCache() {
        return Optional.ofNullable(preheatCache);
    }

    @JsonProperty("preheatCache")
    public void setPreheatCache(Boolean preheatCache) {
        this.preheatCache = preheatCache;
    }

    public ImportOptions withPreheatCache(Boolean preheatCache) {
        this.preheatCache = preheatCache;
        return this;
    }

    @JsonProperty("programIdScheme")
    public Optional<String> getProgramIdScheme() {
        return Optional.ofNullable(programIdScheme);
    }

    @JsonProperty("programIdScheme")
    public void setProgramIdScheme(String programIdScheme) {
        this.programIdScheme = programIdScheme;
    }

    public ImportOptions withProgramIdScheme(String programIdScheme) {
        this.programIdScheme = programIdScheme;
        return this;
    }

    @JsonProperty("programStageIdScheme")
    public Optional<String> getProgramStageIdScheme() {
        return Optional.ofNullable(programStageIdScheme);
    }

    @JsonProperty("programStageIdScheme")
    public void setProgramStageIdScheme(String programStageIdScheme) {
        this.programStageIdScheme = programStageIdScheme;
    }

    public ImportOptions withProgramStageIdScheme(String programStageIdScheme) {
        this.programStageIdScheme = programStageIdScheme;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("reportMode")
    public ImportOptions.ReportModeRef getReportMode() {
        return reportMode;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("reportMode")
    public void setReportMode(ImportOptions.ReportModeRef reportMode) {
        this.reportMode = reportMode;
    }

    public ImportOptions withReportMode(ImportOptions.ReportModeRef reportMode) {
        this.reportMode = reportMode;
        return this;
    }

    @JsonProperty("requireAttributeOptionCombo")
    public Optional<Boolean> getRequireAttributeOptionCombo() {
        return Optional.ofNullable(requireAttributeOptionCombo);
    }

    @JsonProperty("requireAttributeOptionCombo")
    public void setRequireAttributeOptionCombo(Boolean requireAttributeOptionCombo) {
        this.requireAttributeOptionCombo = requireAttributeOptionCombo;
    }

    public ImportOptions withRequireAttributeOptionCombo(Boolean requireAttributeOptionCombo) {
        this.requireAttributeOptionCombo = requireAttributeOptionCombo;
        return this;
    }

    @JsonProperty("requireCategoryOptionCombo")
    public Optional<Boolean> getRequireCategoryOptionCombo() {
        return Optional.ofNullable(requireCategoryOptionCombo);
    }

    @JsonProperty("requireCategoryOptionCombo")
    public void setRequireCategoryOptionCombo(Boolean requireCategoryOptionCombo) {
        this.requireCategoryOptionCombo = requireCategoryOptionCombo;
    }

    public ImportOptions withRequireCategoryOptionCombo(Boolean requireCategoryOptionCombo) {
        this.requireCategoryOptionCombo = requireCategoryOptionCombo;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Boolean> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Boolean sharing) {
        this.sharing = sharing;
    }

    public ImportOptions withSharing(Boolean sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("skipAudit")
    public Optional<Boolean> getSkipAudit() {
        return Optional.ofNullable(skipAudit);
    }

    @JsonProperty("skipAudit")
    public void setSkipAudit(Boolean skipAudit) {
        this.skipAudit = skipAudit;
    }

    public ImportOptions withSkipAudit(Boolean skipAudit) {
        this.skipAudit = skipAudit;
        return this;
    }

    @JsonProperty("skipCache")
    public Optional<Boolean> getSkipCache() {
        return Optional.ofNullable(skipCache);
    }

    @JsonProperty("skipCache")
    public void setSkipCache(Boolean skipCache) {
        this.skipCache = skipCache;
    }

    public ImportOptions withSkipCache(Boolean skipCache) {
        this.skipCache = skipCache;
        return this;
    }

    @JsonProperty("skipExistingCheck")
    public Optional<Boolean> getSkipExistingCheck() {
        return Optional.ofNullable(skipExistingCheck);
    }

    @JsonProperty("skipExistingCheck")
    public void setSkipExistingCheck(Boolean skipExistingCheck) {
        this.skipExistingCheck = skipExistingCheck;
    }

    public ImportOptions withSkipExistingCheck(Boolean skipExistingCheck) {
        this.skipExistingCheck = skipExistingCheck;
        return this;
    }

    @JsonProperty("skipLastUpdated")
    public Optional<Boolean> getSkipLastUpdated() {
        return Optional.ofNullable(skipLastUpdated);
    }

    @JsonProperty("skipLastUpdated")
    public void setSkipLastUpdated(Boolean skipLastUpdated) {
        this.skipLastUpdated = skipLastUpdated;
    }

    public ImportOptions withSkipLastUpdated(Boolean skipLastUpdated) {
        this.skipLastUpdated = skipLastUpdated;
        return this;
    }

    @JsonProperty("skipNotifications")
    public Optional<Boolean> getSkipNotifications() {
        return Optional.ofNullable(skipNotifications);
    }

    @JsonProperty("skipNotifications")
    public void setSkipNotifications(Boolean skipNotifications) {
        this.skipNotifications = skipNotifications;
    }

    public ImportOptions withSkipNotifications(Boolean skipNotifications) {
        this.skipNotifications = skipNotifications;
        return this;
    }

    @JsonProperty("skipPatternValidation")
    public Optional<Boolean> getSkipPatternValidation() {
        return Optional.ofNullable(skipPatternValidation);
    }

    @JsonProperty("skipPatternValidation")
    public void setSkipPatternValidation(Boolean skipPatternValidation) {
        this.skipPatternValidation = skipPatternValidation;
    }

    public ImportOptions withSkipPatternValidation(Boolean skipPatternValidation) {
        this.skipPatternValidation = skipPatternValidation;
        return this;
    }

    @JsonProperty("strictAttributeOptionCombos")
    public Optional<Boolean> getStrictAttributeOptionCombos() {
        return Optional.ofNullable(strictAttributeOptionCombos);
    }

    @JsonProperty("strictAttributeOptionCombos")
    public void setStrictAttributeOptionCombos(Boolean strictAttributeOptionCombos) {
        this.strictAttributeOptionCombos = strictAttributeOptionCombos;
    }

    public ImportOptions withStrictAttributeOptionCombos(Boolean strictAttributeOptionCombos) {
        this.strictAttributeOptionCombos = strictAttributeOptionCombos;
        return this;
    }

    @JsonProperty("strictCategoryOptionCombos")
    public Optional<Boolean> getStrictCategoryOptionCombos() {
        return Optional.ofNullable(strictCategoryOptionCombos);
    }

    @JsonProperty("strictCategoryOptionCombos")
    public void setStrictCategoryOptionCombos(Boolean strictCategoryOptionCombos) {
        this.strictCategoryOptionCombos = strictCategoryOptionCombos;
    }

    public ImportOptions withStrictCategoryOptionCombos(Boolean strictCategoryOptionCombos) {
        this.strictCategoryOptionCombos = strictCategoryOptionCombos;
        return this;
    }

    @JsonProperty("strictDataElements")
    public Optional<Boolean> getStrictDataElements() {
        return Optional.ofNullable(strictDataElements);
    }

    @JsonProperty("strictDataElements")
    public void setStrictDataElements(Boolean strictDataElements) {
        this.strictDataElements = strictDataElements;
    }

    public ImportOptions withStrictDataElements(Boolean strictDataElements) {
        this.strictDataElements = strictDataElements;
        return this;
    }

    @JsonProperty("strictDataSetApproval")
    public Optional<Boolean> getStrictDataSetApproval() {
        return Optional.ofNullable(strictDataSetApproval);
    }

    @JsonProperty("strictDataSetApproval")
    public void setStrictDataSetApproval(Boolean strictDataSetApproval) {
        this.strictDataSetApproval = strictDataSetApproval;
    }

    public ImportOptions withStrictDataSetApproval(Boolean strictDataSetApproval) {
        this.strictDataSetApproval = strictDataSetApproval;
        return this;
    }

    @JsonProperty("strictDataSetInputPeriods")
    public Optional<Boolean> getStrictDataSetInputPeriods() {
        return Optional.ofNullable(strictDataSetInputPeriods);
    }

    @JsonProperty("strictDataSetInputPeriods")
    public void setStrictDataSetInputPeriods(Boolean strictDataSetInputPeriods) {
        this.strictDataSetInputPeriods = strictDataSetInputPeriods;
    }

    public ImportOptions withStrictDataSetInputPeriods(Boolean strictDataSetInputPeriods) {
        this.strictDataSetInputPeriods = strictDataSetInputPeriods;
        return this;
    }

    @JsonProperty("strictDataSetLocking")
    public Optional<Boolean> getStrictDataSetLocking() {
        return Optional.ofNullable(strictDataSetLocking);
    }

    @JsonProperty("strictDataSetLocking")
    public void setStrictDataSetLocking(Boolean strictDataSetLocking) {
        this.strictDataSetLocking = strictDataSetLocking;
    }

    public ImportOptions withStrictDataSetLocking(Boolean strictDataSetLocking) {
        this.strictDataSetLocking = strictDataSetLocking;
        return this;
    }

    @JsonProperty("strictOrganisationUnits")
    public Optional<Boolean> getStrictOrganisationUnits() {
        return Optional.ofNullable(strictOrganisationUnits);
    }

    @JsonProperty("strictOrganisationUnits")
    public void setStrictOrganisationUnits(Boolean strictOrganisationUnits) {
        this.strictOrganisationUnits = strictOrganisationUnits;
    }

    public ImportOptions withStrictOrganisationUnits(Boolean strictOrganisationUnits) {
        this.strictOrganisationUnits = strictOrganisationUnits;
        return this;
    }

    @JsonProperty("strictPeriods")
    public Optional<Boolean> getStrictPeriods() {
        return Optional.ofNullable(strictPeriods);
    }

    @JsonProperty("strictPeriods")
    public void setStrictPeriods(Boolean strictPeriods) {
        this.strictPeriods = strictPeriods;
    }

    public ImportOptions withStrictPeriods(Boolean strictPeriods) {
        this.strictPeriods = strictPeriods;
        return this;
    }

    @JsonProperty("trackedEntityAttributeIdScheme")
    public Optional<String> getTrackedEntityAttributeIdScheme() {
        return Optional.ofNullable(trackedEntityAttributeIdScheme);
    }

    @JsonProperty("trackedEntityAttributeIdScheme")
    public void setTrackedEntityAttributeIdScheme(String trackedEntityAttributeIdScheme) {
        this.trackedEntityAttributeIdScheme = trackedEntityAttributeIdScheme;
    }

    public ImportOptions withTrackedEntityAttributeIdScheme(String trackedEntityAttributeIdScheme) {
        this.trackedEntityAttributeIdScheme = trackedEntityAttributeIdScheme;
        return this;
    }

    @JsonProperty("trackedEntityIdScheme")
    public Optional<String> getTrackedEntityIdScheme() {
        return Optional.ofNullable(trackedEntityIdScheme);
    }

    @JsonProperty("trackedEntityIdScheme")
    public void setTrackedEntityIdScheme(String trackedEntityIdScheme) {
        this.trackedEntityIdScheme = trackedEntityIdScheme;
    }

    public ImportOptions withTrackedEntityIdScheme(String trackedEntityIdScheme) {
        this.trackedEntityIdScheme = trackedEntityIdScheme;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ImportOptions withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("async".equals(name)) {
            if (value instanceof Boolean) {
                setAsync(((Boolean) value));
            } else {
                throw new IllegalArgumentException(("property \"async\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("categoryIdScheme".equals(name)) {
                if (value instanceof String) {
                    setCategoryIdScheme(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"categoryIdScheme\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("categoryOptionComboIdScheme".equals(name)) {
                    if (value instanceof String) {
                        setCategoryOptionComboIdScheme(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"categoryOptionComboIdScheme\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("categoryOptionIdScheme".equals(name)) {
                        if (value instanceof String) {
                            setCategoryOptionIdScheme(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"categoryOptionIdScheme\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("dataElementIdScheme".equals(name)) {
                            if (value instanceof String) {
                                setDataElementIdScheme(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"dataElementIdScheme\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("dataSet".equals(name)) {
                                if (value instanceof String) {
                                    setDataSet(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"dataSet\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("dataSetIdScheme".equals(name)) {
                                    if (value instanceof String) {
                                        setDataSetIdScheme(((String) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"dataSetIdScheme\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("datasetAllowsPeriods".equals(name)) {
                                        if (value instanceof Boolean) {
                                            setDatasetAllowsPeriods(((Boolean) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"datasetAllowsPeriods\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("dryRun".equals(name)) {
                                            if (value instanceof Boolean) {
                                                setDryRun(((Boolean) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"dryRun\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("eventIdScheme".equals(name)) {
                                                if (value instanceof String) {
                                                    setEventIdScheme(((String) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"eventIdScheme\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("filename".equals(name)) {
                                                    if (value instanceof String) {
                                                        setFilename(((String) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"filename\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("firstRowIsHeader".equals(name)) {
                                                        if (value instanceof Boolean) {
                                                            setFirstRowIsHeader(((Boolean) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"firstRowIsHeader\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("force".equals(name)) {
                                                            if (value instanceof Boolean) {
                                                                setForce(((Boolean) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"force\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("idScheme".equals(name)) {
                                                                if (value instanceof String) {
                                                                    setIdScheme(((String) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"idScheme\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("ignoreEmptyCollection".equals(name)) {
                                                                    if (value instanceof Boolean) {
                                                                        setIgnoreEmptyCollection(((Boolean) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"ignoreEmptyCollection\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("importStrategy".equals(name)) {
                                                                        if (value instanceof ImportOptions.ImportStrategyRef) {
                                                                            setImportStrategy(((ImportOptions.ImportStrategyRef) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"importStrategy\" is of type \"org.hisp.dhis.api.model.v40_2_2.ImportOptions.ImportStrategyRef\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("mergeDataValues".equals(name)) {
                                                                            if (value instanceof Boolean) {
                                                                                setMergeDataValues(((Boolean) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"mergeDataValues\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("mergeMode".equals(name)) {
                                                                                if (value instanceof ImportOptions.MergeModeRef) {
                                                                                    setMergeMode(((ImportOptions.MergeModeRef) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"mergeMode\" is of type \"org.hisp.dhis.api.model.v40_2_2.ImportOptions.MergeModeRef\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("notificationLevel".equals(name)) {
                                                                                    if (value instanceof ImportOptions.NotificationLevelRef) {
                                                                                        setNotificationLevel(((ImportOptions.NotificationLevelRef) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"notificationLevel\" is of type \"org.hisp.dhis.api.model.v40_2_2.ImportOptions.NotificationLevelRef\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("orgUnitIdScheme".equals(name)) {
                                                                                        if (value instanceof String) {
                                                                                            setOrgUnitIdScheme(((String) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"orgUnitIdScheme\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("preheatCache".equals(name)) {
                                                                                            if (value instanceof Boolean) {
                                                                                                setPreheatCache(((Boolean) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"preheatCache\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("programIdScheme".equals(name)) {
                                                                                                if (value instanceof String) {
                                                                                                    setProgramIdScheme(((String) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"programIdScheme\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("programStageIdScheme".equals(name)) {
                                                                                                    if (value instanceof String) {
                                                                                                        setProgramStageIdScheme(((String) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"programStageIdScheme\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("reportMode".equals(name)) {
                                                                                                        if (value instanceof ImportOptions.ReportModeRef) {
                                                                                                            setReportMode(((ImportOptions.ReportModeRef) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"reportMode\" is of type \"org.hisp.dhis.api.model.v40_2_2.ImportOptions.ReportModeRef\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("requireAttributeOptionCombo".equals(name)) {
                                                                                                            if (value instanceof Boolean) {
                                                                                                                setRequireAttributeOptionCombo(((Boolean) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"requireAttributeOptionCombo\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("requireCategoryOptionCombo".equals(name)) {
                                                                                                                if (value instanceof Boolean) {
                                                                                                                    setRequireCategoryOptionCombo(((Boolean) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"requireCategoryOptionCombo\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                if ("sharing".equals(name)) {
                                                                                                                    if (value instanceof Boolean) {
                                                                                                                        setSharing(((Boolean) value));
                                                                                                                    } else {
                                                                                                                        throw new IllegalArgumentException(("property \"sharing\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                    }
                                                                                                                    return true;
                                                                                                                } else {
                                                                                                                    if ("skipAudit".equals(name)) {
                                                                                                                        if (value instanceof Boolean) {
                                                                                                                            setSkipAudit(((Boolean) value));
                                                                                                                        } else {
                                                                                                                            throw new IllegalArgumentException(("property \"skipAudit\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                        }
                                                                                                                        return true;
                                                                                                                    } else {
                                                                                                                        if ("skipCache".equals(name)) {
                                                                                                                            if (value instanceof Boolean) {
                                                                                                                                setSkipCache(((Boolean) value));
                                                                                                                            } else {
                                                                                                                                throw new IllegalArgumentException(("property \"skipCache\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                            }
                                                                                                                            return true;
                                                                                                                        } else {
                                                                                                                            if ("skipExistingCheck".equals(name)) {
                                                                                                                                if (value instanceof Boolean) {
                                                                                                                                    setSkipExistingCheck(((Boolean) value));
                                                                                                                                } else {
                                                                                                                                    throw new IllegalArgumentException(("property \"skipExistingCheck\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                }
                                                                                                                                return true;
                                                                                                                            } else {
                                                                                                                                if ("skipLastUpdated".equals(name)) {
                                                                                                                                    if (value instanceof Boolean) {
                                                                                                                                        setSkipLastUpdated(((Boolean) value));
                                                                                                                                    } else {
                                                                                                                                        throw new IllegalArgumentException(("property \"skipLastUpdated\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                    }
                                                                                                                                    return true;
                                                                                                                                } else {
                                                                                                                                    if ("skipNotifications".equals(name)) {
                                                                                                                                        if (value instanceof Boolean) {
                                                                                                                                            setSkipNotifications(((Boolean) value));
                                                                                                                                        } else {
                                                                                                                                            throw new IllegalArgumentException(("property \"skipNotifications\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                        }
                                                                                                                                        return true;
                                                                                                                                    } else {
                                                                                                                                        if ("skipPatternValidation".equals(name)) {
                                                                                                                                            if (value instanceof Boolean) {
                                                                                                                                                setSkipPatternValidation(((Boolean) value));
                                                                                                                                            } else {
                                                                                                                                                throw new IllegalArgumentException(("property \"skipPatternValidation\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                            }
                                                                                                                                            return true;
                                                                                                                                        } else {
                                                                                                                                            if ("strictAttributeOptionCombos".equals(name)) {
                                                                                                                                                if (value instanceof Boolean) {
                                                                                                                                                    setStrictAttributeOptionCombos(((Boolean) value));
                                                                                                                                                } else {
                                                                                                                                                    throw new IllegalArgumentException(("property \"strictAttributeOptionCombos\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                }
                                                                                                                                                return true;
                                                                                                                                            } else {
                                                                                                                                                if ("strictCategoryOptionCombos".equals(name)) {
                                                                                                                                                    if (value instanceof Boolean) {
                                                                                                                                                        setStrictCategoryOptionCombos(((Boolean) value));
                                                                                                                                                    } else {
                                                                                                                                                        throw new IllegalArgumentException(("property \"strictCategoryOptionCombos\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                    }
                                                                                                                                                    return true;
                                                                                                                                                } else {
                                                                                                                                                    if ("strictDataElements".equals(name)) {
                                                                                                                                                        if (value instanceof Boolean) {
                                                                                                                                                            setStrictDataElements(((Boolean) value));
                                                                                                                                                        } else {
                                                                                                                                                            throw new IllegalArgumentException(("property \"strictDataElements\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                        }
                                                                                                                                                        return true;
                                                                                                                                                    } else {
                                                                                                                                                        if ("strictDataSetApproval".equals(name)) {
                                                                                                                                                            if (value instanceof Boolean) {
                                                                                                                                                                setStrictDataSetApproval(((Boolean) value));
                                                                                                                                                            } else {
                                                                                                                                                                throw new IllegalArgumentException(("property \"strictDataSetApproval\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                            }
                                                                                                                                                            return true;
                                                                                                                                                        } else {
                                                                                                                                                            if ("strictDataSetInputPeriods".equals(name)) {
                                                                                                                                                                if (value instanceof Boolean) {
                                                                                                                                                                    setStrictDataSetInputPeriods(((Boolean) value));
                                                                                                                                                                } else {
                                                                                                                                                                    throw new IllegalArgumentException(("property \"strictDataSetInputPeriods\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                }
                                                                                                                                                                return true;
                                                                                                                                                            } else {
                                                                                                                                                                if ("strictDataSetLocking".equals(name)) {
                                                                                                                                                                    if (value instanceof Boolean) {
                                                                                                                                                                        setStrictDataSetLocking(((Boolean) value));
                                                                                                                                                                    } else {
                                                                                                                                                                        throw new IllegalArgumentException(("property \"strictDataSetLocking\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                    }
                                                                                                                                                                    return true;
                                                                                                                                                                } else {
                                                                                                                                                                    if ("strictOrganisationUnits".equals(name)) {
                                                                                                                                                                        if (value instanceof Boolean) {
                                                                                                                                                                            setStrictOrganisationUnits(((Boolean) value));
                                                                                                                                                                        } else {
                                                                                                                                                                            throw new IllegalArgumentException(("property \"strictOrganisationUnits\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                        }
                                                                                                                                                                        return true;
                                                                                                                                                                    } else {
                                                                                                                                                                        if ("strictPeriods".equals(name)) {
                                                                                                                                                                            if (value instanceof Boolean) {
                                                                                                                                                                                setStrictPeriods(((Boolean) value));
                                                                                                                                                                            } else {
                                                                                                                                                                                throw new IllegalArgumentException(("property \"strictPeriods\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                            }
                                                                                                                                                                            return true;
                                                                                                                                                                        } else {
                                                                                                                                                                            if ("trackedEntityAttributeIdScheme".equals(name)) {
                                                                                                                                                                                if (value instanceof String) {
                                                                                                                                                                                    setTrackedEntityAttributeIdScheme(((String) value));
                                                                                                                                                                                } else {
                                                                                                                                                                                    throw new IllegalArgumentException(("property \"trackedEntityAttributeIdScheme\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                }
                                                                                                                                                                                return true;
                                                                                                                                                                            } else {
                                                                                                                                                                                if ("trackedEntityIdScheme".equals(name)) {
                                                                                                                                                                                    if (value instanceof String) {
                                                                                                                                                                                        setTrackedEntityIdScheme(((String) value));
                                                                                                                                                                                    } else {
                                                                                                                                                                                        throw new IllegalArgumentException(("property \"trackedEntityIdScheme\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                    }
                                                                                                                                                                                    return true;
                                                                                                                                                                                } else {
                                                                                                                                                                                    return false;
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("async".equals(name)) {
            return getAsync();
        } else {
            if ("categoryIdScheme".equals(name)) {
                return getCategoryIdScheme();
            } else {
                if ("categoryOptionComboIdScheme".equals(name)) {
                    return getCategoryOptionComboIdScheme();
                } else {
                    if ("categoryOptionIdScheme".equals(name)) {
                        return getCategoryOptionIdScheme();
                    } else {
                        if ("dataElementIdScheme".equals(name)) {
                            return getDataElementIdScheme();
                        } else {
                            if ("dataSet".equals(name)) {
                                return getDataSet();
                            } else {
                                if ("dataSetIdScheme".equals(name)) {
                                    return getDataSetIdScheme();
                                } else {
                                    if ("datasetAllowsPeriods".equals(name)) {
                                        return getDatasetAllowsPeriods();
                                    } else {
                                        if ("dryRun".equals(name)) {
                                            return getDryRun();
                                        } else {
                                            if ("eventIdScheme".equals(name)) {
                                                return getEventIdScheme();
                                            } else {
                                                if ("filename".equals(name)) {
                                                    return getFilename();
                                                } else {
                                                    if ("firstRowIsHeader".equals(name)) {
                                                        return getFirstRowIsHeader();
                                                    } else {
                                                        if ("force".equals(name)) {
                                                            return getForce();
                                                        } else {
                                                            if ("idScheme".equals(name)) {
                                                                return getIdScheme();
                                                            } else {
                                                                if ("ignoreEmptyCollection".equals(name)) {
                                                                    return getIgnoreEmptyCollection();
                                                                } else {
                                                                    if ("importStrategy".equals(name)) {
                                                                        return getImportStrategy();
                                                                    } else {
                                                                        if ("mergeDataValues".equals(name)) {
                                                                            return getMergeDataValues();
                                                                        } else {
                                                                            if ("mergeMode".equals(name)) {
                                                                                return getMergeMode();
                                                                            } else {
                                                                                if ("notificationLevel".equals(name)) {
                                                                                    return getNotificationLevel();
                                                                                } else {
                                                                                    if ("orgUnitIdScheme".equals(name)) {
                                                                                        return getOrgUnitIdScheme();
                                                                                    } else {
                                                                                        if ("preheatCache".equals(name)) {
                                                                                            return getPreheatCache();
                                                                                        } else {
                                                                                            if ("programIdScheme".equals(name)) {
                                                                                                return getProgramIdScheme();
                                                                                            } else {
                                                                                                if ("programStageIdScheme".equals(name)) {
                                                                                                    return getProgramStageIdScheme();
                                                                                                } else {
                                                                                                    if ("reportMode".equals(name)) {
                                                                                                        return getReportMode();
                                                                                                    } else {
                                                                                                        if ("requireAttributeOptionCombo".equals(name)) {
                                                                                                            return getRequireAttributeOptionCombo();
                                                                                                        } else {
                                                                                                            if ("requireCategoryOptionCombo".equals(name)) {
                                                                                                                return getRequireCategoryOptionCombo();
                                                                                                            } else {
                                                                                                                if ("sharing".equals(name)) {
                                                                                                                    return getSharing();
                                                                                                                } else {
                                                                                                                    if ("skipAudit".equals(name)) {
                                                                                                                        return getSkipAudit();
                                                                                                                    } else {
                                                                                                                        if ("skipCache".equals(name)) {
                                                                                                                            return getSkipCache();
                                                                                                                        } else {
                                                                                                                            if ("skipExistingCheck".equals(name)) {
                                                                                                                                return getSkipExistingCheck();
                                                                                                                            } else {
                                                                                                                                if ("skipLastUpdated".equals(name)) {
                                                                                                                                    return getSkipLastUpdated();
                                                                                                                                } else {
                                                                                                                                    if ("skipNotifications".equals(name)) {
                                                                                                                                        return getSkipNotifications();
                                                                                                                                    } else {
                                                                                                                                        if ("skipPatternValidation".equals(name)) {
                                                                                                                                            return getSkipPatternValidation();
                                                                                                                                        } else {
                                                                                                                                            if ("strictAttributeOptionCombos".equals(name)) {
                                                                                                                                                return getStrictAttributeOptionCombos();
                                                                                                                                            } else {
                                                                                                                                                if ("strictCategoryOptionCombos".equals(name)) {
                                                                                                                                                    return getStrictCategoryOptionCombos();
                                                                                                                                                } else {
                                                                                                                                                    if ("strictDataElements".equals(name)) {
                                                                                                                                                        return getStrictDataElements();
                                                                                                                                                    } else {
                                                                                                                                                        if ("strictDataSetApproval".equals(name)) {
                                                                                                                                                            return getStrictDataSetApproval();
                                                                                                                                                        } else {
                                                                                                                                                            if ("strictDataSetInputPeriods".equals(name)) {
                                                                                                                                                                return getStrictDataSetInputPeriods();
                                                                                                                                                            } else {
                                                                                                                                                                if ("strictDataSetLocking".equals(name)) {
                                                                                                                                                                    return getStrictDataSetLocking();
                                                                                                                                                                } else {
                                                                                                                                                                    if ("strictOrganisationUnits".equals(name)) {
                                                                                                                                                                        return getStrictOrganisationUnits();
                                                                                                                                                                    } else {
                                                                                                                                                                        if ("strictPeriods".equals(name)) {
                                                                                                                                                                            return getStrictPeriods();
                                                                                                                                                                        } else {
                                                                                                                                                                            if ("trackedEntityAttributeIdScheme".equals(name)) {
                                                                                                                                                                                return getTrackedEntityAttributeIdScheme();
                                                                                                                                                                            } else {
                                                                                                                                                                                if ("trackedEntityIdScheme".equals(name)) {
                                                                                                                                                                                    return getTrackedEntityIdScheme();
                                                                                                                                                                                } else {
                                                                                                                                                                                    return notFoundValue;
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ImportOptions.NOT_FOUND_VALUE);
        if (ImportOptions.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ImportOptions with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ImportOptions.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("async");
        sb.append('=');
        sb.append(((this.async == null)?"<null>":this.async));
        sb.append(',');
        sb.append("categoryIdScheme");
        sb.append('=');
        sb.append(((this.categoryIdScheme == null)?"<null>":this.categoryIdScheme));
        sb.append(',');
        sb.append("categoryOptionComboIdScheme");
        sb.append('=');
        sb.append(((this.categoryOptionComboIdScheme == null)?"<null>":this.categoryOptionComboIdScheme));
        sb.append(',');
        sb.append("categoryOptionIdScheme");
        sb.append('=');
        sb.append(((this.categoryOptionIdScheme == null)?"<null>":this.categoryOptionIdScheme));
        sb.append(',');
        sb.append("dataElementIdScheme");
        sb.append('=');
        sb.append(((this.dataElementIdScheme == null)?"<null>":this.dataElementIdScheme));
        sb.append(',');
        sb.append("dataSet");
        sb.append('=');
        sb.append(((this.dataSet == null)?"<null>":this.dataSet));
        sb.append(',');
        sb.append("dataSetIdScheme");
        sb.append('=');
        sb.append(((this.dataSetIdScheme == null)?"<null>":this.dataSetIdScheme));
        sb.append(',');
        sb.append("datasetAllowsPeriods");
        sb.append('=');
        sb.append(((this.datasetAllowsPeriods == null)?"<null>":this.datasetAllowsPeriods));
        sb.append(',');
        sb.append("dryRun");
        sb.append('=');
        sb.append(((this.dryRun == null)?"<null>":this.dryRun));
        sb.append(',');
        sb.append("eventIdScheme");
        sb.append('=');
        sb.append(((this.eventIdScheme == null)?"<null>":this.eventIdScheme));
        sb.append(',');
        sb.append("filename");
        sb.append('=');
        sb.append(((this.filename == null)?"<null>":this.filename));
        sb.append(',');
        sb.append("firstRowIsHeader");
        sb.append('=');
        sb.append(((this.firstRowIsHeader == null)?"<null>":this.firstRowIsHeader));
        sb.append(',');
        sb.append("force");
        sb.append('=');
        sb.append(((this.force == null)?"<null>":this.force));
        sb.append(',');
        sb.append("idScheme");
        sb.append('=');
        sb.append(((this.idScheme == null)?"<null>":this.idScheme));
        sb.append(',');
        sb.append("ignoreEmptyCollection");
        sb.append('=');
        sb.append(((this.ignoreEmptyCollection == null)?"<null>":this.ignoreEmptyCollection));
        sb.append(',');
        sb.append("importStrategy");
        sb.append('=');
        sb.append(((this.importStrategy == null)?"<null>":this.importStrategy));
        sb.append(',');
        sb.append("mergeDataValues");
        sb.append('=');
        sb.append(((this.mergeDataValues == null)?"<null>":this.mergeDataValues));
        sb.append(',');
        sb.append("mergeMode");
        sb.append('=');
        sb.append(((this.mergeMode == null)?"<null>":this.mergeMode));
        sb.append(',');
        sb.append("notificationLevel");
        sb.append('=');
        sb.append(((this.notificationLevel == null)?"<null>":this.notificationLevel));
        sb.append(',');
        sb.append("orgUnitIdScheme");
        sb.append('=');
        sb.append(((this.orgUnitIdScheme == null)?"<null>":this.orgUnitIdScheme));
        sb.append(',');
        sb.append("preheatCache");
        sb.append('=');
        sb.append(((this.preheatCache == null)?"<null>":this.preheatCache));
        sb.append(',');
        sb.append("programIdScheme");
        sb.append('=');
        sb.append(((this.programIdScheme == null)?"<null>":this.programIdScheme));
        sb.append(',');
        sb.append("programStageIdScheme");
        sb.append('=');
        sb.append(((this.programStageIdScheme == null)?"<null>":this.programStageIdScheme));
        sb.append(',');
        sb.append("reportMode");
        sb.append('=');
        sb.append(((this.reportMode == null)?"<null>":this.reportMode));
        sb.append(',');
        sb.append("requireAttributeOptionCombo");
        sb.append('=');
        sb.append(((this.requireAttributeOptionCombo == null)?"<null>":this.requireAttributeOptionCombo));
        sb.append(',');
        sb.append("requireCategoryOptionCombo");
        sb.append('=');
        sb.append(((this.requireCategoryOptionCombo == null)?"<null>":this.requireCategoryOptionCombo));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("skipAudit");
        sb.append('=');
        sb.append(((this.skipAudit == null)?"<null>":this.skipAudit));
        sb.append(',');
        sb.append("skipCache");
        sb.append('=');
        sb.append(((this.skipCache == null)?"<null>":this.skipCache));
        sb.append(',');
        sb.append("skipExistingCheck");
        sb.append('=');
        sb.append(((this.skipExistingCheck == null)?"<null>":this.skipExistingCheck));
        sb.append(',');
        sb.append("skipLastUpdated");
        sb.append('=');
        sb.append(((this.skipLastUpdated == null)?"<null>":this.skipLastUpdated));
        sb.append(',');
        sb.append("skipNotifications");
        sb.append('=');
        sb.append(((this.skipNotifications == null)?"<null>":this.skipNotifications));
        sb.append(',');
        sb.append("skipPatternValidation");
        sb.append('=');
        sb.append(((this.skipPatternValidation == null)?"<null>":this.skipPatternValidation));
        sb.append(',');
        sb.append("strictAttributeOptionCombos");
        sb.append('=');
        sb.append(((this.strictAttributeOptionCombos == null)?"<null>":this.strictAttributeOptionCombos));
        sb.append(',');
        sb.append("strictCategoryOptionCombos");
        sb.append('=');
        sb.append(((this.strictCategoryOptionCombos == null)?"<null>":this.strictCategoryOptionCombos));
        sb.append(',');
        sb.append("strictDataElements");
        sb.append('=');
        sb.append(((this.strictDataElements == null)?"<null>":this.strictDataElements));
        sb.append(',');
        sb.append("strictDataSetApproval");
        sb.append('=');
        sb.append(((this.strictDataSetApproval == null)?"<null>":this.strictDataSetApproval));
        sb.append(',');
        sb.append("strictDataSetInputPeriods");
        sb.append('=');
        sb.append(((this.strictDataSetInputPeriods == null)?"<null>":this.strictDataSetInputPeriods));
        sb.append(',');
        sb.append("strictDataSetLocking");
        sb.append('=');
        sb.append(((this.strictDataSetLocking == null)?"<null>":this.strictDataSetLocking));
        sb.append(',');
        sb.append("strictOrganisationUnits");
        sb.append('=');
        sb.append(((this.strictOrganisationUnits == null)?"<null>":this.strictOrganisationUnits));
        sb.append(',');
        sb.append("strictPeriods");
        sb.append('=');
        sb.append(((this.strictPeriods == null)?"<null>":this.strictPeriods));
        sb.append(',');
        sb.append("trackedEntityAttributeIdScheme");
        sb.append('=');
        sb.append(((this.trackedEntityAttributeIdScheme == null)?"<null>":this.trackedEntityAttributeIdScheme));
        sb.append(',');
        sb.append("trackedEntityIdScheme");
        sb.append('=');
        sb.append(((this.trackedEntityIdScheme == null)?"<null>":this.trackedEntityIdScheme));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.programIdScheme == null)? 0 :this.programIdScheme.hashCode()));
        result = ((result* 31)+((this.dryRun == null)? 0 :this.dryRun.hashCode()));
        result = ((result* 31)+((this.trackedEntityAttributeIdScheme == null)? 0 :this.trackedEntityAttributeIdScheme.hashCode()));
        result = ((result* 31)+((this.skipCache == null)? 0 :this.skipCache.hashCode()));
        result = ((result* 31)+((this.datasetAllowsPeriods == null)? 0 :this.datasetAllowsPeriods.hashCode()));
        result = ((result* 31)+((this.skipPatternValidation == null)? 0 :this.skipPatternValidation.hashCode()));
        result = ((result* 31)+((this.mergeMode == null)? 0 :this.mergeMode.hashCode()));
        result = ((result* 31)+((this.strictCategoryOptionCombos == null)? 0 :this.strictCategoryOptionCombos.hashCode()));
        result = ((result* 31)+((this.eventIdScheme == null)? 0 :this.eventIdScheme.hashCode()));
        result = ((result* 31)+((this.preheatCache == null)? 0 :this.preheatCache.hashCode()));
        result = ((result* 31)+((this.strictDataSetApproval == null)? 0 :this.strictDataSetApproval.hashCode()));
        result = ((result* 31)+((this.dataSet == null)? 0 :this.dataSet.hashCode()));
        result = ((result* 31)+((this.strictDataSetLocking == null)? 0 :this.strictDataSetLocking.hashCode()));
        result = ((result* 31)+((this.strictPeriods == null)? 0 :this.strictPeriods.hashCode()));
        result = ((result* 31)+((this.ignoreEmptyCollection == null)? 0 :this.ignoreEmptyCollection.hashCode()));
        result = ((result* 31)+((this.dataElementIdScheme == null)? 0 :this.dataElementIdScheme.hashCode()));
        result = ((result* 31)+((this.firstRowIsHeader == null)? 0 :this.firstRowIsHeader.hashCode()));
        result = ((result* 31)+((this.dataSetIdScheme == null)? 0 :this.dataSetIdScheme.hashCode()));
        result = ((result* 31)+((this.notificationLevel == null)? 0 :this.notificationLevel.hashCode()));
        result = ((result* 31)+((this.strictAttributeOptionCombos == null)? 0 :this.strictAttributeOptionCombos.hashCode()));
        result = ((result* 31)+((this.orgUnitIdScheme == null)? 0 :this.orgUnitIdScheme.hashCode()));
        result = ((result* 31)+((this.skipExistingCheck == null)? 0 :this.skipExistingCheck.hashCode()));
        result = ((result* 31)+((this.categoryIdScheme == null)? 0 :this.categoryIdScheme.hashCode()));
        result = ((result* 31)+((this.skipNotifications == null)? 0 :this.skipNotifications.hashCode()));
        result = ((result* 31)+((this.strictDataElements == null)? 0 :this.strictDataElements.hashCode()));
        result = ((result* 31)+((this.strictDataSetInputPeriods == null)? 0 :this.strictDataSetInputPeriods.hashCode()));
        result = ((result* 31)+((this.trackedEntityIdScheme == null)? 0 :this.trackedEntityIdScheme.hashCode()));
        result = ((result* 31)+((this.categoryOptionIdScheme == null)? 0 :this.categoryOptionIdScheme.hashCode()));
        result = ((result* 31)+((this.reportMode == null)? 0 :this.reportMode.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.requireAttributeOptionCombo == null)? 0 :this.requireAttributeOptionCombo.hashCode()));
        result = ((result* 31)+((this.skipAudit == null)? 0 :this.skipAudit.hashCode()));
        result = ((result* 31)+((this.idScheme == null)? 0 :this.idScheme.hashCode()));
        result = ((result* 31)+((this.async == null)? 0 :this.async.hashCode()));
        result = ((result* 31)+((this.filename == null)? 0 :this.filename.hashCode()));
        result = ((result* 31)+((this.requireCategoryOptionCombo == null)? 0 :this.requireCategoryOptionCombo.hashCode()));
        result = ((result* 31)+((this.force == null)? 0 :this.force.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.categoryOptionComboIdScheme == null)? 0 :this.categoryOptionComboIdScheme.hashCode()));
        result = ((result* 31)+((this.importStrategy == null)? 0 :this.importStrategy.hashCode()));
        result = ((result* 31)+((this.programStageIdScheme == null)? 0 :this.programStageIdScheme.hashCode()));
        result = ((result* 31)+((this.strictOrganisationUnits == null)? 0 :this.strictOrganisationUnits.hashCode()));
        result = ((result* 31)+((this.mergeDataValues == null)? 0 :this.mergeDataValues.hashCode()));
        result = ((result* 31)+((this.skipLastUpdated == null)? 0 :this.skipLastUpdated.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ImportOptions) == false) {
            return false;
        }
        ImportOptions rhs = ((ImportOptions) other);
        return (((((((((((((((((((((((((((((((((((((((((((((this.programIdScheme == rhs.programIdScheme)||((this.programIdScheme!= null)&&this.programIdScheme.equals(rhs.programIdScheme)))&&((this.dryRun == rhs.dryRun)||((this.dryRun!= null)&&this.dryRun.equals(rhs.dryRun))))&&((this.trackedEntityAttributeIdScheme == rhs.trackedEntityAttributeIdScheme)||((this.trackedEntityAttributeIdScheme!= null)&&this.trackedEntityAttributeIdScheme.equals(rhs.trackedEntityAttributeIdScheme))))&&((this.skipCache == rhs.skipCache)||((this.skipCache!= null)&&this.skipCache.equals(rhs.skipCache))))&&((this.datasetAllowsPeriods == rhs.datasetAllowsPeriods)||((this.datasetAllowsPeriods!= null)&&this.datasetAllowsPeriods.equals(rhs.datasetAllowsPeriods))))&&((this.skipPatternValidation == rhs.skipPatternValidation)||((this.skipPatternValidation!= null)&&this.skipPatternValidation.equals(rhs.skipPatternValidation))))&&((this.mergeMode == rhs.mergeMode)||((this.mergeMode!= null)&&this.mergeMode.equals(rhs.mergeMode))))&&((this.strictCategoryOptionCombos == rhs.strictCategoryOptionCombos)||((this.strictCategoryOptionCombos!= null)&&this.strictCategoryOptionCombos.equals(rhs.strictCategoryOptionCombos))))&&((this.eventIdScheme == rhs.eventIdScheme)||((this.eventIdScheme!= null)&&this.eventIdScheme.equals(rhs.eventIdScheme))))&&((this.preheatCache == rhs.preheatCache)||((this.preheatCache!= null)&&this.preheatCache.equals(rhs.preheatCache))))&&((this.strictDataSetApproval == rhs.strictDataSetApproval)||((this.strictDataSetApproval!= null)&&this.strictDataSetApproval.equals(rhs.strictDataSetApproval))))&&((this.dataSet == rhs.dataSet)||((this.dataSet!= null)&&this.dataSet.equals(rhs.dataSet))))&&((this.strictDataSetLocking == rhs.strictDataSetLocking)||((this.strictDataSetLocking!= null)&&this.strictDataSetLocking.equals(rhs.strictDataSetLocking))))&&((this.strictPeriods == rhs.strictPeriods)||((this.strictPeriods!= null)&&this.strictPeriods.equals(rhs.strictPeriods))))&&((this.ignoreEmptyCollection == rhs.ignoreEmptyCollection)||((this.ignoreEmptyCollection!= null)&&this.ignoreEmptyCollection.equals(rhs.ignoreEmptyCollection))))&&((this.dataElementIdScheme == rhs.dataElementIdScheme)||((this.dataElementIdScheme!= null)&&this.dataElementIdScheme.equals(rhs.dataElementIdScheme))))&&((this.firstRowIsHeader == rhs.firstRowIsHeader)||((this.firstRowIsHeader!= null)&&this.firstRowIsHeader.equals(rhs.firstRowIsHeader))))&&((this.dataSetIdScheme == rhs.dataSetIdScheme)||((this.dataSetIdScheme!= null)&&this.dataSetIdScheme.equals(rhs.dataSetIdScheme))))&&((this.notificationLevel == rhs.notificationLevel)||((this.notificationLevel!= null)&&this.notificationLevel.equals(rhs.notificationLevel))))&&((this.strictAttributeOptionCombos == rhs.strictAttributeOptionCombos)||((this.strictAttributeOptionCombos!= null)&&this.strictAttributeOptionCombos.equals(rhs.strictAttributeOptionCombos))))&&((this.orgUnitIdScheme == rhs.orgUnitIdScheme)||((this.orgUnitIdScheme!= null)&&this.orgUnitIdScheme.equals(rhs.orgUnitIdScheme))))&&((this.skipExistingCheck == rhs.skipExistingCheck)||((this.skipExistingCheck!= null)&&this.skipExistingCheck.equals(rhs.skipExistingCheck))))&&((this.categoryIdScheme == rhs.categoryIdScheme)||((this.categoryIdScheme!= null)&&this.categoryIdScheme.equals(rhs.categoryIdScheme))))&&((this.skipNotifications == rhs.skipNotifications)||((this.skipNotifications!= null)&&this.skipNotifications.equals(rhs.skipNotifications))))&&((this.strictDataElements == rhs.strictDataElements)||((this.strictDataElements!= null)&&this.strictDataElements.equals(rhs.strictDataElements))))&&((this.strictDataSetInputPeriods == rhs.strictDataSetInputPeriods)||((this.strictDataSetInputPeriods!= null)&&this.strictDataSetInputPeriods.equals(rhs.strictDataSetInputPeriods))))&&((this.trackedEntityIdScheme == rhs.trackedEntityIdScheme)||((this.trackedEntityIdScheme!= null)&&this.trackedEntityIdScheme.equals(rhs.trackedEntityIdScheme))))&&((this.categoryOptionIdScheme == rhs.categoryOptionIdScheme)||((this.categoryOptionIdScheme!= null)&&this.categoryOptionIdScheme.equals(rhs.categoryOptionIdScheme))))&&((this.reportMode == rhs.reportMode)||((this.reportMode!= null)&&this.reportMode.equals(rhs.reportMode))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.requireAttributeOptionCombo == rhs.requireAttributeOptionCombo)||((this.requireAttributeOptionCombo!= null)&&this.requireAttributeOptionCombo.equals(rhs.requireAttributeOptionCombo))))&&((this.skipAudit == rhs.skipAudit)||((this.skipAudit!= null)&&this.skipAudit.equals(rhs.skipAudit))))&&((this.idScheme == rhs.idScheme)||((this.idScheme!= null)&&this.idScheme.equals(rhs.idScheme))))&&((this.async == rhs.async)||((this.async!= null)&&this.async.equals(rhs.async))))&&((this.filename == rhs.filename)||((this.filename!= null)&&this.filename.equals(rhs.filename))))&&((this.requireCategoryOptionCombo == rhs.requireCategoryOptionCombo)||((this.requireCategoryOptionCombo!= null)&&this.requireCategoryOptionCombo.equals(rhs.requireCategoryOptionCombo))))&&((this.force == rhs.force)||((this.force!= null)&&this.force.equals(rhs.force))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.categoryOptionComboIdScheme == rhs.categoryOptionComboIdScheme)||((this.categoryOptionComboIdScheme!= null)&&this.categoryOptionComboIdScheme.equals(rhs.categoryOptionComboIdScheme))))&&((this.importStrategy == rhs.importStrategy)||((this.importStrategy!= null)&&this.importStrategy.equals(rhs.importStrategy))))&&((this.programStageIdScheme == rhs.programStageIdScheme)||((this.programStageIdScheme!= null)&&this.programStageIdScheme.equals(rhs.programStageIdScheme))))&&((this.strictOrganisationUnits == rhs.strictOrganisationUnits)||((this.strictOrganisationUnits!= null)&&this.strictOrganisationUnits.equals(rhs.strictOrganisationUnits))))&&((this.mergeDataValues == rhs.mergeDataValues)||((this.mergeDataValues!= null)&&this.mergeDataValues.equals(rhs.mergeDataValues))))&&((this.skipLastUpdated == rhs.skipLastUpdated)||((this.skipLastUpdated!= null)&&this.skipLastUpdated.equals(rhs.skipLastUpdated))));
    }

    @Generated("jsonschema2pojo")
    public enum ImportStrategyRef {

        CREATE("CREATE"),
        UPDATE("UPDATE"),
        CREATE_AND_UPDATE("CREATE_AND_UPDATE"),
        DELETE("DELETE"),
        SYNC("SYNC"),
        NEW_AND_UPDATES("NEW_AND_UPDATES"),
        NEW("NEW"),
        UPDATES("UPDATES"),
        DELETES("DELETES");
        private final String value;
        private final static Map<String, ImportOptions.ImportStrategyRef> CONSTANTS = new HashMap<String, ImportOptions.ImportStrategyRef>();

        static {
            for (ImportOptions.ImportStrategyRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ImportStrategyRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ImportOptions.ImportStrategyRef fromValue(String value) {
            ImportOptions.ImportStrategyRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum MergeModeRef {

        MERGE_ALWAYS("MERGE_ALWAYS"),
        MERGE_IF_NOT_NULL("MERGE_IF_NOT_NULL"),
        MERGE("MERGE"),
        REPLACE("REPLACE"),
        NONE("NONE");
        private final String value;
        private final static Map<String, ImportOptions.MergeModeRef> CONSTANTS = new HashMap<String, ImportOptions.MergeModeRef>();

        static {
            for (ImportOptions.MergeModeRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        MergeModeRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ImportOptions.MergeModeRef fromValue(String value) {
            ImportOptions.MergeModeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum NotificationLevelRef {

        OFF("OFF"),
        DEBUG("DEBUG"),
        LOOP("LOOP"),
        INFO("INFO"),
        WARN("WARN"),
        ERROR("ERROR");
        private final String value;
        private final static Map<String, ImportOptions.NotificationLevelRef> CONSTANTS = new HashMap<String, ImportOptions.NotificationLevelRef>();

        static {
            for (ImportOptions.NotificationLevelRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        NotificationLevelRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ImportOptions.NotificationLevelRef fromValue(String value) {
            ImportOptions.NotificationLevelRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ReportModeRef {

        FULL("FULL"),
        ERRORS("ERRORS"),
        ERRORS_NOT_OWNER("ERRORS_NOT_OWNER"),
        DEBUG("DEBUG");
        private final String value;
        private final static Map<String, ImportOptions.ReportModeRef> CONSTANTS = new HashMap<String, ImportOptions.ReportModeRef>();

        static {
            for (ImportOptions.ReportModeRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ReportModeRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ImportOptions.ReportModeRef fromValue(String value) {
            ImportOptions.ReportModeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
