
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "bootstrapServers",
    "clientId",
    "password",
    "topic",
    "type",
    "username"
})
@Generated("jsonschema2pojo")
public class KafkaTarget implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("bootstrapServers")
    private String bootstrapServers;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("clientId")
    private String clientId;
    @JsonProperty("password")
    private String password;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("topic")
    private String topic;
    @JsonProperty("type")
    private String type;
    @JsonProperty("username")
    private String username;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 6967931852959563355L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public KafkaTarget() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public KafkaTarget(KafkaTarget source) {
        super();
        this.bootstrapServers = source.bootstrapServers;
        this.clientId = source.clientId;
        this.password = source.password;
        this.topic = source.topic;
        this.type = source.type;
        this.username = source.username;
    }

    public KafkaTarget(String bootstrapServers, String clientId, String password, String topic, String type, String username) {
        super();
        this.bootstrapServers = bootstrapServers;
        this.clientId = clientId;
        this.password = password;
        this.topic = topic;
        this.type = type;
        this.username = username;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("bootstrapServers")
    public String getBootstrapServers() {
        return bootstrapServers;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("bootstrapServers")
    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    public KafkaTarget withBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("clientId")
    public String getClientId() {
        return clientId;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("clientId")
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public KafkaTarget withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @JsonProperty("password")
    public Optional<String> getPassword() {
        return Optional.ofNullable(password);
    }

    @JsonProperty("password")
    public void setPassword(String password) {
        this.password = password;
    }

    public KafkaTarget withPassword(String password) {
        this.password = password;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("topic")
    public String getTopic() {
        return topic;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("topic")
    public void setTopic(String topic) {
        this.topic = topic;
    }

    public KafkaTarget withTopic(String topic) {
        this.topic = topic;
        return this;
    }

    @JsonProperty("type")
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    @JsonProperty("type")
    public void setType(String type) {
        this.type = type;
    }

    public KafkaTarget withType(String type) {
        this.type = type;
        return this;
    }

    @JsonProperty("username")
    public Optional<String> getUsername() {
        return Optional.ofNullable(username);
    }

    @JsonProperty("username")
    public void setUsername(String username) {
        this.username = username;
    }

    public KafkaTarget withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public KafkaTarget withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("bootstrapServers".equals(name)) {
            if (value instanceof String) {
                setBootstrapServers(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"bootstrapServers\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("clientId".equals(name)) {
                if (value instanceof String) {
                    setClientId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"clientId\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("password".equals(name)) {
                    if (value instanceof String) {
                        setPassword(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"password\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("topic".equals(name)) {
                        if (value instanceof String) {
                            setTopic(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"topic\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("type".equals(name)) {
                            if (value instanceof String) {
                                setType(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"type\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("username".equals(name)) {
                                if (value instanceof String) {
                                    setUsername(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"username\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                return false;
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("bootstrapServers".equals(name)) {
            return getBootstrapServers();
        } else {
            if ("clientId".equals(name)) {
                return getClientId();
            } else {
                if ("password".equals(name)) {
                    return getPassword();
                } else {
                    if ("topic".equals(name)) {
                        return getTopic();
                    } else {
                        if ("type".equals(name)) {
                            return getType();
                        } else {
                            if ("username".equals(name)) {
                                return getUsername();
                            } else {
                                return notFoundValue;
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, KafkaTarget.NOT_FOUND_VALUE);
        if (KafkaTarget.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public KafkaTarget with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(KafkaTarget.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("bootstrapServers");
        sb.append('=');
        sb.append(((this.bootstrapServers == null)?"<null>":this.bootstrapServers));
        sb.append(',');
        sb.append("clientId");
        sb.append('=');
        sb.append(((this.clientId == null)?"<null>":this.clientId));
        sb.append(',');
        sb.append("password");
        sb.append('=');
        sb.append(((this.password == null)?"<null>":this.password));
        sb.append(',');
        sb.append("topic");
        sb.append('=');
        sb.append(((this.topic == null)?"<null>":this.topic));
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        sb.append("username");
        sb.append('=');
        sb.append(((this.username == null)?"<null>":this.username));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.password == null)? 0 :this.password.hashCode()));
        result = ((result* 31)+((this.clientId == null)? 0 :this.clientId.hashCode()));
        result = ((result* 31)+((this.bootstrapServers == null)? 0 :this.bootstrapServers.hashCode()));
        result = ((result* 31)+((this.topic == null)? 0 :this.topic.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        result = ((result* 31)+((this.username == null)? 0 :this.username.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof KafkaTarget) == false) {
            return false;
        }
        KafkaTarget rhs = ((KafkaTarget) other);
        return ((((((((this.password == rhs.password)||((this.password!= null)&&this.password.equals(rhs.password)))&&((this.clientId == rhs.clientId)||((this.clientId!= null)&&this.clientId.equals(rhs.clientId))))&&((this.bootstrapServers == rhs.bootstrapServers)||((this.bootstrapServers!= null)&&this.bootstrapServers.equals(rhs.bootstrapServers))))&&((this.topic == rhs.topic)||((this.topic!= null)&&this.topic.equals(rhs.topic))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type))))&&((this.username == rhs.username)||((this.username!= null)&&this.username.equals(rhs.username))));
    }

}
