
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "assignee",
    "attributeValues",
    "code",
    "created",
    "createdBy",
    "displayName",
    "extMessageId",
    "externalAccess",
    "favorite",
    "favorites",
    "followUp",
    "href",
    "id",
    "lastMessage",
    "lastSender",
    "lastSenderFirstname",
    "lastSenderSurname",
    "lastUpdated",
    "lastUpdatedBy",
    "messageCount",
    "messageType",
    "messages",
    "priority",
    "publicAccess",
    "read",
    "sharing",
    "status",
    "subject",
    "translations",
    "user",
    "userAccesses",
    "userFirstname",
    "userGroupAccesses",
    "userMessages",
    "userSurname"
})
@Generated("jsonschema2pojo")
public class MessageConversation implements Serializable
{

    @JsonProperty("access")
    private Access access;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("assignee")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private AssigneeRef assignee;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues;
    @JsonProperty("code")
    private String code;
    @JsonProperty("created")
    private Date created;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private CreatedByRef__48 createdBy;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("extMessageId")
    private String extMessageId;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites;
    @JsonProperty("followUp")
    private Boolean followUp;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("lastMessage")
    private Date lastMessage;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastSender")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private LastSenderRef lastSender;
    @JsonProperty("lastSenderFirstname")
    private String lastSenderFirstname;
    @JsonProperty("lastSenderSurname")
    private String lastSenderSurname;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private LastUpdatedByRef__48 lastUpdatedBy;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("messageCount")
    private Integer messageCount;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("messageType")
    private MessageConversation.MessageTypeRef messageType;
    @JsonProperty("messages")
    private List<MessagesRefRef> messages;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("priority")
    private MessageConversation.PriorityRef priority;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("read")
    private Boolean read;
    @JsonProperty("sharing")
    private Sharing sharing;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    private MessageConversation.StatusRef status;
    @JsonProperty("subject")
    private String subject;
    @JsonProperty("translations")
    private List<Translation> translations;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private UserRef__49 user;
    @JsonProperty("userAccesses")
    private List<LegacyUserAccess> userAccesses;
    @JsonProperty("userFirstname")
    private String userFirstname;
    @JsonProperty("userGroupAccesses")
    private List<LegacyUserGroupAccess> userGroupAccesses;
    @JsonProperty("userMessages")
    private List<UserMessage> userMessages;
    @JsonProperty("userSurname")
    private String userSurname;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 8031093606213216784L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public MessageConversation() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public MessageConversation(MessageConversation source) {
        super();
        this.access = source.access;
        this.assignee = source.assignee;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.displayName = source.displayName;
        this.extMessageId = source.extMessageId;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.followUp = source.followUp;
        this.href = source.href;
        this.id = source.id;
        this.lastMessage = source.lastMessage;
        this.lastSender = source.lastSender;
        this.lastSenderFirstname = source.lastSenderFirstname;
        this.lastSenderSurname = source.lastSenderSurname;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.messageCount = source.messageCount;
        this.messageType = source.messageType;
        this.messages = source.messages;
        this.priority = source.priority;
        this.publicAccess = source.publicAccess;
        this.read = source.read;
        this.sharing = source.sharing;
        this.status = source.status;
        this.subject = source.subject;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userFirstname = source.userFirstname;
        this.userGroupAccesses = source.userGroupAccesses;
        this.userMessages = source.userMessages;
        this.userSurname = source.userSurname;
    }

    /**
     * 
     * @param lastUpdatedBy
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     * @param lastSender
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     * @param createdBy
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     * @param assignee
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     * @param user
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     */
    public MessageConversation(Access access, AssigneeRef assignee, List<AttributeValue> attributeValues, String code, Date created, CreatedByRef__48 createdBy, String displayName, String extMessageId, Boolean externalAccess, Boolean favorite, List<String> favorites, Boolean followUp, String href, String id, Date lastMessage, LastSenderRef lastSender, String lastSenderFirstname, String lastSenderSurname, Date lastUpdated, LastUpdatedByRef__48 lastUpdatedBy, Integer messageCount, MessageConversation.MessageTypeRef messageType, List<MessagesRefRef> messages, MessageConversation.PriorityRef priority, String publicAccess, Boolean read, Sharing sharing, MessageConversation.StatusRef status, String subject, List<Translation> translations, UserRef__49 user, List<LegacyUserAccess> userAccesses, String userFirstname, List<LegacyUserGroupAccess> userGroupAccesses, List<UserMessage> userMessages, String userSurname) {
        super();
        this.access = access;
        this.assignee = assignee;
        this.attributeValues = attributeValues;
        this.code = code;
        this.created = created;
        this.createdBy = createdBy;
        this.displayName = displayName;
        this.extMessageId = extMessageId;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.followUp = followUp;
        this.href = href;
        this.id = id;
        this.lastMessage = lastMessage;
        this.lastSender = lastSender;
        this.lastSenderFirstname = lastSenderFirstname;
        this.lastSenderSurname = lastSenderSurname;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.messageCount = messageCount;
        this.messageType = messageType;
        this.messages = messages;
        this.priority = priority;
        this.publicAccess = publicAccess;
        this.read = read;
        this.sharing = sharing;
        this.status = status;
        this.subject = subject;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userFirstname = userFirstname;
        this.userGroupAccesses = userGroupAccesses;
        this.userMessages = userMessages;
        this.userSurname = userSurname;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public MessageConversation withAccess(Access access) {
        this.access = access;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("assignee")
    public Optional<AssigneeRef> getAssignee() {
        return Optional.ofNullable(assignee);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("assignee")
    public void setAssignee(AssigneeRef assignee) {
        this.assignee = assignee;
    }

    public MessageConversation withAssignee(AssigneeRef assignee) {
        this.assignee = assignee;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public MessageConversation withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public MessageConversation withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public MessageConversation withCreated(Date created) {
        this.created = created;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public Optional<CreatedByRef__48> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public void setCreatedBy(CreatedByRef__48 createdBy) {
        this.createdBy = createdBy;
    }

    public MessageConversation withCreatedBy(CreatedByRef__48 createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public MessageConversation withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("extMessageId")
    public Optional<String> getExtMessageId() {
        return Optional.ofNullable(extMessageId);
    }

    @JsonProperty("extMessageId")
    public void setExtMessageId(String extMessageId) {
        this.extMessageId = extMessageId;
    }

    public MessageConversation withExtMessageId(String extMessageId) {
        this.extMessageId = extMessageId;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public MessageConversation withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public MessageConversation withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public MessageConversation withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("followUp")
    public Optional<Boolean> getFollowUp() {
        return Optional.ofNullable(followUp);
    }

    @JsonProperty("followUp")
    public void setFollowUp(Boolean followUp) {
        this.followUp = followUp;
    }

    public MessageConversation withFollowUp(Boolean followUp) {
        this.followUp = followUp;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public MessageConversation withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public MessageConversation withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("lastMessage")
    public Optional<Date> getLastMessage() {
        return Optional.ofNullable(lastMessage);
    }

    @JsonProperty("lastMessage")
    public void setLastMessage(Date lastMessage) {
        this.lastMessage = lastMessage;
    }

    public MessageConversation withLastMessage(Date lastMessage) {
        this.lastMessage = lastMessage;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastSender")
    public Optional<LastSenderRef> getLastSender() {
        return Optional.ofNullable(lastSender);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastSender")
    public void setLastSender(LastSenderRef lastSender) {
        this.lastSender = lastSender;
    }

    public MessageConversation withLastSender(LastSenderRef lastSender) {
        this.lastSender = lastSender;
        return this;
    }

    @JsonProperty("lastSenderFirstname")
    public Optional<String> getLastSenderFirstname() {
        return Optional.ofNullable(lastSenderFirstname);
    }

    @JsonProperty("lastSenderFirstname")
    public void setLastSenderFirstname(String lastSenderFirstname) {
        this.lastSenderFirstname = lastSenderFirstname;
    }

    public MessageConversation withLastSenderFirstname(String lastSenderFirstname) {
        this.lastSenderFirstname = lastSenderFirstname;
        return this;
    }

    @JsonProperty("lastSenderSurname")
    public Optional<String> getLastSenderSurname() {
        return Optional.ofNullable(lastSenderSurname);
    }

    @JsonProperty("lastSenderSurname")
    public void setLastSenderSurname(String lastSenderSurname) {
        this.lastSenderSurname = lastSenderSurname;
    }

    public MessageConversation withLastSenderSurname(String lastSenderSurname) {
        this.lastSenderSurname = lastSenderSurname;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public MessageConversation withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public Optional<LastUpdatedByRef__48> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(LastUpdatedByRef__48 lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public MessageConversation withLastUpdatedBy(LastUpdatedByRef__48 lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("messageCount")
    public Integer getMessageCount() {
        return messageCount;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("messageCount")
    public void setMessageCount(Integer messageCount) {
        this.messageCount = messageCount;
    }

    public MessageConversation withMessageCount(Integer messageCount) {
        this.messageCount = messageCount;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("messageType")
    public MessageConversation.MessageTypeRef getMessageType() {
        return messageType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("messageType")
    public void setMessageType(MessageConversation.MessageTypeRef messageType) {
        this.messageType = messageType;
    }

    public MessageConversation withMessageType(MessageConversation.MessageTypeRef messageType) {
        this.messageType = messageType;
        return this;
    }

    @JsonProperty("messages")
    public Optional<List<MessagesRefRef>> getMessages() {
        return Optional.ofNullable(messages);
    }

    @JsonProperty("messages")
    public void setMessages(List<MessagesRefRef> messages) {
        this.messages = messages;
    }

    public MessageConversation withMessages(List<MessagesRefRef> messages) {
        this.messages = messages;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("priority")
    public MessageConversation.PriorityRef getPriority() {
        return priority;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("priority")
    public void setPriority(MessageConversation.PriorityRef priority) {
        this.priority = priority;
    }

    public MessageConversation withPriority(MessageConversation.PriorityRef priority) {
        this.priority = priority;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public MessageConversation withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("read")
    public Optional<Boolean> getRead() {
        return Optional.ofNullable(read);
    }

    @JsonProperty("read")
    public void setRead(Boolean read) {
        this.read = read;
    }

    public MessageConversation withRead(Boolean read) {
        this.read = read;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public MessageConversation withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    public MessageConversation.StatusRef getStatus() {
        return status;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    public void setStatus(MessageConversation.StatusRef status) {
        this.status = status;
    }

    public MessageConversation withStatus(MessageConversation.StatusRef status) {
        this.status = status;
        return this;
    }

    @JsonProperty("subject")
    public Optional<String> getSubject() {
        return Optional.ofNullable(subject);
    }

    @JsonProperty("subject")
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public MessageConversation withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public MessageConversation withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public Optional<UserRef__49> getUser() {
        return Optional.ofNullable(user);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public void setUser(UserRef__49 user) {
        this.user = user;
    }

    public MessageConversation withUser(UserRef__49 user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<LegacyUserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<LegacyUserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public MessageConversation withUserAccesses(List<LegacyUserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userFirstname")
    public Optional<String> getUserFirstname() {
        return Optional.ofNullable(userFirstname);
    }

    @JsonProperty("userFirstname")
    public void setUserFirstname(String userFirstname) {
        this.userFirstname = userFirstname;
    }

    public MessageConversation withUserFirstname(String userFirstname) {
        this.userFirstname = userFirstname;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<LegacyUserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<LegacyUserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public MessageConversation withUserGroupAccesses(List<LegacyUserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonProperty("userMessages")
    public Optional<List<UserMessage>> getUserMessages() {
        return Optional.ofNullable(userMessages);
    }

    @JsonProperty("userMessages")
    public void setUserMessages(List<UserMessage> userMessages) {
        this.userMessages = userMessages;
    }

    public MessageConversation withUserMessages(List<UserMessage> userMessages) {
        this.userMessages = userMessages;
        return this;
    }

    @JsonProperty("userSurname")
    public Optional<String> getUserSurname() {
        return Optional.ofNullable(userSurname);
    }

    @JsonProperty("userSurname")
    public void setUserSurname(String userSurname) {
        this.userSurname = userSurname;
    }

    public MessageConversation withUserSurname(String userSurname) {
        this.userSurname = userSurname;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public MessageConversation withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("access".equals(name)) {
            if (value instanceof Access) {
                setAccess(((Access) value));
            } else {
                throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v40_2_2.Access\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("assignee".equals(name)) {
                if (value instanceof AssigneeRef) {
                    setAssignee(((AssigneeRef) value));
                } else {
                    throw new IllegalArgumentException(("property \"assignee\" is of type \"org.hisp.dhis.api.model.v40_2_2.AssigneeRef\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("attributeValues".equals(name)) {
                    if (value instanceof List) {
                        setAttributeValues(((List<AttributeValue> ) value));
                    } else {
                        throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.AttributeValue>\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("code".equals(name)) {
                        if (value instanceof String) {
                            setCode(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("created".equals(name)) {
                            if (value instanceof Date) {
                                setCreated(((Date) value));
                            } else {
                                throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("createdBy".equals(name)) {
                                if (value instanceof CreatedByRef__48) {
                                    setCreatedBy(((CreatedByRef__48) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v40_2_2.CreatedByRef__48\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("displayName".equals(name)) {
                                    if (value instanceof String) {
                                        setDisplayName(((String) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("extMessageId".equals(name)) {
                                        if (value instanceof String) {
                                            setExtMessageId(((String) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"extMessageId\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("externalAccess".equals(name)) {
                                            if (value instanceof Boolean) {
                                                setExternalAccess(((Boolean) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("favorite".equals(name)) {
                                                if (value instanceof Boolean) {
                                                    setFavorite(((Boolean) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("favorites".equals(name)) {
                                                    if (value instanceof List) {
                                                        setFavorites(((List<String> ) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("followUp".equals(name)) {
                                                        if (value instanceof Boolean) {
                                                            setFollowUp(((Boolean) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"followUp\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("href".equals(name)) {
                                                            if (value instanceof String) {
                                                                setHref(((String) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("id".equals(name)) {
                                                                if (value instanceof String) {
                                                                    setId(((String) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("lastMessage".equals(name)) {
                                                                    if (value instanceof Date) {
                                                                        setLastMessage(((Date) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"lastMessage\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("lastSender".equals(name)) {
                                                                        if (value instanceof LastSenderRef) {
                                                                            setLastSender(((LastSenderRef) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"lastSender\" is of type \"org.hisp.dhis.api.model.v40_2_2.LastSenderRef\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("lastSenderFirstname".equals(name)) {
                                                                            if (value instanceof String) {
                                                                                setLastSenderFirstname(((String) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"lastSenderFirstname\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("lastSenderSurname".equals(name)) {
                                                                                if (value instanceof String) {
                                                                                    setLastSenderSurname(((String) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"lastSenderSurname\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("lastUpdated".equals(name)) {
                                                                                    if (value instanceof Date) {
                                                                                        setLastUpdated(((Date) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("lastUpdatedBy".equals(name)) {
                                                                                        if (value instanceof LastUpdatedByRef__48) {
                                                                                            setLastUpdatedBy(((LastUpdatedByRef__48) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v40_2_2.LastUpdatedByRef__48\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("messageCount".equals(name)) {
                                                                                            if (value instanceof Integer) {
                                                                                                setMessageCount(((Integer) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"messageCount\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("messageType".equals(name)) {
                                                                                                if (value instanceof MessageConversation.MessageTypeRef) {
                                                                                                    setMessageType(((MessageConversation.MessageTypeRef) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"messageType\" is of type \"org.hisp.dhis.api.model.v40_2_2.MessageConversation.MessageTypeRef\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("messages".equals(name)) {
                                                                                                    if (value instanceof List) {
                                                                                                        setMessages(((List<MessagesRefRef> ) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"messages\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.MessagesRefRef>\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("priority".equals(name)) {
                                                                                                        if (value instanceof MessageConversation.PriorityRef) {
                                                                                                            setPriority(((MessageConversation.PriorityRef) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"priority\" is of type \"org.hisp.dhis.api.model.v40_2_2.MessageConversation.PriorityRef\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("publicAccess".equals(name)) {
                                                                                                            if (value instanceof String) {
                                                                                                                setPublicAccess(((String) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("read".equals(name)) {
                                                                                                                if (value instanceof Boolean) {
                                                                                                                    setRead(((Boolean) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"read\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                if ("sharing".equals(name)) {
                                                                                                                    if (value instanceof Sharing) {
                                                                                                                        setSharing(((Sharing) value));
                                                                                                                    } else {
                                                                                                                        throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v40_2_2.Sharing\", but got "+ value.getClass().toString()));
                                                                                                                    }
                                                                                                                    return true;
                                                                                                                } else {
                                                                                                                    if ("status".equals(name)) {
                                                                                                                        if (value instanceof MessageConversation.StatusRef) {
                                                                                                                            setStatus(((MessageConversation.StatusRef) value));
                                                                                                                        } else {
                                                                                                                            throw new IllegalArgumentException(("property \"status\" is of type \"org.hisp.dhis.api.model.v40_2_2.MessageConversation.StatusRef\", but got "+ value.getClass().toString()));
                                                                                                                        }
                                                                                                                        return true;
                                                                                                                    } else {
                                                                                                                        if ("subject".equals(name)) {
                                                                                                                            if (value instanceof String) {
                                                                                                                                setSubject(((String) value));
                                                                                                                            } else {
                                                                                                                                throw new IllegalArgumentException(("property \"subject\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                            }
                                                                                                                            return true;
                                                                                                                        } else {
                                                                                                                            if ("translations".equals(name)) {
                                                                                                                                if (value instanceof List) {
                                                                                                                                    setTranslations(((List<Translation> ) value));
                                                                                                                                } else {
                                                                                                                                    throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.Translation>\", but got "+ value.getClass().toString()));
                                                                                                                                }
                                                                                                                                return true;
                                                                                                                            } else {
                                                                                                                                if ("user".equals(name)) {
                                                                                                                                    if (value instanceof UserRef__49) {
                                                                                                                                        setUser(((UserRef__49) value));
                                                                                                                                    } else {
                                                                                                                                        throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v40_2_2.UserRef__49\", but got "+ value.getClass().toString()));
                                                                                                                                    }
                                                                                                                                    return true;
                                                                                                                                } else {
                                                                                                                                    if ("userAccesses".equals(name)) {
                                                                                                                                        if (value instanceof List) {
                                                                                                                                            setUserAccesses(((List<LegacyUserAccess> ) value));
                                                                                                                                        } else {
                                                                                                                                            throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.LegacyUserAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                        }
                                                                                                                                        return true;
                                                                                                                                    } else {
                                                                                                                                        if ("userFirstname".equals(name)) {
                                                                                                                                            if (value instanceof String) {
                                                                                                                                                setUserFirstname(((String) value));
                                                                                                                                            } else {
                                                                                                                                                throw new IllegalArgumentException(("property \"userFirstname\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                            }
                                                                                                                                            return true;
                                                                                                                                        } else {
                                                                                                                                            if ("userGroupAccesses".equals(name)) {
                                                                                                                                                if (value instanceof List) {
                                                                                                                                                    setUserGroupAccesses(((List<LegacyUserGroupAccess> ) value));
                                                                                                                                                } else {
                                                                                                                                                    throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.LegacyUserGroupAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                                }
                                                                                                                                                return true;
                                                                                                                                            } else {
                                                                                                                                                if ("userMessages".equals(name)) {
                                                                                                                                                    if (value instanceof List) {
                                                                                                                                                        setUserMessages(((List<UserMessage> ) value));
                                                                                                                                                    } else {
                                                                                                                                                        throw new IllegalArgumentException(("property \"userMessages\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.UserMessage>\", but got "+ value.getClass().toString()));
                                                                                                                                                    }
                                                                                                                                                    return true;
                                                                                                                                                } else {
                                                                                                                                                    if ("userSurname".equals(name)) {
                                                                                                                                                        if (value instanceof String) {
                                                                                                                                                            setUserSurname(((String) value));
                                                                                                                                                        } else {
                                                                                                                                                            throw new IllegalArgumentException(("property \"userSurname\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                        }
                                                                                                                                                        return true;
                                                                                                                                                    } else {
                                                                                                                                                        return false;
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("access".equals(name)) {
            return getAccess();
        } else {
            if ("assignee".equals(name)) {
                return getAssignee();
            } else {
                if ("attributeValues".equals(name)) {
                    return getAttributeValues();
                } else {
                    if ("code".equals(name)) {
                        return getCode();
                    } else {
                        if ("created".equals(name)) {
                            return getCreated();
                        } else {
                            if ("createdBy".equals(name)) {
                                return getCreatedBy();
                            } else {
                                if ("displayName".equals(name)) {
                                    return getDisplayName();
                                } else {
                                    if ("extMessageId".equals(name)) {
                                        return getExtMessageId();
                                    } else {
                                        if ("externalAccess".equals(name)) {
                                            return getExternalAccess();
                                        } else {
                                            if ("favorite".equals(name)) {
                                                return getFavorite();
                                            } else {
                                                if ("favorites".equals(name)) {
                                                    return getFavorites();
                                                } else {
                                                    if ("followUp".equals(name)) {
                                                        return getFollowUp();
                                                    } else {
                                                        if ("href".equals(name)) {
                                                            return getHref();
                                                        } else {
                                                            if ("id".equals(name)) {
                                                                return getId();
                                                            } else {
                                                                if ("lastMessage".equals(name)) {
                                                                    return getLastMessage();
                                                                } else {
                                                                    if ("lastSender".equals(name)) {
                                                                        return getLastSender();
                                                                    } else {
                                                                        if ("lastSenderFirstname".equals(name)) {
                                                                            return getLastSenderFirstname();
                                                                        } else {
                                                                            if ("lastSenderSurname".equals(name)) {
                                                                                return getLastSenderSurname();
                                                                            } else {
                                                                                if ("lastUpdated".equals(name)) {
                                                                                    return getLastUpdated();
                                                                                } else {
                                                                                    if ("lastUpdatedBy".equals(name)) {
                                                                                        return getLastUpdatedBy();
                                                                                    } else {
                                                                                        if ("messageCount".equals(name)) {
                                                                                            return getMessageCount();
                                                                                        } else {
                                                                                            if ("messageType".equals(name)) {
                                                                                                return getMessageType();
                                                                                            } else {
                                                                                                if ("messages".equals(name)) {
                                                                                                    return getMessages();
                                                                                                } else {
                                                                                                    if ("priority".equals(name)) {
                                                                                                        return getPriority();
                                                                                                    } else {
                                                                                                        if ("publicAccess".equals(name)) {
                                                                                                            return getPublicAccess();
                                                                                                        } else {
                                                                                                            if ("read".equals(name)) {
                                                                                                                return getRead();
                                                                                                            } else {
                                                                                                                if ("sharing".equals(name)) {
                                                                                                                    return getSharing();
                                                                                                                } else {
                                                                                                                    if ("status".equals(name)) {
                                                                                                                        return getStatus();
                                                                                                                    } else {
                                                                                                                        if ("subject".equals(name)) {
                                                                                                                            return getSubject();
                                                                                                                        } else {
                                                                                                                            if ("translations".equals(name)) {
                                                                                                                                return getTranslations();
                                                                                                                            } else {
                                                                                                                                if ("user".equals(name)) {
                                                                                                                                    return getUser();
                                                                                                                                } else {
                                                                                                                                    if ("userAccesses".equals(name)) {
                                                                                                                                        return getUserAccesses();
                                                                                                                                    } else {
                                                                                                                                        if ("userFirstname".equals(name)) {
                                                                                                                                            return getUserFirstname();
                                                                                                                                        } else {
                                                                                                                                            if ("userGroupAccesses".equals(name)) {
                                                                                                                                                return getUserGroupAccesses();
                                                                                                                                            } else {
                                                                                                                                                if ("userMessages".equals(name)) {
                                                                                                                                                    return getUserMessages();
                                                                                                                                                } else {
                                                                                                                                                    if ("userSurname".equals(name)) {
                                                                                                                                                        return getUserSurname();
                                                                                                                                                    } else {
                                                                                                                                                        return notFoundValue;
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, MessageConversation.NOT_FOUND_VALUE);
        if (MessageConversation.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public MessageConversation with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MessageConversation.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("assignee");
        sb.append('=');
        sb.append(((this.assignee == null)?"<null>":this.assignee));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("extMessageId");
        sb.append('=');
        sb.append(((this.extMessageId == null)?"<null>":this.extMessageId));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("followUp");
        sb.append('=');
        sb.append(((this.followUp == null)?"<null>":this.followUp));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("lastMessage");
        sb.append('=');
        sb.append(((this.lastMessage == null)?"<null>":this.lastMessage));
        sb.append(',');
        sb.append("lastSender");
        sb.append('=');
        sb.append(((this.lastSender == null)?"<null>":this.lastSender));
        sb.append(',');
        sb.append("lastSenderFirstname");
        sb.append('=');
        sb.append(((this.lastSenderFirstname == null)?"<null>":this.lastSenderFirstname));
        sb.append(',');
        sb.append("lastSenderSurname");
        sb.append('=');
        sb.append(((this.lastSenderSurname == null)?"<null>":this.lastSenderSurname));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("messageCount");
        sb.append('=');
        sb.append(((this.messageCount == null)?"<null>":this.messageCount));
        sb.append(',');
        sb.append("messageType");
        sb.append('=');
        sb.append(((this.messageType == null)?"<null>":this.messageType));
        sb.append(',');
        sb.append("messages");
        sb.append('=');
        sb.append(((this.messages == null)?"<null>":this.messages));
        sb.append(',');
        sb.append("priority");
        sb.append('=');
        sb.append(((this.priority == null)?"<null>":this.priority));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("read");
        sb.append('=');
        sb.append(((this.read == null)?"<null>":this.read));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(((this.status == null)?"<null>":this.status));
        sb.append(',');
        sb.append("subject");
        sb.append('=');
        sb.append(((this.subject == null)?"<null>":this.subject));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userFirstname");
        sb.append('=');
        sb.append(((this.userFirstname == null)?"<null>":this.userFirstname));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("userMessages");
        sb.append('=');
        sb.append(((this.userMessages == null)?"<null>":this.userMessages));
        sb.append(',');
        sb.append("userSurname");
        sb.append('=');
        sb.append(((this.userSurname == null)?"<null>":this.userSurname));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.messageCount == null)? 0 :this.messageCount.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.subject == null)? 0 :this.subject.hashCode()));
        result = ((result* 31)+((this.extMessageId == null)? 0 :this.extMessageId.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.followUp == null)? 0 :this.followUp.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.messageType == null)? 0 :this.messageType.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.userMessages == null)? 0 :this.userMessages.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.userSurname == null)? 0 :this.userSurname.hashCode()));
        result = ((result* 31)+((this.lastSenderSurname == null)? 0 :this.lastSenderSurname.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.lastSender == null)? 0 :this.lastSender.hashCode()));
        result = ((result* 31)+((this.read == null)? 0 :this.read.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.lastMessage == null)? 0 :this.lastMessage.hashCode()));
        result = ((result* 31)+((this.priority == null)? 0 :this.priority.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.lastSenderFirstname == null)? 0 :this.lastSenderFirstname.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.messages == null)? 0 :this.messages.hashCode()));
        result = ((result* 31)+((this.userFirstname == null)? 0 :this.userFirstname.hashCode()));
        result = ((result* 31)+((this.assignee == null)? 0 :this.assignee.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        result = ((result* 31)+((this.status == null)? 0 :this.status.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof MessageConversation) == false) {
            return false;
        }
        MessageConversation rhs = ((MessageConversation) other);
        return ((((((((((((((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.messageCount == rhs.messageCount)||((this.messageCount!= null)&&this.messageCount.equals(rhs.messageCount))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.subject == rhs.subject)||((this.subject!= null)&&this.subject.equals(rhs.subject))))&&((this.extMessageId == rhs.extMessageId)||((this.extMessageId!= null)&&this.extMessageId.equals(rhs.extMessageId))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.followUp == rhs.followUp)||((this.followUp!= null)&&this.followUp.equals(rhs.followUp))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.messageType == rhs.messageType)||((this.messageType!= null)&&this.messageType.equals(rhs.messageType))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.userMessages == rhs.userMessages)||((this.userMessages!= null)&&this.userMessages.equals(rhs.userMessages))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.userSurname == rhs.userSurname)||((this.userSurname!= null)&&this.userSurname.equals(rhs.userSurname))))&&((this.lastSenderSurname == rhs.lastSenderSurname)||((this.lastSenderSurname!= null)&&this.lastSenderSurname.equals(rhs.lastSenderSurname))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.lastSender == rhs.lastSender)||((this.lastSender!= null)&&this.lastSender.equals(rhs.lastSender))))&&((this.read == rhs.read)||((this.read!= null)&&this.read.equals(rhs.read))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.lastMessage == rhs.lastMessage)||((this.lastMessage!= null)&&this.lastMessage.equals(rhs.lastMessage))))&&((this.priority == rhs.priority)||((this.priority!= null)&&this.priority.equals(rhs.priority))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.lastSenderFirstname == rhs.lastSenderFirstname)||((this.lastSenderFirstname!= null)&&this.lastSenderFirstname.equals(rhs.lastSenderFirstname))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.messages == rhs.messages)||((this.messages!= null)&&this.messages.equals(rhs.messages))))&&((this.userFirstname == rhs.userFirstname)||((this.userFirstname!= null)&&this.userFirstname.equals(rhs.userFirstname))))&&((this.assignee == rhs.assignee)||((this.assignee!= null)&&this.assignee.equals(rhs.assignee))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))))&&((this.status == rhs.status)||((this.status!= null)&&this.status.equals(rhs.status))));
    }

    @Generated("jsonschema2pojo")
    public enum MessageTypeRef {

        PRIVATE("PRIVATE"),
        SYSTEM("SYSTEM"),
        VALIDATION_RESULT("VALIDATION_RESULT"),
        TICKET("TICKET"),
        SYSTEM_VERSION_UPDATE("SYSTEM_VERSION_UPDATE");
        private final String value;
        private final static Map<String, MessageConversation.MessageTypeRef> CONSTANTS = new HashMap<String, MessageConversation.MessageTypeRef>();

        static {
            for (MessageConversation.MessageTypeRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        MessageTypeRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MessageConversation.MessageTypeRef fromValue(String value) {
            MessageConversation.MessageTypeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum PriorityRef {

        NONE("NONE"),
        LOW("LOW"),
        MEDIUM("MEDIUM"),
        HIGH("HIGH");
        private final String value;
        private final static Map<String, MessageConversation.PriorityRef> CONSTANTS = new HashMap<String, MessageConversation.PriorityRef>();

        static {
            for (MessageConversation.PriorityRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        PriorityRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MessageConversation.PriorityRef fromValue(String value) {
            MessageConversation.PriorityRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum StatusRef {

        NONE("NONE"),
        OPEN("OPEN"),
        PENDING("PENDING"),
        INVALID("INVALID"),
        SOLVED("SOLVED");
        private final String value;
        private final static Map<String, MessageConversation.StatusRef> CONSTANTS = new HashMap<String, MessageConversation.StatusRef>();

        static {
            for (MessageConversation.StatusRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        StatusRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MessageConversation.StatusRef fromValue(String value) {
            MessageConversation.StatusRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
