
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "classes",
    "defaultFields",
    "defaultFilter",
    "defaultOrder",
    "defaults",
    "download",
    "exportWithDependencies",
    "inclusionStrategy",
    "objectExportWithDependencies",
    "skipSharing",
    "user",
    "username"
})
@Generated("jsonschema2pojo")
public class MetadataExportParams implements Serializable
{

    @JsonProperty("classes")
    private List<String> classes;
    @JsonProperty("defaultFields")
    private List<String> defaultFields;
    @JsonProperty("defaultFilter")
    private List<String> defaultFilter;
    @JsonProperty("defaultOrder")
    private List<String> defaultOrder;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("defaults")
    private MetadataExportParams.DefaultsRef defaults;
    @JsonProperty("download")
    private Boolean download;
    @JsonProperty("exportWithDependencies")
    private Boolean exportWithDependencies;
    @JsonProperty("inclusionStrategy")
    private MetadataExportParams.InclusionStrategyRef inclusionStrategy;
    /**
     * A UID reference to a any type of object  
     * (Java name `org.hisp.dhis.common.IdentifiableObject`)
     * 
     */
    @JsonProperty("objectExportWithDependencies")
    @JsonPropertyDescription("A UID reference to a any type of object  \n(Java name `org.hisp.dhis.common.IdentifiableObject`)")
    private ObjectExportWithDependenciesRef objectExportWithDependencies;
    @JsonProperty("skipSharing")
    private Boolean skipSharing;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private UserRef__51 user;
    @JsonProperty("username")
    private String username;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -6222301317054982884L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public MetadataExportParams() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public MetadataExportParams(MetadataExportParams source) {
        super();
        this.classes = source.classes;
        this.defaultFields = source.defaultFields;
        this.defaultFilter = source.defaultFilter;
        this.defaultOrder = source.defaultOrder;
        this.defaults = source.defaults;
        this.download = source.download;
        this.exportWithDependencies = source.exportWithDependencies;
        this.inclusionStrategy = source.inclusionStrategy;
        this.objectExportWithDependencies = source.objectExportWithDependencies;
        this.skipSharing = source.skipSharing;
        this.user = source.user;
        this.username = source.username;
    }

    /**
     * 
     * @param objectExportWithDependencies
     *     A UID reference to a any type of object  
     *     (Java name `org.hisp.dhis.common.IdentifiableObject`).
     * @param user
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     */
    public MetadataExportParams(List<String> classes, List<String> defaultFields, List<String> defaultFilter, List<String> defaultOrder, MetadataExportParams.DefaultsRef defaults, Boolean download, Boolean exportWithDependencies, MetadataExportParams.InclusionStrategyRef inclusionStrategy, ObjectExportWithDependenciesRef objectExportWithDependencies, Boolean skipSharing, UserRef__51 user, String username) {
        super();
        this.classes = classes;
        this.defaultFields = defaultFields;
        this.defaultFilter = defaultFilter;
        this.defaultOrder = defaultOrder;
        this.defaults = defaults;
        this.download = download;
        this.exportWithDependencies = exportWithDependencies;
        this.inclusionStrategy = inclusionStrategy;
        this.objectExportWithDependencies = objectExportWithDependencies;
        this.skipSharing = skipSharing;
        this.user = user;
        this.username = username;
    }

    @JsonProperty("classes")
    public Optional<List<String>> getClasses() {
        return Optional.ofNullable(classes);
    }

    @JsonProperty("classes")
    public void setClasses(List<String> classes) {
        this.classes = classes;
    }

    public MetadataExportParams withClasses(List<String> classes) {
        this.classes = classes;
        return this;
    }

    @JsonProperty("defaultFields")
    public Optional<List<String>> getDefaultFields() {
        return Optional.ofNullable(defaultFields);
    }

    @JsonProperty("defaultFields")
    public void setDefaultFields(List<String> defaultFields) {
        this.defaultFields = defaultFields;
    }

    public MetadataExportParams withDefaultFields(List<String> defaultFields) {
        this.defaultFields = defaultFields;
        return this;
    }

    @JsonProperty("defaultFilter")
    public Optional<List<String>> getDefaultFilter() {
        return Optional.ofNullable(defaultFilter);
    }

    @JsonProperty("defaultFilter")
    public void setDefaultFilter(List<String> defaultFilter) {
        this.defaultFilter = defaultFilter;
    }

    public MetadataExportParams withDefaultFilter(List<String> defaultFilter) {
        this.defaultFilter = defaultFilter;
        return this;
    }

    @JsonProperty("defaultOrder")
    public Optional<List<String>> getDefaultOrder() {
        return Optional.ofNullable(defaultOrder);
    }

    @JsonProperty("defaultOrder")
    public void setDefaultOrder(List<String> defaultOrder) {
        this.defaultOrder = defaultOrder;
    }

    public MetadataExportParams withDefaultOrder(List<String> defaultOrder) {
        this.defaultOrder = defaultOrder;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("defaults")
    public MetadataExportParams.DefaultsRef getDefaults() {
        return defaults;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("defaults")
    public void setDefaults(MetadataExportParams.DefaultsRef defaults) {
        this.defaults = defaults;
    }

    public MetadataExportParams withDefaults(MetadataExportParams.DefaultsRef defaults) {
        this.defaults = defaults;
        return this;
    }

    @JsonProperty("download")
    public Optional<Boolean> getDownload() {
        return Optional.ofNullable(download);
    }

    @JsonProperty("download")
    public void setDownload(Boolean download) {
        this.download = download;
    }

    public MetadataExportParams withDownload(Boolean download) {
        this.download = download;
        return this;
    }

    @JsonProperty("exportWithDependencies")
    public Optional<Boolean> getExportWithDependencies() {
        return Optional.ofNullable(exportWithDependencies);
    }

    @JsonProperty("exportWithDependencies")
    public void setExportWithDependencies(Boolean exportWithDependencies) {
        this.exportWithDependencies = exportWithDependencies;
    }

    public MetadataExportParams withExportWithDependencies(Boolean exportWithDependencies) {
        this.exportWithDependencies = exportWithDependencies;
        return this;
    }

    @JsonProperty("inclusionStrategy")
    public Optional<MetadataExportParams.InclusionStrategyRef> getInclusionStrategy() {
        return Optional.ofNullable(inclusionStrategy);
    }

    @JsonProperty("inclusionStrategy")
    public void setInclusionStrategy(MetadataExportParams.InclusionStrategyRef inclusionStrategy) {
        this.inclusionStrategy = inclusionStrategy;
    }

    public MetadataExportParams withInclusionStrategy(MetadataExportParams.InclusionStrategyRef inclusionStrategy) {
        this.inclusionStrategy = inclusionStrategy;
        return this;
    }

    /**
     * A UID reference to a any type of object  
     * (Java name `org.hisp.dhis.common.IdentifiableObject`)
     * 
     */
    @JsonProperty("objectExportWithDependencies")
    public Optional<ObjectExportWithDependenciesRef> getObjectExportWithDependencies() {
        return Optional.ofNullable(objectExportWithDependencies);
    }

    /**
     * A UID reference to a any type of object  
     * (Java name `org.hisp.dhis.common.IdentifiableObject`)
     * 
     */
    @JsonProperty("objectExportWithDependencies")
    public void setObjectExportWithDependencies(ObjectExportWithDependenciesRef objectExportWithDependencies) {
        this.objectExportWithDependencies = objectExportWithDependencies;
    }

    public MetadataExportParams withObjectExportWithDependencies(ObjectExportWithDependenciesRef objectExportWithDependencies) {
        this.objectExportWithDependencies = objectExportWithDependencies;
        return this;
    }

    @JsonProperty("skipSharing")
    public Optional<Boolean> getSkipSharing() {
        return Optional.ofNullable(skipSharing);
    }

    @JsonProperty("skipSharing")
    public void setSkipSharing(Boolean skipSharing) {
        this.skipSharing = skipSharing;
    }

    public MetadataExportParams withSkipSharing(Boolean skipSharing) {
        this.skipSharing = skipSharing;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public Optional<UserRef__51> getUser() {
        return Optional.ofNullable(user);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public void setUser(UserRef__51 user) {
        this.user = user;
    }

    public MetadataExportParams withUser(UserRef__51 user) {
        this.user = user;
        return this;
    }

    @JsonProperty("username")
    public Optional<String> getUsername() {
        return Optional.ofNullable(username);
    }

    @JsonProperty("username")
    public void setUsername(String username) {
        this.username = username;
    }

    public MetadataExportParams withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public MetadataExportParams withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("classes".equals(name)) {
            if (value instanceof List) {
                setClasses(((List<String> ) value));
            } else {
                throw new IllegalArgumentException(("property \"classes\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("defaultFields".equals(name)) {
                if (value instanceof List) {
                    setDefaultFields(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"defaultFields\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("defaultFilter".equals(name)) {
                    if (value instanceof List) {
                        setDefaultFilter(((List<String> ) value));
                    } else {
                        throw new IllegalArgumentException(("property \"defaultFilter\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("defaultOrder".equals(name)) {
                        if (value instanceof List) {
                            setDefaultOrder(((List<String> ) value));
                        } else {
                            throw new IllegalArgumentException(("property \"defaultOrder\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("defaults".equals(name)) {
                            if (value instanceof MetadataExportParams.DefaultsRef) {
                                setDefaults(((MetadataExportParams.DefaultsRef) value));
                            } else {
                                throw new IllegalArgumentException(("property \"defaults\" is of type \"org.hisp.dhis.api.model.v40_2_2.MetadataExportParams.DefaultsRef\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("download".equals(name)) {
                                if (value instanceof Boolean) {
                                    setDownload(((Boolean) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"download\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("exportWithDependencies".equals(name)) {
                                    if (value instanceof Boolean) {
                                        setExportWithDependencies(((Boolean) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"exportWithDependencies\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("inclusionStrategy".equals(name)) {
                                        if (value instanceof MetadataExportParams.InclusionStrategyRef) {
                                            setInclusionStrategy(((MetadataExportParams.InclusionStrategyRef) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"inclusionStrategy\" is of type \"org.hisp.dhis.api.model.v40_2_2.MetadataExportParams.InclusionStrategyRef\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("objectExportWithDependencies".equals(name)) {
                                            if (value instanceof ObjectExportWithDependenciesRef) {
                                                setObjectExportWithDependencies(((ObjectExportWithDependenciesRef) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"objectExportWithDependencies\" is of type \"org.hisp.dhis.api.model.v40_2_2.ObjectExportWithDependenciesRef\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("skipSharing".equals(name)) {
                                                if (value instanceof Boolean) {
                                                    setSkipSharing(((Boolean) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"skipSharing\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("user".equals(name)) {
                                                    if (value instanceof UserRef__51) {
                                                        setUser(((UserRef__51) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v40_2_2.UserRef__51\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("username".equals(name)) {
                                                        if (value instanceof String) {
                                                            setUsername(((String) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"username\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        return false;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("classes".equals(name)) {
            return getClasses();
        } else {
            if ("defaultFields".equals(name)) {
                return getDefaultFields();
            } else {
                if ("defaultFilter".equals(name)) {
                    return getDefaultFilter();
                } else {
                    if ("defaultOrder".equals(name)) {
                        return getDefaultOrder();
                    } else {
                        if ("defaults".equals(name)) {
                            return getDefaults();
                        } else {
                            if ("download".equals(name)) {
                                return getDownload();
                            } else {
                                if ("exportWithDependencies".equals(name)) {
                                    return getExportWithDependencies();
                                } else {
                                    if ("inclusionStrategy".equals(name)) {
                                        return getInclusionStrategy();
                                    } else {
                                        if ("objectExportWithDependencies".equals(name)) {
                                            return getObjectExportWithDependencies();
                                        } else {
                                            if ("skipSharing".equals(name)) {
                                                return getSkipSharing();
                                            } else {
                                                if ("user".equals(name)) {
                                                    return getUser();
                                                } else {
                                                    if ("username".equals(name)) {
                                                        return getUsername();
                                                    } else {
                                                        return notFoundValue;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, MetadataExportParams.NOT_FOUND_VALUE);
        if (MetadataExportParams.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public MetadataExportParams with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MetadataExportParams.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("classes");
        sb.append('=');
        sb.append(((this.classes == null)?"<null>":this.classes));
        sb.append(',');
        sb.append("defaultFields");
        sb.append('=');
        sb.append(((this.defaultFields == null)?"<null>":this.defaultFields));
        sb.append(',');
        sb.append("defaultFilter");
        sb.append('=');
        sb.append(((this.defaultFilter == null)?"<null>":this.defaultFilter));
        sb.append(',');
        sb.append("defaultOrder");
        sb.append('=');
        sb.append(((this.defaultOrder == null)?"<null>":this.defaultOrder));
        sb.append(',');
        sb.append("defaults");
        sb.append('=');
        sb.append(((this.defaults == null)?"<null>":this.defaults));
        sb.append(',');
        sb.append("download");
        sb.append('=');
        sb.append(((this.download == null)?"<null>":this.download));
        sb.append(',');
        sb.append("exportWithDependencies");
        sb.append('=');
        sb.append(((this.exportWithDependencies == null)?"<null>":this.exportWithDependencies));
        sb.append(',');
        sb.append("inclusionStrategy");
        sb.append('=');
        sb.append(((this.inclusionStrategy == null)?"<null>":this.inclusionStrategy));
        sb.append(',');
        sb.append("objectExportWithDependencies");
        sb.append('=');
        sb.append(((this.objectExportWithDependencies == null)?"<null>":this.objectExportWithDependencies));
        sb.append(',');
        sb.append("skipSharing");
        sb.append('=');
        sb.append(((this.skipSharing == null)?"<null>":this.skipSharing));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("username");
        sb.append('=');
        sb.append(((this.username == null)?"<null>":this.username));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.defaultFields == null)? 0 :this.defaultFields.hashCode()));
        result = ((result* 31)+((this.objectExportWithDependencies == null)? 0 :this.objectExportWithDependencies.hashCode()));
        result = ((result* 31)+((this.inclusionStrategy == null)? 0 :this.inclusionStrategy.hashCode()));
        result = ((result* 31)+((this.classes == null)? 0 :this.classes.hashCode()));
        result = ((result* 31)+((this.defaultFilter == null)? 0 :this.defaultFilter.hashCode()));
        result = ((result* 31)+((this.skipSharing == null)? 0 :this.skipSharing.hashCode()));
        result = ((result* 31)+((this.download == null)? 0 :this.download.hashCode()));
        result = ((result* 31)+((this.exportWithDependencies == null)? 0 :this.exportWithDependencies.hashCode()));
        result = ((result* 31)+((this.defaults == null)? 0 :this.defaults.hashCode()));
        result = ((result* 31)+((this.defaultOrder == null)? 0 :this.defaultOrder.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        result = ((result* 31)+((this.username == null)? 0 :this.username.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof MetadataExportParams) == false) {
            return false;
        }
        MetadataExportParams rhs = ((MetadataExportParams) other);
        return ((((((((((((((this.defaultFields == rhs.defaultFields)||((this.defaultFields!= null)&&this.defaultFields.equals(rhs.defaultFields)))&&((this.objectExportWithDependencies == rhs.objectExportWithDependencies)||((this.objectExportWithDependencies!= null)&&this.objectExportWithDependencies.equals(rhs.objectExportWithDependencies))))&&((this.inclusionStrategy == rhs.inclusionStrategy)||((this.inclusionStrategy!= null)&&this.inclusionStrategy.equals(rhs.inclusionStrategy))))&&((this.classes == rhs.classes)||((this.classes!= null)&&this.classes.equals(rhs.classes))))&&((this.defaultFilter == rhs.defaultFilter)||((this.defaultFilter!= null)&&this.defaultFilter.equals(rhs.defaultFilter))))&&((this.skipSharing == rhs.skipSharing)||((this.skipSharing!= null)&&this.skipSharing.equals(rhs.skipSharing))))&&((this.download == rhs.download)||((this.download!= null)&&this.download.equals(rhs.download))))&&((this.exportWithDependencies == rhs.exportWithDependencies)||((this.exportWithDependencies!= null)&&this.exportWithDependencies.equals(rhs.exportWithDependencies))))&&((this.defaults == rhs.defaults)||((this.defaults!= null)&&this.defaults.equals(rhs.defaults))))&&((this.defaultOrder == rhs.defaultOrder)||((this.defaultOrder!= null)&&this.defaultOrder.equals(rhs.defaultOrder))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))))&&((this.username == rhs.username)||((this.username!= null)&&this.username.equals(rhs.username))));
    }

    @Generated("jsonschema2pojo")
    public enum DefaultsRef {

        INCLUDE("INCLUDE"),
        EXCLUDE("EXCLUDE");
        private final String value;
        private final static Map<String, MetadataExportParams.DefaultsRef> CONSTANTS = new HashMap<String, MetadataExportParams.DefaultsRef>();

        static {
            for (MetadataExportParams.DefaultsRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        DefaultsRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MetadataExportParams.DefaultsRef fromValue(String value) {
            MetadataExportParams.DefaultsRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum InclusionStrategyRef {

        ALWAYS("ALWAYS"),
        NON_NULL("NON_NULL"),
        NON_EMPTY("NON_EMPTY");
        private final String value;
        private final static Map<String, MetadataExportParams.InclusionStrategyRef> CONSTANTS = new HashMap<String, MetadataExportParams.InclusionStrategyRef>();

        static {
            for (MetadataExportParams.InclusionStrategyRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        InclusionStrategyRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MetadataExportParams.InclusionStrategyRef fromValue(String value) {
            MetadataExportParams.InclusionStrategyRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
