
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "atomicMode",
    "flushMode",
    "identifier",
    "importMode",
    "importReportMode",
    "importStrategy",
    "mergeMode",
    "metadataSyncImport",
    "preheatMode",
    "skipSharing",
    "skipTranslation",
    "skipValidation",
    "userOverrideMode"
})
@Generated("jsonschema2pojo")
public class MetadataImportParams implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("atomicMode")
    private MetadataImportParams.AtomicModeRef atomicMode;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("flushMode")
    private MetadataImportParams.FlushModeRef flushMode;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("identifier")
    private MetadataImportParams.IdentifierRef identifier;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("importMode")
    private MetadataImportParams.ImportModeRef importMode;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("importReportMode")
    private MetadataImportParams.ImportReportModeRef importReportMode;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("importStrategy")
    private MetadataImportParams.ImportStrategyRef importStrategy;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mergeMode")
    private MetadataImportParams.MergeModeRef mergeMode;
    @JsonProperty("metadataSyncImport")
    private Boolean metadataSyncImport;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("preheatMode")
    private MetadataImportParams.PreheatModeRef preheatMode;
    @JsonProperty("skipSharing")
    private Boolean skipSharing;
    @JsonProperty("skipTranslation")
    private Boolean skipTranslation;
    @JsonProperty("skipValidation")
    private Boolean skipValidation;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("userOverrideMode")
    private MetadataImportParams.UserOverrideModeRef userOverrideMode;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -8021983309386903569L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public MetadataImportParams() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public MetadataImportParams(MetadataImportParams source) {
        super();
        this.atomicMode = source.atomicMode;
        this.flushMode = source.flushMode;
        this.identifier = source.identifier;
        this.importMode = source.importMode;
        this.importReportMode = source.importReportMode;
        this.importStrategy = source.importStrategy;
        this.mergeMode = source.mergeMode;
        this.metadataSyncImport = source.metadataSyncImport;
        this.preheatMode = source.preheatMode;
        this.skipSharing = source.skipSharing;
        this.skipTranslation = source.skipTranslation;
        this.skipValidation = source.skipValidation;
        this.userOverrideMode = source.userOverrideMode;
    }

    public MetadataImportParams(MetadataImportParams.AtomicModeRef atomicMode, MetadataImportParams.FlushModeRef flushMode, MetadataImportParams.IdentifierRef identifier, MetadataImportParams.ImportModeRef importMode, MetadataImportParams.ImportReportModeRef importReportMode, MetadataImportParams.ImportStrategyRef importStrategy, MetadataImportParams.MergeModeRef mergeMode, Boolean metadataSyncImport, MetadataImportParams.PreheatModeRef preheatMode, Boolean skipSharing, Boolean skipTranslation, Boolean skipValidation, MetadataImportParams.UserOverrideModeRef userOverrideMode) {
        super();
        this.atomicMode = atomicMode;
        this.flushMode = flushMode;
        this.identifier = identifier;
        this.importMode = importMode;
        this.importReportMode = importReportMode;
        this.importStrategy = importStrategy;
        this.mergeMode = mergeMode;
        this.metadataSyncImport = metadataSyncImport;
        this.preheatMode = preheatMode;
        this.skipSharing = skipSharing;
        this.skipTranslation = skipTranslation;
        this.skipValidation = skipValidation;
        this.userOverrideMode = userOverrideMode;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("atomicMode")
    public MetadataImportParams.AtomicModeRef getAtomicMode() {
        return atomicMode;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("atomicMode")
    public void setAtomicMode(MetadataImportParams.AtomicModeRef atomicMode) {
        this.atomicMode = atomicMode;
    }

    public MetadataImportParams withAtomicMode(MetadataImportParams.AtomicModeRef atomicMode) {
        this.atomicMode = atomicMode;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("flushMode")
    public MetadataImportParams.FlushModeRef getFlushMode() {
        return flushMode;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("flushMode")
    public void setFlushMode(MetadataImportParams.FlushModeRef flushMode) {
        this.flushMode = flushMode;
    }

    public MetadataImportParams withFlushMode(MetadataImportParams.FlushModeRef flushMode) {
        this.flushMode = flushMode;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("identifier")
    public MetadataImportParams.IdentifierRef getIdentifier() {
        return identifier;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("identifier")
    public void setIdentifier(MetadataImportParams.IdentifierRef identifier) {
        this.identifier = identifier;
    }

    public MetadataImportParams withIdentifier(MetadataImportParams.IdentifierRef identifier) {
        this.identifier = identifier;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("importMode")
    public MetadataImportParams.ImportModeRef getImportMode() {
        return importMode;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("importMode")
    public void setImportMode(MetadataImportParams.ImportModeRef importMode) {
        this.importMode = importMode;
    }

    public MetadataImportParams withImportMode(MetadataImportParams.ImportModeRef importMode) {
        this.importMode = importMode;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("importReportMode")
    public MetadataImportParams.ImportReportModeRef getImportReportMode() {
        return importReportMode;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("importReportMode")
    public void setImportReportMode(MetadataImportParams.ImportReportModeRef importReportMode) {
        this.importReportMode = importReportMode;
    }

    public MetadataImportParams withImportReportMode(MetadataImportParams.ImportReportModeRef importReportMode) {
        this.importReportMode = importReportMode;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("importStrategy")
    public MetadataImportParams.ImportStrategyRef getImportStrategy() {
        return importStrategy;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("importStrategy")
    public void setImportStrategy(MetadataImportParams.ImportStrategyRef importStrategy) {
        this.importStrategy = importStrategy;
    }

    public MetadataImportParams withImportStrategy(MetadataImportParams.ImportStrategyRef importStrategy) {
        this.importStrategy = importStrategy;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mergeMode")
    public MetadataImportParams.MergeModeRef getMergeMode() {
        return mergeMode;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mergeMode")
    public void setMergeMode(MetadataImportParams.MergeModeRef mergeMode) {
        this.mergeMode = mergeMode;
    }

    public MetadataImportParams withMergeMode(MetadataImportParams.MergeModeRef mergeMode) {
        this.mergeMode = mergeMode;
        return this;
    }

    @JsonProperty("metadataSyncImport")
    public Optional<Boolean> getMetadataSyncImport() {
        return Optional.ofNullable(metadataSyncImport);
    }

    @JsonProperty("metadataSyncImport")
    public void setMetadataSyncImport(Boolean metadataSyncImport) {
        this.metadataSyncImport = metadataSyncImport;
    }

    public MetadataImportParams withMetadataSyncImport(Boolean metadataSyncImport) {
        this.metadataSyncImport = metadataSyncImport;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("preheatMode")
    public MetadataImportParams.PreheatModeRef getPreheatMode() {
        return preheatMode;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("preheatMode")
    public void setPreheatMode(MetadataImportParams.PreheatModeRef preheatMode) {
        this.preheatMode = preheatMode;
    }

    public MetadataImportParams withPreheatMode(MetadataImportParams.PreheatModeRef preheatMode) {
        this.preheatMode = preheatMode;
        return this;
    }

    @JsonProperty("skipSharing")
    public Optional<Boolean> getSkipSharing() {
        return Optional.ofNullable(skipSharing);
    }

    @JsonProperty("skipSharing")
    public void setSkipSharing(Boolean skipSharing) {
        this.skipSharing = skipSharing;
    }

    public MetadataImportParams withSkipSharing(Boolean skipSharing) {
        this.skipSharing = skipSharing;
        return this;
    }

    @JsonProperty("skipTranslation")
    public Optional<Boolean> getSkipTranslation() {
        return Optional.ofNullable(skipTranslation);
    }

    @JsonProperty("skipTranslation")
    public void setSkipTranslation(Boolean skipTranslation) {
        this.skipTranslation = skipTranslation;
    }

    public MetadataImportParams withSkipTranslation(Boolean skipTranslation) {
        this.skipTranslation = skipTranslation;
        return this;
    }

    @JsonProperty("skipValidation")
    public Optional<Boolean> getSkipValidation() {
        return Optional.ofNullable(skipValidation);
    }

    @JsonProperty("skipValidation")
    public void setSkipValidation(Boolean skipValidation) {
        this.skipValidation = skipValidation;
    }

    public MetadataImportParams withSkipValidation(Boolean skipValidation) {
        this.skipValidation = skipValidation;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("userOverrideMode")
    public MetadataImportParams.UserOverrideModeRef getUserOverrideMode() {
        return userOverrideMode;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("userOverrideMode")
    public void setUserOverrideMode(MetadataImportParams.UserOverrideModeRef userOverrideMode) {
        this.userOverrideMode = userOverrideMode;
    }

    public MetadataImportParams withUserOverrideMode(MetadataImportParams.UserOverrideModeRef userOverrideMode) {
        this.userOverrideMode = userOverrideMode;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public MetadataImportParams withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("atomicMode".equals(name)) {
            if (value instanceof MetadataImportParams.AtomicModeRef) {
                setAtomicMode(((MetadataImportParams.AtomicModeRef) value));
            } else {
                throw new IllegalArgumentException(("property \"atomicMode\" is of type \"org.hisp.dhis.api.model.v40_2_2.MetadataImportParams.AtomicModeRef\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("flushMode".equals(name)) {
                if (value instanceof MetadataImportParams.FlushModeRef) {
                    setFlushMode(((MetadataImportParams.FlushModeRef) value));
                } else {
                    throw new IllegalArgumentException(("property \"flushMode\" is of type \"org.hisp.dhis.api.model.v40_2_2.MetadataImportParams.FlushModeRef\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("identifier".equals(name)) {
                    if (value instanceof MetadataImportParams.IdentifierRef) {
                        setIdentifier(((MetadataImportParams.IdentifierRef) value));
                    } else {
                        throw new IllegalArgumentException(("property \"identifier\" is of type \"org.hisp.dhis.api.model.v40_2_2.MetadataImportParams.IdentifierRef\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("importMode".equals(name)) {
                        if (value instanceof MetadataImportParams.ImportModeRef) {
                            setImportMode(((MetadataImportParams.ImportModeRef) value));
                        } else {
                            throw new IllegalArgumentException(("property \"importMode\" is of type \"org.hisp.dhis.api.model.v40_2_2.MetadataImportParams.ImportModeRef\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("importReportMode".equals(name)) {
                            if (value instanceof MetadataImportParams.ImportReportModeRef) {
                                setImportReportMode(((MetadataImportParams.ImportReportModeRef) value));
                            } else {
                                throw new IllegalArgumentException(("property \"importReportMode\" is of type \"org.hisp.dhis.api.model.v40_2_2.MetadataImportParams.ImportReportModeRef\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("importStrategy".equals(name)) {
                                if (value instanceof MetadataImportParams.ImportStrategyRef) {
                                    setImportStrategy(((MetadataImportParams.ImportStrategyRef) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"importStrategy\" is of type \"org.hisp.dhis.api.model.v40_2_2.MetadataImportParams.ImportStrategyRef\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("mergeMode".equals(name)) {
                                    if (value instanceof MetadataImportParams.MergeModeRef) {
                                        setMergeMode(((MetadataImportParams.MergeModeRef) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"mergeMode\" is of type \"org.hisp.dhis.api.model.v40_2_2.MetadataImportParams.MergeModeRef\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("metadataSyncImport".equals(name)) {
                                        if (value instanceof Boolean) {
                                            setMetadataSyncImport(((Boolean) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"metadataSyncImport\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("preheatMode".equals(name)) {
                                            if (value instanceof MetadataImportParams.PreheatModeRef) {
                                                setPreheatMode(((MetadataImportParams.PreheatModeRef) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"preheatMode\" is of type \"org.hisp.dhis.api.model.v40_2_2.MetadataImportParams.PreheatModeRef\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("skipSharing".equals(name)) {
                                                if (value instanceof Boolean) {
                                                    setSkipSharing(((Boolean) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"skipSharing\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("skipTranslation".equals(name)) {
                                                    if (value instanceof Boolean) {
                                                        setSkipTranslation(((Boolean) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"skipTranslation\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("skipValidation".equals(name)) {
                                                        if (value instanceof Boolean) {
                                                            setSkipValidation(((Boolean) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"skipValidation\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("userOverrideMode".equals(name)) {
                                                            if (value instanceof MetadataImportParams.UserOverrideModeRef) {
                                                                setUserOverrideMode(((MetadataImportParams.UserOverrideModeRef) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"userOverrideMode\" is of type \"org.hisp.dhis.api.model.v40_2_2.MetadataImportParams.UserOverrideModeRef\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            return false;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("atomicMode".equals(name)) {
            return getAtomicMode();
        } else {
            if ("flushMode".equals(name)) {
                return getFlushMode();
            } else {
                if ("identifier".equals(name)) {
                    return getIdentifier();
                } else {
                    if ("importMode".equals(name)) {
                        return getImportMode();
                    } else {
                        if ("importReportMode".equals(name)) {
                            return getImportReportMode();
                        } else {
                            if ("importStrategy".equals(name)) {
                                return getImportStrategy();
                            } else {
                                if ("mergeMode".equals(name)) {
                                    return getMergeMode();
                                } else {
                                    if ("metadataSyncImport".equals(name)) {
                                        return getMetadataSyncImport();
                                    } else {
                                        if ("preheatMode".equals(name)) {
                                            return getPreheatMode();
                                        } else {
                                            if ("skipSharing".equals(name)) {
                                                return getSkipSharing();
                                            } else {
                                                if ("skipTranslation".equals(name)) {
                                                    return getSkipTranslation();
                                                } else {
                                                    if ("skipValidation".equals(name)) {
                                                        return getSkipValidation();
                                                    } else {
                                                        if ("userOverrideMode".equals(name)) {
                                                            return getUserOverrideMode();
                                                        } else {
                                                            return notFoundValue;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, MetadataImportParams.NOT_FOUND_VALUE);
        if (MetadataImportParams.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public MetadataImportParams with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MetadataImportParams.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("atomicMode");
        sb.append('=');
        sb.append(((this.atomicMode == null)?"<null>":this.atomicMode));
        sb.append(',');
        sb.append("flushMode");
        sb.append('=');
        sb.append(((this.flushMode == null)?"<null>":this.flushMode));
        sb.append(',');
        sb.append("identifier");
        sb.append('=');
        sb.append(((this.identifier == null)?"<null>":this.identifier));
        sb.append(',');
        sb.append("importMode");
        sb.append('=');
        sb.append(((this.importMode == null)?"<null>":this.importMode));
        sb.append(',');
        sb.append("importReportMode");
        sb.append('=');
        sb.append(((this.importReportMode == null)?"<null>":this.importReportMode));
        sb.append(',');
        sb.append("importStrategy");
        sb.append('=');
        sb.append(((this.importStrategy == null)?"<null>":this.importStrategy));
        sb.append(',');
        sb.append("mergeMode");
        sb.append('=');
        sb.append(((this.mergeMode == null)?"<null>":this.mergeMode));
        sb.append(',');
        sb.append("metadataSyncImport");
        sb.append('=');
        sb.append(((this.metadataSyncImport == null)?"<null>":this.metadataSyncImport));
        sb.append(',');
        sb.append("preheatMode");
        sb.append('=');
        sb.append(((this.preheatMode == null)?"<null>":this.preheatMode));
        sb.append(',');
        sb.append("skipSharing");
        sb.append('=');
        sb.append(((this.skipSharing == null)?"<null>":this.skipSharing));
        sb.append(',');
        sb.append("skipTranslation");
        sb.append('=');
        sb.append(((this.skipTranslation == null)?"<null>":this.skipTranslation));
        sb.append(',');
        sb.append("skipValidation");
        sb.append('=');
        sb.append(((this.skipValidation == null)?"<null>":this.skipValidation));
        sb.append(',');
        sb.append("userOverrideMode");
        sb.append('=');
        sb.append(((this.userOverrideMode == null)?"<null>":this.userOverrideMode));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.identifier == null)? 0 :this.identifier.hashCode()));
        result = ((result* 31)+((this.importMode == null)? 0 :this.importMode.hashCode()));
        result = ((result* 31)+((this.preheatMode == null)? 0 :this.preheatMode.hashCode()));
        result = ((result* 31)+((this.atomicMode == null)? 0 :this.atomicMode.hashCode()));
        result = ((result* 31)+((this.metadataSyncImport == null)? 0 :this.metadataSyncImport.hashCode()));
        result = ((result* 31)+((this.userOverrideMode == null)? 0 :this.userOverrideMode.hashCode()));
        result = ((result* 31)+((this.mergeMode == null)? 0 :this.mergeMode.hashCode()));
        result = ((result* 31)+((this.flushMode == null)? 0 :this.flushMode.hashCode()));
        result = ((result* 31)+((this.skipSharing == null)? 0 :this.skipSharing.hashCode()));
        result = ((result* 31)+((this.skipValidation == null)? 0 :this.skipValidation.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.importStrategy == null)? 0 :this.importStrategy.hashCode()));
        result = ((result* 31)+((this.importReportMode == null)? 0 :this.importReportMode.hashCode()));
        result = ((result* 31)+((this.skipTranslation == null)? 0 :this.skipTranslation.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof MetadataImportParams) == false) {
            return false;
        }
        MetadataImportParams rhs = ((MetadataImportParams) other);
        return (((((((((((((((this.identifier == rhs.identifier)||((this.identifier!= null)&&this.identifier.equals(rhs.identifier)))&&((this.importMode == rhs.importMode)||((this.importMode!= null)&&this.importMode.equals(rhs.importMode))))&&((this.preheatMode == rhs.preheatMode)||((this.preheatMode!= null)&&this.preheatMode.equals(rhs.preheatMode))))&&((this.atomicMode == rhs.atomicMode)||((this.atomicMode!= null)&&this.atomicMode.equals(rhs.atomicMode))))&&((this.metadataSyncImport == rhs.metadataSyncImport)||((this.metadataSyncImport!= null)&&this.metadataSyncImport.equals(rhs.metadataSyncImport))))&&((this.userOverrideMode == rhs.userOverrideMode)||((this.userOverrideMode!= null)&&this.userOverrideMode.equals(rhs.userOverrideMode))))&&((this.mergeMode == rhs.mergeMode)||((this.mergeMode!= null)&&this.mergeMode.equals(rhs.mergeMode))))&&((this.flushMode == rhs.flushMode)||((this.flushMode!= null)&&this.flushMode.equals(rhs.flushMode))))&&((this.skipSharing == rhs.skipSharing)||((this.skipSharing!= null)&&this.skipSharing.equals(rhs.skipSharing))))&&((this.skipValidation == rhs.skipValidation)||((this.skipValidation!= null)&&this.skipValidation.equals(rhs.skipValidation))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.importStrategy == rhs.importStrategy)||((this.importStrategy!= null)&&this.importStrategy.equals(rhs.importStrategy))))&&((this.importReportMode == rhs.importReportMode)||((this.importReportMode!= null)&&this.importReportMode.equals(rhs.importReportMode))))&&((this.skipTranslation == rhs.skipTranslation)||((this.skipTranslation!= null)&&this.skipTranslation.equals(rhs.skipTranslation))));
    }

    @Generated("jsonschema2pojo")
    public enum AtomicModeRef {

        ALL("ALL"),
        NONE("NONE");
        private final String value;
        private final static Map<String, MetadataImportParams.AtomicModeRef> CONSTANTS = new HashMap<String, MetadataImportParams.AtomicModeRef>();

        static {
            for (MetadataImportParams.AtomicModeRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        AtomicModeRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MetadataImportParams.AtomicModeRef fromValue(String value) {
            MetadataImportParams.AtomicModeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum FlushModeRef {

        OBJECT("OBJECT"),
        AUTO("AUTO");
        private final String value;
        private final static Map<String, MetadataImportParams.FlushModeRef> CONSTANTS = new HashMap<String, MetadataImportParams.FlushModeRef>();

        static {
            for (MetadataImportParams.FlushModeRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        FlushModeRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MetadataImportParams.FlushModeRef fromValue(String value) {
            MetadataImportParams.FlushModeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum IdentifierRef {

        UID("UID"),
        CODE("CODE");
        private final String value;
        private final static Map<String, MetadataImportParams.IdentifierRef> CONSTANTS = new HashMap<String, MetadataImportParams.IdentifierRef>();

        static {
            for (MetadataImportParams.IdentifierRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        IdentifierRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MetadataImportParams.IdentifierRef fromValue(String value) {
            MetadataImportParams.IdentifierRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ImportModeRef {

        COMMIT("COMMIT"),
        VALIDATE("VALIDATE");
        private final String value;
        private final static Map<String, MetadataImportParams.ImportModeRef> CONSTANTS = new HashMap<String, MetadataImportParams.ImportModeRef>();

        static {
            for (MetadataImportParams.ImportModeRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ImportModeRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MetadataImportParams.ImportModeRef fromValue(String value) {
            MetadataImportParams.ImportModeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ImportReportModeRef {

        FULL("FULL"),
        ERRORS("ERRORS"),
        ERRORS_NOT_OWNER("ERRORS_NOT_OWNER"),
        DEBUG("DEBUG");
        private final String value;
        private final static Map<String, MetadataImportParams.ImportReportModeRef> CONSTANTS = new HashMap<String, MetadataImportParams.ImportReportModeRef>();

        static {
            for (MetadataImportParams.ImportReportModeRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ImportReportModeRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MetadataImportParams.ImportReportModeRef fromValue(String value) {
            MetadataImportParams.ImportReportModeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ImportStrategyRef {

        CREATE("CREATE"),
        UPDATE("UPDATE"),
        CREATE_AND_UPDATE("CREATE_AND_UPDATE"),
        DELETE("DELETE"),
        SYNC("SYNC"),
        NEW_AND_UPDATES("NEW_AND_UPDATES"),
        NEW("NEW"),
        UPDATES("UPDATES"),
        DELETES("DELETES");
        private final String value;
        private final static Map<String, MetadataImportParams.ImportStrategyRef> CONSTANTS = new HashMap<String, MetadataImportParams.ImportStrategyRef>();

        static {
            for (MetadataImportParams.ImportStrategyRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ImportStrategyRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MetadataImportParams.ImportStrategyRef fromValue(String value) {
            MetadataImportParams.ImportStrategyRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum MergeModeRef {

        MERGE_ALWAYS("MERGE_ALWAYS"),
        MERGE_IF_NOT_NULL("MERGE_IF_NOT_NULL"),
        MERGE("MERGE"),
        REPLACE("REPLACE"),
        NONE("NONE");
        private final String value;
        private final static Map<String, MetadataImportParams.MergeModeRef> CONSTANTS = new HashMap<String, MetadataImportParams.MergeModeRef>();

        static {
            for (MetadataImportParams.MergeModeRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        MergeModeRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MetadataImportParams.MergeModeRef fromValue(String value) {
            MetadataImportParams.MergeModeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum PreheatModeRef {

        REFERENCE("REFERENCE"),
        ALL("ALL"),
        NONE("NONE");
        private final String value;
        private final static Map<String, MetadataImportParams.PreheatModeRef> CONSTANTS = new HashMap<String, MetadataImportParams.PreheatModeRef>();

        static {
            for (MetadataImportParams.PreheatModeRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        PreheatModeRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MetadataImportParams.PreheatModeRef fromValue(String value) {
            MetadataImportParams.PreheatModeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum UserOverrideModeRef {

        NONE("NONE"),
        CURRENT("CURRENT"),
        SELECTED("SELECTED");
        private final String value;
        private final static Map<String, MetadataImportParams.UserOverrideModeRef> CONSTANTS = new HashMap<String, MetadataImportParams.UserOverrideModeRef>();

        static {
            for (MetadataImportParams.UserOverrideModeRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        UserOverrideModeRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MetadataImportParams.UserOverrideModeRef fromValue(String value) {
            MetadataImportParams.UserOverrideModeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
