
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "children",
    "collection",
    "comment",
    "complex",
    "metadata",
    "name",
    "namespace",
    "order",
    "parent",
    "property",
    "simple",
    "type",
    "unorderedChildren"
})
@Generated("jsonschema2pojo")
public class Node implements Serializable
{

    @JsonProperty("children")
    private List<Node> children;
    @JsonProperty("collection")
    private Boolean collection;
    @JsonProperty("comment")
    private String comment;
    @JsonProperty("complex")
    private Boolean complex;
    @JsonProperty("metadata")
    private Boolean metadata;
    @JsonProperty("name")
    private String name;
    @JsonProperty("namespace")
    private String namespace;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("order")
    private Integer order;
    @JsonProperty("parent")
    private Node parent;
    @JsonProperty("property")
    private Property property;
    @JsonProperty("simple")
    private Boolean simple;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("type")
    private Node.TypeRef type;
    @JsonProperty("unorderedChildren")
    private List<Node> unorderedChildren;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -940759967944723440L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Node() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public Node(Node source) {
        super();
        this.children = source.children;
        this.collection = source.collection;
        this.comment = source.comment;
        this.complex = source.complex;
        this.metadata = source.metadata;
        this.name = source.name;
        this.namespace = source.namespace;
        this.order = source.order;
        this.parent = source.parent;
        this.property = source.property;
        this.simple = source.simple;
        this.type = source.type;
        this.unorderedChildren = source.unorderedChildren;
    }

    public Node(List<Node> children, Boolean collection, String comment, Boolean complex, Boolean metadata, String name, String namespace, Integer order, Node parent, Property property, Boolean simple, Node.TypeRef type, List<Node> unorderedChildren) {
        super();
        this.children = children;
        this.collection = collection;
        this.comment = comment;
        this.complex = complex;
        this.metadata = metadata;
        this.name = name;
        this.namespace = namespace;
        this.order = order;
        this.parent = parent;
        this.property = property;
        this.simple = simple;
        this.type = type;
        this.unorderedChildren = unorderedChildren;
    }

    @JsonProperty("children")
    public Optional<List<Node>> getChildren() {
        return Optional.ofNullable(children);
    }

    @JsonProperty("children")
    public void setChildren(List<Node> children) {
        this.children = children;
    }

    public Node withChildren(List<Node> children) {
        this.children = children;
        return this;
    }

    @JsonProperty("collection")
    public Optional<Boolean> getCollection() {
        return Optional.ofNullable(collection);
    }

    @JsonProperty("collection")
    public void setCollection(Boolean collection) {
        this.collection = collection;
    }

    public Node withCollection(Boolean collection) {
        this.collection = collection;
        return this;
    }

    @JsonProperty("comment")
    public Optional<String> getComment() {
        return Optional.ofNullable(comment);
    }

    @JsonProperty("comment")
    public void setComment(String comment) {
        this.comment = comment;
    }

    public Node withComment(String comment) {
        this.comment = comment;
        return this;
    }

    @JsonProperty("complex")
    public Optional<Boolean> getComplex() {
        return Optional.ofNullable(complex);
    }

    @JsonProperty("complex")
    public void setComplex(Boolean complex) {
        this.complex = complex;
    }

    public Node withComplex(Boolean complex) {
        this.complex = complex;
        return this;
    }

    @JsonProperty("metadata")
    public Optional<Boolean> getMetadata() {
        return Optional.ofNullable(metadata);
    }

    @JsonProperty("metadata")
    public void setMetadata(Boolean metadata) {
        this.metadata = metadata;
    }

    public Node withMetadata(Boolean metadata) {
        this.metadata = metadata;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public Node withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("namespace")
    public Optional<String> getNamespace() {
        return Optional.ofNullable(namespace);
    }

    @JsonProperty("namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Node withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("order")
    public Integer getOrder() {
        return order;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("order")
    public void setOrder(Integer order) {
        this.order = order;
    }

    public Node withOrder(Integer order) {
        this.order = order;
        return this;
    }

    @JsonProperty("parent")
    public Optional<Node> getParent() {
        return Optional.ofNullable(parent);
    }

    @JsonProperty("parent")
    public void setParent(Node parent) {
        this.parent = parent;
    }

    public Node withParent(Node parent) {
        this.parent = parent;
        return this;
    }

    @JsonProperty("property")
    public Optional<Property> getProperty() {
        return Optional.ofNullable(property);
    }

    @JsonProperty("property")
    public void setProperty(Property property) {
        this.property = property;
    }

    public Node withProperty(Property property) {
        this.property = property;
        return this;
    }

    @JsonProperty("simple")
    public Optional<Boolean> getSimple() {
        return Optional.ofNullable(simple);
    }

    @JsonProperty("simple")
    public void setSimple(Boolean simple) {
        this.simple = simple;
    }

    public Node withSimple(Boolean simple) {
        this.simple = simple;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("type")
    public Node.TypeRef getType() {
        return type;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("type")
    public void setType(Node.TypeRef type) {
        this.type = type;
    }

    public Node withType(Node.TypeRef type) {
        this.type = type;
        return this;
    }

    @JsonProperty("unorderedChildren")
    public Optional<List<Node>> getUnorderedChildren() {
        return Optional.ofNullable(unorderedChildren);
    }

    @JsonProperty("unorderedChildren")
    public void setUnorderedChildren(List<Node> unorderedChildren) {
        this.unorderedChildren = unorderedChildren;
    }

    public Node withUnorderedChildren(List<Node> unorderedChildren) {
        this.unorderedChildren = unorderedChildren;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Node withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("children".equals(name)) {
            if (value instanceof List) {
                setChildren(((List<Node> ) value));
            } else {
                throw new IllegalArgumentException(("property \"children\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.Node>\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("collection".equals(name)) {
                if (value instanceof Boolean) {
                    setCollection(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"collection\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("comment".equals(name)) {
                    if (value instanceof String) {
                        setComment(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"comment\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("complex".equals(name)) {
                        if (value instanceof Boolean) {
                            setComplex(((Boolean) value));
                        } else {
                            throw new IllegalArgumentException(("property \"complex\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("metadata".equals(name)) {
                            if (value instanceof Boolean) {
                                setMetadata(((Boolean) value));
                            } else {
                                throw new IllegalArgumentException(("property \"metadata\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("name".equals(name)) {
                                if (value instanceof String) {
                                    setName(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("namespace".equals(name)) {
                                    if (value instanceof String) {
                                        setNamespace(((String) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"namespace\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("order".equals(name)) {
                                        if (value instanceof Integer) {
                                            setOrder(((Integer) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"order\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("parent".equals(name)) {
                                            if (value instanceof Node) {
                                                setParent(((Node) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"parent\" is of type \"org.hisp.dhis.api.model.v40_2_2.Node\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("property".equals(name)) {
                                                if (value instanceof Property) {
                                                    setProperty(((Property) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"property\" is of type \"org.hisp.dhis.api.model.v40_2_2.Property\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("simple".equals(name)) {
                                                    if (value instanceof Boolean) {
                                                        setSimple(((Boolean) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"simple\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("type".equals(name)) {
                                                        if (value instanceof Node.TypeRef) {
                                                            setType(((Node.TypeRef) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"type\" is of type \"org.hisp.dhis.api.model.v40_2_2.Node.TypeRef\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("unorderedChildren".equals(name)) {
                                                            if (value instanceof List) {
                                                                setUnorderedChildren(((List<Node> ) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"unorderedChildren\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.Node>\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            return false;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("children".equals(name)) {
            return getChildren();
        } else {
            if ("collection".equals(name)) {
                return getCollection();
            } else {
                if ("comment".equals(name)) {
                    return getComment();
                } else {
                    if ("complex".equals(name)) {
                        return getComplex();
                    } else {
                        if ("metadata".equals(name)) {
                            return getMetadata();
                        } else {
                            if ("name".equals(name)) {
                                return getName();
                            } else {
                                if ("namespace".equals(name)) {
                                    return getNamespace();
                                } else {
                                    if ("order".equals(name)) {
                                        return getOrder();
                                    } else {
                                        if ("parent".equals(name)) {
                                            return getParent();
                                        } else {
                                            if ("property".equals(name)) {
                                                return getProperty();
                                            } else {
                                                if ("simple".equals(name)) {
                                                    return getSimple();
                                                } else {
                                                    if ("type".equals(name)) {
                                                        return getType();
                                                    } else {
                                                        if ("unorderedChildren".equals(name)) {
                                                            return getUnorderedChildren();
                                                        } else {
                                                            return notFoundValue;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Node.NOT_FOUND_VALUE);
        if (Node.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Node with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Node.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("children");
        sb.append('=');
        sb.append(((this.children == null)?"<null>":this.children));
        sb.append(',');
        sb.append("collection");
        sb.append('=');
        sb.append(((this.collection == null)?"<null>":this.collection));
        sb.append(',');
        sb.append("comment");
        sb.append('=');
        sb.append(((this.comment == null)?"<null>":this.comment));
        sb.append(',');
        sb.append("complex");
        sb.append('=');
        sb.append(((this.complex == null)?"<null>":this.complex));
        sb.append(',');
        sb.append("metadata");
        sb.append('=');
        sb.append(((this.metadata == null)?"<null>":this.metadata));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("namespace");
        sb.append('=');
        sb.append(((this.namespace == null)?"<null>":this.namespace));
        sb.append(',');
        sb.append("order");
        sb.append('=');
        sb.append(((this.order == null)?"<null>":this.order));
        sb.append(',');
        sb.append("parent");
        sb.append('=');
        sb.append(((this.parent == null)?"<null>":this.parent));
        sb.append(',');
        sb.append("property");
        sb.append('=');
        sb.append(((this.property == null)?"<null>":this.property));
        sb.append(',');
        sb.append("simple");
        sb.append('=');
        sb.append(((this.simple == null)?"<null>":this.simple));
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        sb.append("unorderedChildren");
        sb.append('=');
        sb.append(((this.unorderedChildren == null)?"<null>":this.unorderedChildren));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.parent == null)? 0 :this.parent.hashCode()));
        result = ((result* 31)+((this.metadata == null)? 0 :this.metadata.hashCode()));
        result = ((result* 31)+((this.simple == null)? 0 :this.simple.hashCode()));
        result = ((result* 31)+((this.collection == null)? 0 :this.collection.hashCode()));
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        result = ((result* 31)+((this.children == null)? 0 :this.children.hashCode()));
        result = ((result* 31)+((this.complex == null)? 0 :this.complex.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.namespace == null)? 0 :this.namespace.hashCode()));
        result = ((result* 31)+((this.property == null)? 0 :this.property.hashCode()));
        result = ((result* 31)+((this.comment == null)? 0 :this.comment.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.order == null)? 0 :this.order.hashCode()));
        result = ((result* 31)+((this.unorderedChildren == null)? 0 :this.unorderedChildren.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Node) == false) {
            return false;
        }
        Node rhs = ((Node) other);
        return (((((((((((((((this.parent == rhs.parent)||((this.parent!= null)&&this.parent.equals(rhs.parent)))&&((this.metadata == rhs.metadata)||((this.metadata!= null)&&this.metadata.equals(rhs.metadata))))&&((this.simple == rhs.simple)||((this.simple!= null)&&this.simple.equals(rhs.simple))))&&((this.collection == rhs.collection)||((this.collection!= null)&&this.collection.equals(rhs.collection))))&&((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type))))&&((this.children == rhs.children)||((this.children!= null)&&this.children.equals(rhs.children))))&&((this.complex == rhs.complex)||((this.complex!= null)&&this.complex.equals(rhs.complex))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.namespace == rhs.namespace)||((this.namespace!= null)&&this.namespace.equals(rhs.namespace))))&&((this.property == rhs.property)||((this.property!= null)&&this.property.equals(rhs.property))))&&((this.comment == rhs.comment)||((this.comment!= null)&&this.comment.equals(rhs.comment))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.order == rhs.order)||((this.order!= null)&&this.order.equals(rhs.order))))&&((this.unorderedChildren == rhs.unorderedChildren)||((this.unorderedChildren!= null)&&this.unorderedChildren.equals(rhs.unorderedChildren))));
    }

    @Generated("jsonschema2pojo")
    public enum TypeRef {

        SIMPLE("SIMPLE"),
        COMPLEX("COMPLEX"),
        COLLECTION("COLLECTION");
        private final String value;
        private final static Map<String, Node.TypeRef> CONSTANTS = new HashMap<String, Node.TypeRef>();

        static {
            for (Node.TypeRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        TypeRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Node.TypeRef fromValue(String value) {
            Node.TypeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
