
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "category",
    "completed",
    "data",
    "dataType",
    "id",
    "level",
    "message",
    "time",
    "uid"
})
@Generated("jsonschema2pojo")
public class Notification implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("category")
    private Notification.CategoryRef category;
    @JsonProperty("completed")
    private Boolean completed;
    @JsonProperty("data")
    private DataRef data;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataType")
    private Notification.DataTypeRef dataType;
    @JsonProperty("id")
    private String id;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("level")
    private Notification.LevelRef level;
    @JsonProperty("message")
    private String message;
    @JsonProperty("time")
    private Date time;
    @JsonProperty("uid")
    private String uid;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -4978208233836850144L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Notification() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public Notification(Notification source) {
        super();
        this.category = source.category;
        this.completed = source.completed;
        this.data = source.data;
        this.dataType = source.dataType;
        this.id = source.id;
        this.level = source.level;
        this.message = source.message;
        this.time = source.time;
        this.uid = source.uid;
    }

    public Notification(Notification.CategoryRef category, Boolean completed, DataRef data, Notification.DataTypeRef dataType, String id, Notification.LevelRef level, String message, Date time, String uid) {
        super();
        this.category = category;
        this.completed = completed;
        this.data = data;
        this.dataType = dataType;
        this.id = id;
        this.level = level;
        this.message = message;
        this.time = time;
        this.uid = uid;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("category")
    public Notification.CategoryRef getCategory() {
        return category;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("category")
    public void setCategory(Notification.CategoryRef category) {
        this.category = category;
    }

    public Notification withCategory(Notification.CategoryRef category) {
        this.category = category;
        return this;
    }

    @JsonProperty("completed")
    public Optional<Boolean> getCompleted() {
        return Optional.ofNullable(completed);
    }

    @JsonProperty("completed")
    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    public Notification withCompleted(Boolean completed) {
        this.completed = completed;
        return this;
    }

    @JsonProperty("data")
    public Optional<DataRef> getData() {
        return Optional.ofNullable(data);
    }

    @JsonProperty("data")
    public void setData(DataRef data) {
        this.data = data;
    }

    public Notification withData(DataRef data) {
        this.data = data;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataType")
    public Notification.DataTypeRef getDataType() {
        return dataType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataType")
    public void setDataType(Notification.DataTypeRef dataType) {
        this.dataType = dataType;
    }

    public Notification withDataType(Notification.DataTypeRef dataType) {
        this.dataType = dataType;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public Notification withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("level")
    public Notification.LevelRef getLevel() {
        return level;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("level")
    public void setLevel(Notification.LevelRef level) {
        this.level = level;
    }

    public Notification withLevel(Notification.LevelRef level) {
        this.level = level;
        return this;
    }

    @JsonProperty("message")
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    @JsonProperty("message")
    public void setMessage(String message) {
        this.message = message;
    }

    public Notification withMessage(String message) {
        this.message = message;
        return this;
    }

    @JsonProperty("time")
    public Optional<Date> getTime() {
        return Optional.ofNullable(time);
    }

    @JsonProperty("time")
    public void setTime(Date time) {
        this.time = time;
    }

    public Notification withTime(Date time) {
        this.time = time;
        return this;
    }

    @JsonProperty("uid")
    public Optional<String> getUid() {
        return Optional.ofNullable(uid);
    }

    @JsonProperty("uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    public Notification withUid(String uid) {
        this.uid = uid;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Notification withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("category".equals(name)) {
            if (value instanceof Notification.CategoryRef) {
                setCategory(((Notification.CategoryRef) value));
            } else {
                throw new IllegalArgumentException(("property \"category\" is of type \"org.hisp.dhis.api.model.v40_2_2.Notification.CategoryRef\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("completed".equals(name)) {
                if (value instanceof Boolean) {
                    setCompleted(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"completed\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("data".equals(name)) {
                    if (value instanceof DataRef) {
                        setData(((DataRef) value));
                    } else {
                        throw new IllegalArgumentException(("property \"data\" is of type \"org.hisp.dhis.api.model.v40_2_2.DataRef\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("dataType".equals(name)) {
                        if (value instanceof Notification.DataTypeRef) {
                            setDataType(((Notification.DataTypeRef) value));
                        } else {
                            throw new IllegalArgumentException(("property \"dataType\" is of type \"org.hisp.dhis.api.model.v40_2_2.Notification.DataTypeRef\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("id".equals(name)) {
                            if (value instanceof String) {
                                setId(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("level".equals(name)) {
                                if (value instanceof Notification.LevelRef) {
                                    setLevel(((Notification.LevelRef) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"level\" is of type \"org.hisp.dhis.api.model.v40_2_2.Notification.LevelRef\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("message".equals(name)) {
                                    if (value instanceof String) {
                                        setMessage(((String) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"message\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("time".equals(name)) {
                                        if (value instanceof Date) {
                                            setTime(((Date) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"time\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("uid".equals(name)) {
                                            if (value instanceof String) {
                                                setUid(((String) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"uid\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            return false;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("category".equals(name)) {
            return getCategory();
        } else {
            if ("completed".equals(name)) {
                return getCompleted();
            } else {
                if ("data".equals(name)) {
                    return getData();
                } else {
                    if ("dataType".equals(name)) {
                        return getDataType();
                    } else {
                        if ("id".equals(name)) {
                            return getId();
                        } else {
                            if ("level".equals(name)) {
                                return getLevel();
                            } else {
                                if ("message".equals(name)) {
                                    return getMessage();
                                } else {
                                    if ("time".equals(name)) {
                                        return getTime();
                                    } else {
                                        if ("uid".equals(name)) {
                                            return getUid();
                                        } else {
                                            return notFoundValue;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Notification.NOT_FOUND_VALUE);
        if (Notification.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Notification with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Notification.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("category");
        sb.append('=');
        sb.append(((this.category == null)?"<null>":this.category));
        sb.append(',');
        sb.append("completed");
        sb.append('=');
        sb.append(((this.completed == null)?"<null>":this.completed));
        sb.append(',');
        sb.append("data");
        sb.append('=');
        sb.append(((this.data == null)?"<null>":this.data));
        sb.append(',');
        sb.append("dataType");
        sb.append('=');
        sb.append(((this.dataType == null)?"<null>":this.dataType));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("level");
        sb.append('=');
        sb.append(((this.level == null)?"<null>":this.level));
        sb.append(',');
        sb.append("message");
        sb.append('=');
        sb.append(((this.message == null)?"<null>":this.message));
        sb.append(',');
        sb.append("time");
        sb.append('=');
        sb.append(((this.time == null)?"<null>":this.time));
        sb.append(',');
        sb.append("uid");
        sb.append('=');
        sb.append(((this.uid == null)?"<null>":this.uid));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.uid == null)? 0 :this.uid.hashCode()));
        result = ((result* 31)+((this.data == null)? 0 :this.data.hashCode()));
        result = ((result* 31)+((this.level == null)? 0 :this.level.hashCode()));
        result = ((result* 31)+((this.dataType == null)? 0 :this.dataType.hashCode()));
        result = ((result* 31)+((this.completed == null)? 0 :this.completed.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.time == null)? 0 :this.time.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.category == null)? 0 :this.category.hashCode()));
        result = ((result* 31)+((this.message == null)? 0 :this.message.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Notification) == false) {
            return false;
        }
        Notification rhs = ((Notification) other);
        return (((((((((((this.uid == rhs.uid)||((this.uid!= null)&&this.uid.equals(rhs.uid)))&&((this.data == rhs.data)||((this.data!= null)&&this.data.equals(rhs.data))))&&((this.level == rhs.level)||((this.level!= null)&&this.level.equals(rhs.level))))&&((this.dataType == rhs.dataType)||((this.dataType!= null)&&this.dataType.equals(rhs.dataType))))&&((this.completed == rhs.completed)||((this.completed!= null)&&this.completed.equals(rhs.completed))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.time == rhs.time)||((this.time!= null)&&this.time.equals(rhs.time))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.category == rhs.category)||((this.category!= null)&&this.category.equals(rhs.category))))&&((this.message == rhs.message)||((this.message!= null)&&this.message.equals(rhs.message))));
    }

    @Generated("jsonschema2pojo")
    public enum CategoryRef {

        DATA_STATISTICS("DATA_STATISTICS"),
        DATA_INTEGRITY("DATA_INTEGRITY"),
        RESOURCE_TABLE("RESOURCE_TABLE"),
        ANALYTICS_TABLE("ANALYTICS_TABLE"),
        CONTINUOUS_ANALYTICS_TABLE("CONTINUOUS_ANALYTICS_TABLE"),
        DATA_SYNC("DATA_SYNC"),
        TRACKER_PROGRAMS_DATA_SYNC("TRACKER_PROGRAMS_DATA_SYNC"),
        EVENT_PROGRAMS_DATA_SYNC("EVENT_PROGRAMS_DATA_SYNC"),
        FILE_RESOURCE_CLEANUP("FILE_RESOURCE_CLEANUP"),
        IMAGE_PROCESSING("IMAGE_PROCESSING"),
        META_DATA_SYNC("META_DATA_SYNC"),
        AGGREGATE_DATA_EXCHANGE("AGGREGATE_DATA_EXCHANGE"),
        SMS_SEND("SMS_SEND"),
        SEND_SCHEDULED_MESSAGE("SEND_SCHEDULED_MESSAGE"),
        PROGRAM_NOTIFICATIONS("PROGRAM_NOTIFICATIONS"),
        VALIDATION_RESULTS_NOTIFICATION("VALIDATION_RESULTS_NOTIFICATION"),
        CREDENTIALS_EXPIRY_ALERT("CREDENTIALS_EXPIRY_ALERT"),
        MONITORING("MONITORING"),
        PUSH_ANALYSIS("PUSH_ANALYSIS"),
        TRACKER_SEARCH_OPTIMIZATION("TRACKER_SEARCH_OPTIMIZATION"),
        PREDICTOR("PREDICTOR"),
        DATA_SET_NOTIFICATION("DATA_SET_NOTIFICATION"),
        REMOVE_USED_OR_EXPIRED_RESERVED_VALUES("REMOVE_USED_OR_EXPIRED_RESERVED_VALUES"),
        TRACKER_IMPORT_JOB("TRACKER_IMPORT_JOB"),
        TRACKER_IMPORT_NOTIFICATION_JOB("TRACKER_IMPORT_NOTIFICATION_JOB"),
        TRACKER_IMPORT_RULE_ENGINE_JOB("TRACKER_IMPORT_RULE_ENGINE_JOB"),
        MATERIALIZED_SQL_VIEW_UPDATE("MATERIALIZED_SQL_VIEW_UPDATE"),
        LEADER_ELECTION("LEADER_ELECTION"),
        LEADER_RENEWAL("LEADER_RENEWAL"),
        COMPLETE_DATA_SET_REGISTRATION_IMPORT("COMPLETE_DATA_SET_REGISTRATION_IMPORT"),
        DATAVALUE_IMPORT_INTERNAL("DATAVALUE_IMPORT_INTERNAL"),
        METADATA_IMPORT("METADATA_IMPORT"),
        DATAVALUE_IMPORT("DATAVALUE_IMPORT"),
        GEOJSON_IMPORT("GEOJSON_IMPORT"),
        EVENT_IMPORT("EVENT_IMPORT"),
        ENROLLMENT_IMPORT("ENROLLMENT_IMPORT"),
        TEI_IMPORT("TEI_IMPORT"),
        DISABLE_INACTIVE_USERS("DISABLE_INACTIVE_USERS"),
        ACCOUNT_EXPIRY_ALERT("ACCOUNT_EXPIRY_ALERT"),
        SYSTEM_VERSION_UPDATE_CHECK("SYSTEM_VERSION_UPDATE_CHECK"),
        TEST("TEST"),
        MOCK("MOCK"),
        GML_IMPORT("GML_IMPORT"),
        ANALYTICSTABLE_UPDATE("ANALYTICSTABLE_UPDATE"),
        PROGRAM_DATA_SYNC("PROGRAM_DATA_SYNC");
        private final String value;
        private final static Map<String, Notification.CategoryRef> CONSTANTS = new HashMap<String, Notification.CategoryRef>();

        static {
            for (Notification.CategoryRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        CategoryRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Notification.CategoryRef fromValue(String value) {
            Notification.CategoryRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum DataTypeRef {

        PARAMETERS("PARAMETERS");
        private final String value;
        private final static Map<String, Notification.DataTypeRef> CONSTANTS = new HashMap<String, Notification.DataTypeRef>();

        static {
            for (Notification.DataTypeRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        DataTypeRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Notification.DataTypeRef fromValue(String value) {
            Notification.DataTypeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum LevelRef {

        OFF("OFF"),
        DEBUG("DEBUG"),
        LOOP("LOOP"),
        INFO("INFO"),
        WARN("WARN"),
        ERROR("ERROR");
        private final String value;
        private final static Map<String, Notification.LevelRef> CONSTANTS = new HashMap<String, Notification.LevelRef>();

        static {
            for (Notification.LevelRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        LevelRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Notification.LevelRef fromValue(String value) {
            Notification.LevelRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
