
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "clazz",
    "hasOptionSet",
    "renderingTypes",
    "valueType"
})
@Generated("jsonschema2pojo")
public class ObjectValueTypeRenderingOption implements Serializable
{

    @JsonProperty("clazz")
    private String clazz;
    @JsonProperty("hasOptionSet")
    private Boolean hasOptionSet;
    @JsonProperty("renderingTypes")
    private List<RenderingTypesRefRef> renderingTypes;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("valueType")
    private ObjectValueTypeRenderingOption.ValueTypeRef valueType;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -3337834057082935102L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ObjectValueTypeRenderingOption() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ObjectValueTypeRenderingOption(ObjectValueTypeRenderingOption source) {
        super();
        this.clazz = source.clazz;
        this.hasOptionSet = source.hasOptionSet;
        this.renderingTypes = source.renderingTypes;
        this.valueType = source.valueType;
    }

    public ObjectValueTypeRenderingOption(String clazz, Boolean hasOptionSet, List<RenderingTypesRefRef> renderingTypes, ObjectValueTypeRenderingOption.ValueTypeRef valueType) {
        super();
        this.clazz = clazz;
        this.hasOptionSet = hasOptionSet;
        this.renderingTypes = renderingTypes;
        this.valueType = valueType;
    }

    @JsonProperty("clazz")
    public Optional<String> getClazz() {
        return Optional.ofNullable(clazz);
    }

    @JsonProperty("clazz")
    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    public ObjectValueTypeRenderingOption withClazz(String clazz) {
        this.clazz = clazz;
        return this;
    }

    @JsonProperty("hasOptionSet")
    public Optional<Boolean> getHasOptionSet() {
        return Optional.ofNullable(hasOptionSet);
    }

    @JsonProperty("hasOptionSet")
    public void setHasOptionSet(Boolean hasOptionSet) {
        this.hasOptionSet = hasOptionSet;
    }

    public ObjectValueTypeRenderingOption withHasOptionSet(Boolean hasOptionSet) {
        this.hasOptionSet = hasOptionSet;
        return this;
    }

    @JsonProperty("renderingTypes")
    public Optional<List<RenderingTypesRefRef>> getRenderingTypes() {
        return Optional.ofNullable(renderingTypes);
    }

    @JsonProperty("renderingTypes")
    public void setRenderingTypes(List<RenderingTypesRefRef> renderingTypes) {
        this.renderingTypes = renderingTypes;
    }

    public ObjectValueTypeRenderingOption withRenderingTypes(List<RenderingTypesRefRef> renderingTypes) {
        this.renderingTypes = renderingTypes;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("valueType")
    public ObjectValueTypeRenderingOption.ValueTypeRef getValueType() {
        return valueType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("valueType")
    public void setValueType(ObjectValueTypeRenderingOption.ValueTypeRef valueType) {
        this.valueType = valueType;
    }

    public ObjectValueTypeRenderingOption withValueType(ObjectValueTypeRenderingOption.ValueTypeRef valueType) {
        this.valueType = valueType;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ObjectValueTypeRenderingOption withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("clazz".equals(name)) {
            if (value instanceof String) {
                setClazz(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"clazz\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("hasOptionSet".equals(name)) {
                if (value instanceof Boolean) {
                    setHasOptionSet(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"hasOptionSet\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("renderingTypes".equals(name)) {
                    if (value instanceof List) {
                        setRenderingTypes(((List<RenderingTypesRefRef> ) value));
                    } else {
                        throw new IllegalArgumentException(("property \"renderingTypes\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.RenderingTypesRefRef>\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("valueType".equals(name)) {
                        if (value instanceof ObjectValueTypeRenderingOption.ValueTypeRef) {
                            setValueType(((ObjectValueTypeRenderingOption.ValueTypeRef) value));
                        } else {
                            throw new IllegalArgumentException(("property \"valueType\" is of type \"org.hisp.dhis.api.model.v40_2_2.ObjectValueTypeRenderingOption.ValueTypeRef\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("clazz".equals(name)) {
            return getClazz();
        } else {
            if ("hasOptionSet".equals(name)) {
                return getHasOptionSet();
            } else {
                if ("renderingTypes".equals(name)) {
                    return getRenderingTypes();
                } else {
                    if ("valueType".equals(name)) {
                        return getValueType();
                    } else {
                        return notFoundValue;
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ObjectValueTypeRenderingOption.NOT_FOUND_VALUE);
        if (ObjectValueTypeRenderingOption.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ObjectValueTypeRenderingOption with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ObjectValueTypeRenderingOption.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("clazz");
        sb.append('=');
        sb.append(((this.clazz == null)?"<null>":this.clazz));
        sb.append(',');
        sb.append("hasOptionSet");
        sb.append('=');
        sb.append(((this.hasOptionSet == null)?"<null>":this.hasOptionSet));
        sb.append(',');
        sb.append("renderingTypes");
        sb.append('=');
        sb.append(((this.renderingTypes == null)?"<null>":this.renderingTypes));
        sb.append(',');
        sb.append("valueType");
        sb.append('=');
        sb.append(((this.valueType == null)?"<null>":this.valueType));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.hasOptionSet == null)? 0 :this.hasOptionSet.hashCode()));
        result = ((result* 31)+((this.valueType == null)? 0 :this.valueType.hashCode()));
        result = ((result* 31)+((this.renderingTypes == null)? 0 :this.renderingTypes.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.clazz == null)? 0 :this.clazz.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ObjectValueTypeRenderingOption) == false) {
            return false;
        }
        ObjectValueTypeRenderingOption rhs = ((ObjectValueTypeRenderingOption) other);
        return ((((((this.hasOptionSet == rhs.hasOptionSet)||((this.hasOptionSet!= null)&&this.hasOptionSet.equals(rhs.hasOptionSet)))&&((this.valueType == rhs.valueType)||((this.valueType!= null)&&this.valueType.equals(rhs.valueType))))&&((this.renderingTypes == rhs.renderingTypes)||((this.renderingTypes!= null)&&this.renderingTypes.equals(rhs.renderingTypes))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.clazz == rhs.clazz)||((this.clazz!= null)&&this.clazz.equals(rhs.clazz))));
    }

    @Generated("jsonschema2pojo")
    public enum ValueTypeRef {

        TEXT("TEXT"),
        LONG_TEXT("LONG_TEXT"),
        MULTI_TEXT("MULTI_TEXT"),
        LETTER("LETTER"),
        PHONE_NUMBER("PHONE_NUMBER"),
        EMAIL("EMAIL"),
        BOOLEAN("BOOLEAN"),
        TRUE_ONLY("TRUE_ONLY"),
        DATE("DATE"),
        DATETIME("DATETIME"),
        TIME("TIME"),
        NUMBER("NUMBER"),
        UNIT_INTERVAL("UNIT_INTERVAL"),
        PERCENTAGE("PERCENTAGE"),
        INTEGER("INTEGER"),
        INTEGER_POSITIVE("INTEGER_POSITIVE"),
        INTEGER_NEGATIVE("INTEGER_NEGATIVE"),
        INTEGER_ZERO_OR_POSITIVE("INTEGER_ZERO_OR_POSITIVE"),
        TRACKER_ASSOCIATE("TRACKER_ASSOCIATE"),
        USERNAME("USERNAME"),
        COORDINATE("COORDINATE"),
        ORGANISATION_UNIT("ORGANISATION_UNIT"),
        REFERENCE("REFERENCE"),
        AGE("AGE"),
        URL("URL"),
        FILE_RESOURCE("FILE_RESOURCE"),
        IMAGE("IMAGE"),
        GEOJSON("GEOJSON");
        private final String value;
        private final static Map<String, ObjectValueTypeRenderingOption.ValueTypeRef> CONSTANTS = new HashMap<String, ObjectValueTypeRenderingOption.ValueTypeRef>();

        static {
            for (ObjectValueTypeRenderingOption.ValueTypeRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ValueTypeRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ObjectValueTypeRenderingOption.ValueTypeRef fromValue(String value) {
            ObjectValueTypeRenderingOption.ValueTypeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
