
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "direction",
    "field"
})
@Generated("jsonschema2pojo")
public class OrderCriteria implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("direction")
    private OrderCriteria.DirectionRef direction;
    @JsonProperty("field")
    private String field;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -1971082501434804847L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public OrderCriteria() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public OrderCriteria(OrderCriteria source) {
        super();
        this.direction = source.direction;
        this.field = source.field;
    }

    public OrderCriteria(OrderCriteria.DirectionRef direction, String field) {
        super();
        this.direction = direction;
        this.field = field;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("direction")
    public OrderCriteria.DirectionRef getDirection() {
        return direction;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("direction")
    public void setDirection(OrderCriteria.DirectionRef direction) {
        this.direction = direction;
    }

    public OrderCriteria withDirection(OrderCriteria.DirectionRef direction) {
        this.direction = direction;
        return this;
    }

    @JsonProperty("field")
    public Optional<String> getField() {
        return Optional.ofNullable(field);
    }

    @JsonProperty("field")
    public void setField(String field) {
        this.field = field;
    }

    public OrderCriteria withField(String field) {
        this.field = field;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public OrderCriteria withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("direction".equals(name)) {
            if (value instanceof OrderCriteria.DirectionRef) {
                setDirection(((OrderCriteria.DirectionRef) value));
            } else {
                throw new IllegalArgumentException(("property \"direction\" is of type \"org.hisp.dhis.api.model.v40_2_2.OrderCriteria.DirectionRef\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("field".equals(name)) {
                if (value instanceof String) {
                    setField(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"field\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                return false;
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("direction".equals(name)) {
            return getDirection();
        } else {
            if ("field".equals(name)) {
                return getField();
            } else {
                return notFoundValue;
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, OrderCriteria.NOT_FOUND_VALUE);
        if (OrderCriteria.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public OrderCriteria with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OrderCriteria.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("direction");
        sb.append('=');
        sb.append(((this.direction == null)?"<null>":this.direction));
        sb.append(',');
        sb.append("field");
        sb.append('=');
        sb.append(((this.field == null)?"<null>":this.field));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.field == null)? 0 :this.field.hashCode()));
        result = ((result* 31)+((this.direction == null)? 0 :this.direction.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OrderCriteria) == false) {
            return false;
        }
        OrderCriteria rhs = ((OrderCriteria) other);
        return ((((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties)))&&((this.field == rhs.field)||((this.field!= null)&&this.field.equals(rhs.field))))&&((this.direction == rhs.direction)||((this.direction!= null)&&this.direction.equals(rhs.direction))));
    }

    @Generated("jsonschema2pojo")
    public enum DirectionRef {

        ASC("ASC"),
        DESC("DESC"),
        IASC("IASC"),
        IDESC("IDESC");
        private final String value;
        private final static Map<String, OrderCriteria.DirectionRef> CONSTANTS = new HashMap<String, OrderCriteria.DirectionRef>();

        static {
            for (OrderCriteria.DirectionRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        DirectionRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OrderCriteria.DirectionRef fromValue(String value) {
            OrderCriteria.DirectionRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
