
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "dataApprovalMergeStrategy",
    "dataValueMergeStrategy",
    "deleteSources",
    "sources",
    "target"
})
@Generated("jsonschema2pojo")
public class OrgUnitMergeQuery implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataApprovalMergeStrategy")
    private OrgUnitMergeQuery.DataApprovalMergeStrategyRef dataApprovalMergeStrategy;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataValueMergeStrategy")
    private OrgUnitMergeQuery.DataValueMergeStrategyRef dataValueMergeStrategy;
    @JsonProperty("deleteSources")
    private Boolean deleteSources;
    @JsonProperty("sources")
    private List<String> sources;
    @JsonProperty("target")
    private String target;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -7070741835301701946L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public OrgUnitMergeQuery() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public OrgUnitMergeQuery(OrgUnitMergeQuery source) {
        super();
        this.dataApprovalMergeStrategy = source.dataApprovalMergeStrategy;
        this.dataValueMergeStrategy = source.dataValueMergeStrategy;
        this.deleteSources = source.deleteSources;
        this.sources = source.sources;
        this.target = source.target;
    }

    public OrgUnitMergeQuery(OrgUnitMergeQuery.DataApprovalMergeStrategyRef dataApprovalMergeStrategy, OrgUnitMergeQuery.DataValueMergeStrategyRef dataValueMergeStrategy, Boolean deleteSources, List<String> sources, String target) {
        super();
        this.dataApprovalMergeStrategy = dataApprovalMergeStrategy;
        this.dataValueMergeStrategy = dataValueMergeStrategy;
        this.deleteSources = deleteSources;
        this.sources = sources;
        this.target = target;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataApprovalMergeStrategy")
    public OrgUnitMergeQuery.DataApprovalMergeStrategyRef getDataApprovalMergeStrategy() {
        return dataApprovalMergeStrategy;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataApprovalMergeStrategy")
    public void setDataApprovalMergeStrategy(OrgUnitMergeQuery.DataApprovalMergeStrategyRef dataApprovalMergeStrategy) {
        this.dataApprovalMergeStrategy = dataApprovalMergeStrategy;
    }

    public OrgUnitMergeQuery withDataApprovalMergeStrategy(OrgUnitMergeQuery.DataApprovalMergeStrategyRef dataApprovalMergeStrategy) {
        this.dataApprovalMergeStrategy = dataApprovalMergeStrategy;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataValueMergeStrategy")
    public OrgUnitMergeQuery.DataValueMergeStrategyRef getDataValueMergeStrategy() {
        return dataValueMergeStrategy;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataValueMergeStrategy")
    public void setDataValueMergeStrategy(OrgUnitMergeQuery.DataValueMergeStrategyRef dataValueMergeStrategy) {
        this.dataValueMergeStrategy = dataValueMergeStrategy;
    }

    public OrgUnitMergeQuery withDataValueMergeStrategy(OrgUnitMergeQuery.DataValueMergeStrategyRef dataValueMergeStrategy) {
        this.dataValueMergeStrategy = dataValueMergeStrategy;
        return this;
    }

    @JsonProperty("deleteSources")
    public Optional<Boolean> getDeleteSources() {
        return Optional.ofNullable(deleteSources);
    }

    @JsonProperty("deleteSources")
    public void setDeleteSources(Boolean deleteSources) {
        this.deleteSources = deleteSources;
    }

    public OrgUnitMergeQuery withDeleteSources(Boolean deleteSources) {
        this.deleteSources = deleteSources;
        return this;
    }

    @JsonProperty("sources")
    public Optional<List<String>> getSources() {
        return Optional.ofNullable(sources);
    }

    @JsonProperty("sources")
    public void setSources(List<String> sources) {
        this.sources = sources;
    }

    public OrgUnitMergeQuery withSources(List<String> sources) {
        this.sources = sources;
        return this;
    }

    @JsonProperty("target")
    public Optional<String> getTarget() {
        return Optional.ofNullable(target);
    }

    @JsonProperty("target")
    public void setTarget(String target) {
        this.target = target;
    }

    public OrgUnitMergeQuery withTarget(String target) {
        this.target = target;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public OrgUnitMergeQuery withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("dataApprovalMergeStrategy".equals(name)) {
            if (value instanceof OrgUnitMergeQuery.DataApprovalMergeStrategyRef) {
                setDataApprovalMergeStrategy(((OrgUnitMergeQuery.DataApprovalMergeStrategyRef) value));
            } else {
                throw new IllegalArgumentException(("property \"dataApprovalMergeStrategy\" is of type \"org.hisp.dhis.api.model.v40_2_2.OrgUnitMergeQuery.DataApprovalMergeStrategyRef\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("dataValueMergeStrategy".equals(name)) {
                if (value instanceof OrgUnitMergeQuery.DataValueMergeStrategyRef) {
                    setDataValueMergeStrategy(((OrgUnitMergeQuery.DataValueMergeStrategyRef) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataValueMergeStrategy\" is of type \"org.hisp.dhis.api.model.v40_2_2.OrgUnitMergeQuery.DataValueMergeStrategyRef\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("deleteSources".equals(name)) {
                    if (value instanceof Boolean) {
                        setDeleteSources(((Boolean) value));
                    } else {
                        throw new IllegalArgumentException(("property \"deleteSources\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("sources".equals(name)) {
                        if (value instanceof List) {
                            setSources(((List<String> ) value));
                        } else {
                            throw new IllegalArgumentException(("property \"sources\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("target".equals(name)) {
                            if (value instanceof String) {
                                setTarget(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"target\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            return false;
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("dataApprovalMergeStrategy".equals(name)) {
            return getDataApprovalMergeStrategy();
        } else {
            if ("dataValueMergeStrategy".equals(name)) {
                return getDataValueMergeStrategy();
            } else {
                if ("deleteSources".equals(name)) {
                    return getDeleteSources();
                } else {
                    if ("sources".equals(name)) {
                        return getSources();
                    } else {
                        if ("target".equals(name)) {
                            return getTarget();
                        } else {
                            return notFoundValue;
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, OrgUnitMergeQuery.NOT_FOUND_VALUE);
        if (OrgUnitMergeQuery.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public OrgUnitMergeQuery with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OrgUnitMergeQuery.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("dataApprovalMergeStrategy");
        sb.append('=');
        sb.append(((this.dataApprovalMergeStrategy == null)?"<null>":this.dataApprovalMergeStrategy));
        sb.append(',');
        sb.append("dataValueMergeStrategy");
        sb.append('=');
        sb.append(((this.dataValueMergeStrategy == null)?"<null>":this.dataValueMergeStrategy));
        sb.append(',');
        sb.append("deleteSources");
        sb.append('=');
        sb.append(((this.deleteSources == null)?"<null>":this.deleteSources));
        sb.append(',');
        sb.append("sources");
        sb.append('=');
        sb.append(((this.sources == null)?"<null>":this.sources));
        sb.append(',');
        sb.append("target");
        sb.append('=');
        sb.append(((this.target == null)?"<null>":this.target));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.dataValueMergeStrategy == null)? 0 :this.dataValueMergeStrategy.hashCode()));
        result = ((result* 31)+((this.sources == null)? 0 :this.sources.hashCode()));
        result = ((result* 31)+((this.deleteSources == null)? 0 :this.deleteSources.hashCode()));
        result = ((result* 31)+((this.dataApprovalMergeStrategy == null)? 0 :this.dataApprovalMergeStrategy.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.target == null)? 0 :this.target.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OrgUnitMergeQuery) == false) {
            return false;
        }
        OrgUnitMergeQuery rhs = ((OrgUnitMergeQuery) other);
        return (((((((this.dataValueMergeStrategy == rhs.dataValueMergeStrategy)||((this.dataValueMergeStrategy!= null)&&this.dataValueMergeStrategy.equals(rhs.dataValueMergeStrategy)))&&((this.sources == rhs.sources)||((this.sources!= null)&&this.sources.equals(rhs.sources))))&&((this.deleteSources == rhs.deleteSources)||((this.deleteSources!= null)&&this.deleteSources.equals(rhs.deleteSources))))&&((this.dataApprovalMergeStrategy == rhs.dataApprovalMergeStrategy)||((this.dataApprovalMergeStrategy!= null)&&this.dataApprovalMergeStrategy.equals(rhs.dataApprovalMergeStrategy))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.target == rhs.target)||((this.target!= null)&&this.target.equals(rhs.target))));
    }

    @Generated("jsonschema2pojo")
    public enum DataApprovalMergeStrategyRef {

        LAST_UPDATED("LAST_UPDATED"),
        DISCARD("DISCARD");
        private final String value;
        private final static Map<String, OrgUnitMergeQuery.DataApprovalMergeStrategyRef> CONSTANTS = new HashMap<String, OrgUnitMergeQuery.DataApprovalMergeStrategyRef>();

        static {
            for (OrgUnitMergeQuery.DataApprovalMergeStrategyRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        DataApprovalMergeStrategyRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OrgUnitMergeQuery.DataApprovalMergeStrategyRef fromValue(String value) {
            OrgUnitMergeQuery.DataApprovalMergeStrategyRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum DataValueMergeStrategyRef {

        LAST_UPDATED("LAST_UPDATED"),
        DISCARD("DISCARD");
        private final String value;
        private final static Map<String, OrgUnitMergeQuery.DataValueMergeStrategyRef> CONSTANTS = new HashMap<String, OrgUnitMergeQuery.DataValueMergeStrategyRef>();

        static {
            for (OrgUnitMergeQuery.DataValueMergeStrategyRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        DataValueMergeStrategyRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OrgUnitMergeQuery.DataValueMergeStrategyRef fromValue(String value) {
            OrgUnitMergeQuery.DataValueMergeStrategyRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
