
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "enabled",
    "extremeLines",
    "normalizationMethod",
    "outlierMethod",
    "thresholdFactor"
})
@Generated("jsonschema2pojo")
public class OutlierAnalysis implements Serializable
{

    @JsonProperty("enabled")
    private Boolean enabled;
    @JsonProperty("extremeLines")
    private OutlierLine extremeLines;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("normalizationMethod")
    private OutlierAnalysis.NormalizationMethodRef normalizationMethod;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("outlierMethod")
    private OutlierAnalysis.OutlierMethodRef outlierMethod;
    @JsonProperty("thresholdFactor")
    private Double thresholdFactor;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -1144107124395375441L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public OutlierAnalysis() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public OutlierAnalysis(OutlierAnalysis source) {
        super();
        this.enabled = source.enabled;
        this.extremeLines = source.extremeLines;
        this.normalizationMethod = source.normalizationMethod;
        this.outlierMethod = source.outlierMethod;
        this.thresholdFactor = source.thresholdFactor;
    }

    public OutlierAnalysis(Boolean enabled, OutlierLine extremeLines, OutlierAnalysis.NormalizationMethodRef normalizationMethod, OutlierAnalysis.OutlierMethodRef outlierMethod, Double thresholdFactor) {
        super();
        this.enabled = enabled;
        this.extremeLines = extremeLines;
        this.normalizationMethod = normalizationMethod;
        this.outlierMethod = outlierMethod;
        this.thresholdFactor = thresholdFactor;
    }

    @JsonProperty("enabled")
    public Optional<Boolean> getEnabled() {
        return Optional.ofNullable(enabled);
    }

    @JsonProperty("enabled")
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public OutlierAnalysis withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @JsonProperty("extremeLines")
    public Optional<OutlierLine> getExtremeLines() {
        return Optional.ofNullable(extremeLines);
    }

    @JsonProperty("extremeLines")
    public void setExtremeLines(OutlierLine extremeLines) {
        this.extremeLines = extremeLines;
    }

    public OutlierAnalysis withExtremeLines(OutlierLine extremeLines) {
        this.extremeLines = extremeLines;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("normalizationMethod")
    public OutlierAnalysis.NormalizationMethodRef getNormalizationMethod() {
        return normalizationMethod;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("normalizationMethod")
    public void setNormalizationMethod(OutlierAnalysis.NormalizationMethodRef normalizationMethod) {
        this.normalizationMethod = normalizationMethod;
    }

    public OutlierAnalysis withNormalizationMethod(OutlierAnalysis.NormalizationMethodRef normalizationMethod) {
        this.normalizationMethod = normalizationMethod;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("outlierMethod")
    public OutlierAnalysis.OutlierMethodRef getOutlierMethod() {
        return outlierMethod;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("outlierMethod")
    public void setOutlierMethod(OutlierAnalysis.OutlierMethodRef outlierMethod) {
        this.outlierMethod = outlierMethod;
    }

    public OutlierAnalysis withOutlierMethod(OutlierAnalysis.OutlierMethodRef outlierMethod) {
        this.outlierMethod = outlierMethod;
        return this;
    }

    @JsonProperty("thresholdFactor")
    public Optional<Double> getThresholdFactor() {
        return Optional.ofNullable(thresholdFactor);
    }

    @JsonProperty("thresholdFactor")
    public void setThresholdFactor(Double thresholdFactor) {
        this.thresholdFactor = thresholdFactor;
    }

    public OutlierAnalysis withThresholdFactor(Double thresholdFactor) {
        this.thresholdFactor = thresholdFactor;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public OutlierAnalysis withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("enabled".equals(name)) {
            if (value instanceof Boolean) {
                setEnabled(((Boolean) value));
            } else {
                throw new IllegalArgumentException(("property \"enabled\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("extremeLines".equals(name)) {
                if (value instanceof OutlierLine) {
                    setExtremeLines(((OutlierLine) value));
                } else {
                    throw new IllegalArgumentException(("property \"extremeLines\" is of type \"org.hisp.dhis.api.model.v40_2_2.OutlierLine\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("normalizationMethod".equals(name)) {
                    if (value instanceof OutlierAnalysis.NormalizationMethodRef) {
                        setNormalizationMethod(((OutlierAnalysis.NormalizationMethodRef) value));
                    } else {
                        throw new IllegalArgumentException(("property \"normalizationMethod\" is of type \"org.hisp.dhis.api.model.v40_2_2.OutlierAnalysis.NormalizationMethodRef\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("outlierMethod".equals(name)) {
                        if (value instanceof OutlierAnalysis.OutlierMethodRef) {
                            setOutlierMethod(((OutlierAnalysis.OutlierMethodRef) value));
                        } else {
                            throw new IllegalArgumentException(("property \"outlierMethod\" is of type \"org.hisp.dhis.api.model.v40_2_2.OutlierAnalysis.OutlierMethodRef\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("thresholdFactor".equals(name)) {
                            if (value instanceof Double) {
                                setThresholdFactor(((Double) value));
                            } else {
                                throw new IllegalArgumentException(("property \"thresholdFactor\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            return false;
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("enabled".equals(name)) {
            return getEnabled();
        } else {
            if ("extremeLines".equals(name)) {
                return getExtremeLines();
            } else {
                if ("normalizationMethod".equals(name)) {
                    return getNormalizationMethod();
                } else {
                    if ("outlierMethod".equals(name)) {
                        return getOutlierMethod();
                    } else {
                        if ("thresholdFactor".equals(name)) {
                            return getThresholdFactor();
                        } else {
                            return notFoundValue;
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, OutlierAnalysis.NOT_FOUND_VALUE);
        if (OutlierAnalysis.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public OutlierAnalysis with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OutlierAnalysis.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("enabled");
        sb.append('=');
        sb.append(((this.enabled == null)?"<null>":this.enabled));
        sb.append(',');
        sb.append("extremeLines");
        sb.append('=');
        sb.append(((this.extremeLines == null)?"<null>":this.extremeLines));
        sb.append(',');
        sb.append("normalizationMethod");
        sb.append('=');
        sb.append(((this.normalizationMethod == null)?"<null>":this.normalizationMethod));
        sb.append(',');
        sb.append("outlierMethod");
        sb.append('=');
        sb.append(((this.outlierMethod == null)?"<null>":this.outlierMethod));
        sb.append(',');
        sb.append("thresholdFactor");
        sb.append('=');
        sb.append(((this.thresholdFactor == null)?"<null>":this.thresholdFactor));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.thresholdFactor == null)? 0 :this.thresholdFactor.hashCode()));
        result = ((result* 31)+((this.extremeLines == null)? 0 :this.extremeLines.hashCode()));
        result = ((result* 31)+((this.normalizationMethod == null)? 0 :this.normalizationMethod.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.enabled == null)? 0 :this.enabled.hashCode()));
        result = ((result* 31)+((this.outlierMethod == null)? 0 :this.outlierMethod.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OutlierAnalysis) == false) {
            return false;
        }
        OutlierAnalysis rhs = ((OutlierAnalysis) other);
        return (((((((this.thresholdFactor == rhs.thresholdFactor)||((this.thresholdFactor!= null)&&this.thresholdFactor.equals(rhs.thresholdFactor)))&&((this.extremeLines == rhs.extremeLines)||((this.extremeLines!= null)&&this.extremeLines.equals(rhs.extremeLines))))&&((this.normalizationMethod == rhs.normalizationMethod)||((this.normalizationMethod!= null)&&this.normalizationMethod.equals(rhs.normalizationMethod))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.enabled == rhs.enabled)||((this.enabled!= null)&&this.enabled.equals(rhs.enabled))))&&((this.outlierMethod == rhs.outlierMethod)||((this.outlierMethod!= null)&&this.outlierMethod.equals(rhs.outlierMethod))));
    }

    @Generated("jsonschema2pojo")
    public enum NormalizationMethodRef {

        Y_RESIDUALS_LINEAR("Y_RESIDUALS_LINEAR");
        private final String value;
        private final static Map<String, OutlierAnalysis.NormalizationMethodRef> CONSTANTS = new HashMap<String, OutlierAnalysis.NormalizationMethodRef>();

        static {
            for (OutlierAnalysis.NormalizationMethodRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        NormalizationMethodRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OutlierAnalysis.NormalizationMethodRef fromValue(String value) {
            OutlierAnalysis.NormalizationMethodRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum OutlierMethodRef {

        IQR("IQR"),
        STANDARD_Z_SCORE("STANDARD_Z_SCORE"),
        MODIFIED_Z_SCORE("MODIFIED_Z_SCORE");
        private final String value;
        private final static Map<String, OutlierAnalysis.OutlierMethodRef> CONSTANTS = new HashMap<String, OutlierAnalysis.OutlierMethodRef>();

        static {
            for (OutlierAnalysis.OutlierMethodRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        OutlierMethodRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OutlierAnalysis.OutlierMethodRef fromValue(String value) {
            OutlierAnalysis.OutlierMethodRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
