
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "allowFutureDate",
    "attributeValues",
    "code",
    "created",
    "createdBy",
    "displayInList",
    "displayName",
    "displayShortName",
    "externalAccess",
    "favorite",
    "favorites",
    "href",
    "id",
    "lastUpdated",
    "lastUpdatedBy",
    "mandatory",
    "program",
    "publicAccess",
    "renderOptionsAsRadio",
    "renderType",
    "searchable",
    "sharing",
    "sortOrder",
    "trackedEntityAttribute",
    "translations",
    "user",
    "userAccesses",
    "userGroupAccesses",
    "valueType"
})
@Generated("jsonschema2pojo")
public class ProgramTrackedEntityAttribute implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("allowFutureDate")
    private Boolean allowFutureDate;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues;
    @JsonProperty("code")
    private String code;
    @JsonProperty("created")
    private Date created;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private CreatedByRef__64 createdBy;
    @JsonProperty("displayInList")
    private Boolean displayInList;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("displayShortName")
    private String displayShortName;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private LastUpdatedByRef__64 lastUpdatedBy;
    @JsonProperty("mandatory")
    private Boolean mandatory;
    /**
     * A UID reference to a Program  
     * (Java name `org.hisp.dhis.program.Program`)
     * 
     */
    @JsonProperty("program")
    @JsonPropertyDescription("A UID reference to a Program  \n(Java name `org.hisp.dhis.program.Program`)")
    private ProgramRef__4 program;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("renderOptionsAsRadio")
    private Boolean renderOptionsAsRadio;
    /**
     * The exact type is unknown.  
     * (Java type was: `org.hisp.dhis.render.DeviceRenderTypeMap<org.hisp.dhis.render.type.ValueTypeRenderingObject>`)
     * 
     */
    @JsonProperty("renderType")
    @JsonPropertyDescription("The exact type is unknown.  \n(Java type was: `org.hisp.dhis.render.DeviceRenderTypeMap<org.hisp.dhis.render.type.ValueTypeRenderingObject>`)")
    private Object renderType;
    @JsonProperty("searchable")
    private Boolean searchable;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("sortOrder")
    private Integer sortOrder;
    /**
     * A UID reference to a TrackedEntityAttribute  
     * (Java name `org.hisp.dhis.trackedentity.TrackedEntityAttribute`)
     * 
     */
    @JsonProperty("trackedEntityAttribute")
    @JsonPropertyDescription("A UID reference to a TrackedEntityAttribute  \n(Java name `org.hisp.dhis.trackedentity.TrackedEntityAttribute`)")
    private TrackedEntityAttributeRef trackedEntityAttribute;
    @JsonProperty("translations")
    private List<Translation> translations;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private UserRef__66 user;
    @JsonProperty("userAccesses")
    private List<LegacyUserAccess> userAccesses;
    @JsonProperty("userGroupAccesses")
    private List<LegacyUserGroupAccess> userGroupAccesses;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("valueType")
    private ProgramTrackedEntityAttribute.ValueTypeRef valueType;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 8025978085592202540L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ProgramTrackedEntityAttribute() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ProgramTrackedEntityAttribute(ProgramTrackedEntityAttribute source) {
        super();
        this.access = source.access;
        this.allowFutureDate = source.allowFutureDate;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.displayInList = source.displayInList;
        this.displayName = source.displayName;
        this.displayShortName = source.displayShortName;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.href = source.href;
        this.id = source.id;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.mandatory = source.mandatory;
        this.program = source.program;
        this.publicAccess = source.publicAccess;
        this.renderOptionsAsRadio = source.renderOptionsAsRadio;
        this.renderType = source.renderType;
        this.searchable = source.searchable;
        this.sharing = source.sharing;
        this.sortOrder = source.sortOrder;
        this.trackedEntityAttribute = source.trackedEntityAttribute;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
        this.valueType = source.valueType;
    }

    /**
     * 
     * @param lastUpdatedBy
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     * @param createdBy
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     * @param program
     *     A UID reference to a Program  
     *     (Java name `org.hisp.dhis.program.Program`).
     * @param renderType
     *     The exact type is unknown.  
     *     (Java type was: `org.hisp.dhis.render.DeviceRenderTypeMap<org.hisp.dhis.render.type.ValueTypeRenderingObject>`).
     * @param user
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     * @param trackedEntityAttribute
     *     A UID reference to a TrackedEntityAttribute  
     *     (Java name `org.hisp.dhis.trackedentity.TrackedEntityAttribute`).
     */
    public ProgramTrackedEntityAttribute(Access access, Boolean allowFutureDate, List<AttributeValue> attributeValues, String code, Date created, CreatedByRef__64 createdBy, Boolean displayInList, String displayName, String displayShortName, Boolean externalAccess, Boolean favorite, List<String> favorites, String href, String id, Date lastUpdated, LastUpdatedByRef__64 lastUpdatedBy, Boolean mandatory, ProgramRef__4 program, String publicAccess, Boolean renderOptionsAsRadio, Object renderType, Boolean searchable, Sharing sharing, Integer sortOrder, TrackedEntityAttributeRef trackedEntityAttribute, List<Translation> translations, UserRef__66 user, List<LegacyUserAccess> userAccesses, List<LegacyUserGroupAccess> userGroupAccesses, ProgramTrackedEntityAttribute.ValueTypeRef valueType) {
        super();
        this.access = access;
        this.allowFutureDate = allowFutureDate;
        this.attributeValues = attributeValues;
        this.code = code;
        this.created = created;
        this.createdBy = createdBy;
        this.displayInList = displayInList;
        this.displayName = displayName;
        this.displayShortName = displayShortName;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.href = href;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.mandatory = mandatory;
        this.program = program;
        this.publicAccess = publicAccess;
        this.renderOptionsAsRadio = renderOptionsAsRadio;
        this.renderType = renderType;
        this.searchable = searchable;
        this.sharing = sharing;
        this.sortOrder = sortOrder;
        this.trackedEntityAttribute = trackedEntityAttribute;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
        this.valueType = valueType;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public ProgramTrackedEntityAttribute withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("allowFutureDate")
    public Optional<Boolean> getAllowFutureDate() {
        return Optional.ofNullable(allowFutureDate);
    }

    @JsonProperty("allowFutureDate")
    public void setAllowFutureDate(Boolean allowFutureDate) {
        this.allowFutureDate = allowFutureDate;
    }

    public ProgramTrackedEntityAttribute withAllowFutureDate(Boolean allowFutureDate) {
        this.allowFutureDate = allowFutureDate;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public ProgramTrackedEntityAttribute withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public ProgramTrackedEntityAttribute withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public ProgramTrackedEntityAttribute withCreated(Date created) {
        this.created = created;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public Optional<CreatedByRef__64> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public void setCreatedBy(CreatedByRef__64 createdBy) {
        this.createdBy = createdBy;
    }

    public ProgramTrackedEntityAttribute withCreatedBy(CreatedByRef__64 createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty("displayInList")
    public Optional<Boolean> getDisplayInList() {
        return Optional.ofNullable(displayInList);
    }

    @JsonProperty("displayInList")
    public void setDisplayInList(Boolean displayInList) {
        this.displayInList = displayInList;
    }

    public ProgramTrackedEntityAttribute withDisplayInList(Boolean displayInList) {
        this.displayInList = displayInList;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ProgramTrackedEntityAttribute withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("displayShortName")
    public Optional<String> getDisplayShortName() {
        return Optional.ofNullable(displayShortName);
    }

    @JsonProperty("displayShortName")
    public void setDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
    }

    public ProgramTrackedEntityAttribute withDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public ProgramTrackedEntityAttribute withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public ProgramTrackedEntityAttribute withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public ProgramTrackedEntityAttribute withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public ProgramTrackedEntityAttribute withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public ProgramTrackedEntityAttribute withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public ProgramTrackedEntityAttribute withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public Optional<LastUpdatedByRef__64> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(LastUpdatedByRef__64 lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public ProgramTrackedEntityAttribute withLastUpdatedBy(LastUpdatedByRef__64 lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("mandatory")
    public Optional<Boolean> getMandatory() {
        return Optional.ofNullable(mandatory);
    }

    @JsonProperty("mandatory")
    public void setMandatory(Boolean mandatory) {
        this.mandatory = mandatory;
    }

    public ProgramTrackedEntityAttribute withMandatory(Boolean mandatory) {
        this.mandatory = mandatory;
        return this;
    }

    /**
     * A UID reference to a Program  
     * (Java name `org.hisp.dhis.program.Program`)
     * 
     */
    @JsonProperty("program")
    public Optional<ProgramRef__4> getProgram() {
        return Optional.ofNullable(program);
    }

    /**
     * A UID reference to a Program  
     * (Java name `org.hisp.dhis.program.Program`)
     * 
     */
    @JsonProperty("program")
    public void setProgram(ProgramRef__4 program) {
        this.program = program;
    }

    public ProgramTrackedEntityAttribute withProgram(ProgramRef__4 program) {
        this.program = program;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public ProgramTrackedEntityAttribute withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("renderOptionsAsRadio")
    public Optional<Boolean> getRenderOptionsAsRadio() {
        return Optional.ofNullable(renderOptionsAsRadio);
    }

    @JsonProperty("renderOptionsAsRadio")
    public void setRenderOptionsAsRadio(Boolean renderOptionsAsRadio) {
        this.renderOptionsAsRadio = renderOptionsAsRadio;
    }

    public ProgramTrackedEntityAttribute withRenderOptionsAsRadio(Boolean renderOptionsAsRadio) {
        this.renderOptionsAsRadio = renderOptionsAsRadio;
        return this;
    }

    /**
     * The exact type is unknown.  
     * (Java type was: `org.hisp.dhis.render.DeviceRenderTypeMap<org.hisp.dhis.render.type.ValueTypeRenderingObject>`)
     * 
     */
    @JsonProperty("renderType")
    public Optional<Object> getRenderType() {
        return Optional.ofNullable(renderType);
    }

    /**
     * The exact type is unknown.  
     * (Java type was: `org.hisp.dhis.render.DeviceRenderTypeMap<org.hisp.dhis.render.type.ValueTypeRenderingObject>`)
     * 
     */
    @JsonProperty("renderType")
    public void setRenderType(Object renderType) {
        this.renderType = renderType;
    }

    public ProgramTrackedEntityAttribute withRenderType(Object renderType) {
        this.renderType = renderType;
        return this;
    }

    @JsonProperty("searchable")
    public Optional<Boolean> getSearchable() {
        return Optional.ofNullable(searchable);
    }

    @JsonProperty("searchable")
    public void setSearchable(Boolean searchable) {
        this.searchable = searchable;
    }

    public ProgramTrackedEntityAttribute withSearchable(Boolean searchable) {
        this.searchable = searchable;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public ProgramTrackedEntityAttribute withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("sortOrder")
    public Optional<Integer> getSortOrder() {
        return Optional.ofNullable(sortOrder);
    }

    @JsonProperty("sortOrder")
    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    public ProgramTrackedEntityAttribute withSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    /**
     * A UID reference to a TrackedEntityAttribute  
     * (Java name `org.hisp.dhis.trackedentity.TrackedEntityAttribute`)
     * 
     */
    @JsonProperty("trackedEntityAttribute")
    public Optional<TrackedEntityAttributeRef> getTrackedEntityAttribute() {
        return Optional.ofNullable(trackedEntityAttribute);
    }

    /**
     * A UID reference to a TrackedEntityAttribute  
     * (Java name `org.hisp.dhis.trackedentity.TrackedEntityAttribute`)
     * 
     */
    @JsonProperty("trackedEntityAttribute")
    public void setTrackedEntityAttribute(TrackedEntityAttributeRef trackedEntityAttribute) {
        this.trackedEntityAttribute = trackedEntityAttribute;
    }

    public ProgramTrackedEntityAttribute withTrackedEntityAttribute(TrackedEntityAttributeRef trackedEntityAttribute) {
        this.trackedEntityAttribute = trackedEntityAttribute;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public ProgramTrackedEntityAttribute withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public Optional<UserRef__66> getUser() {
        return Optional.ofNullable(user);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public void setUser(UserRef__66 user) {
        this.user = user;
    }

    public ProgramTrackedEntityAttribute withUser(UserRef__66 user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<LegacyUserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<LegacyUserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public ProgramTrackedEntityAttribute withUserAccesses(List<LegacyUserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<LegacyUserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<LegacyUserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public ProgramTrackedEntityAttribute withUserGroupAccesses(List<LegacyUserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("valueType")
    public ProgramTrackedEntityAttribute.ValueTypeRef getValueType() {
        return valueType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("valueType")
    public void setValueType(ProgramTrackedEntityAttribute.ValueTypeRef valueType) {
        this.valueType = valueType;
    }

    public ProgramTrackedEntityAttribute withValueType(ProgramTrackedEntityAttribute.ValueTypeRef valueType) {
        this.valueType = valueType;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ProgramTrackedEntityAttribute withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("access".equals(name)) {
            if (value instanceof Access) {
                setAccess(((Access) value));
            } else {
                throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v40_2_2.Access\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("allowFutureDate".equals(name)) {
                if (value instanceof Boolean) {
                    setAllowFutureDate(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"allowFutureDate\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("attributeValues".equals(name)) {
                    if (value instanceof List) {
                        setAttributeValues(((List<AttributeValue> ) value));
                    } else {
                        throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.AttributeValue>\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("code".equals(name)) {
                        if (value instanceof String) {
                            setCode(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("created".equals(name)) {
                            if (value instanceof Date) {
                                setCreated(((Date) value));
                            } else {
                                throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("createdBy".equals(name)) {
                                if (value instanceof CreatedByRef__64) {
                                    setCreatedBy(((CreatedByRef__64) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v40_2_2.CreatedByRef__64\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("displayInList".equals(name)) {
                                    if (value instanceof Boolean) {
                                        setDisplayInList(((Boolean) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"displayInList\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("displayName".equals(name)) {
                                        if (value instanceof String) {
                                            setDisplayName(((String) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("displayShortName".equals(name)) {
                                            if (value instanceof String) {
                                                setDisplayShortName(((String) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"displayShortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("externalAccess".equals(name)) {
                                                if (value instanceof Boolean) {
                                                    setExternalAccess(((Boolean) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("favorite".equals(name)) {
                                                    if (value instanceof Boolean) {
                                                        setFavorite(((Boolean) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("favorites".equals(name)) {
                                                        if (value instanceof List) {
                                                            setFavorites(((List<String> ) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("href".equals(name)) {
                                                            if (value instanceof String) {
                                                                setHref(((String) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("id".equals(name)) {
                                                                if (value instanceof String) {
                                                                    setId(((String) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("lastUpdated".equals(name)) {
                                                                    if (value instanceof Date) {
                                                                        setLastUpdated(((Date) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("lastUpdatedBy".equals(name)) {
                                                                        if (value instanceof LastUpdatedByRef__64) {
                                                                            setLastUpdatedBy(((LastUpdatedByRef__64) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v40_2_2.LastUpdatedByRef__64\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("mandatory".equals(name)) {
                                                                            if (value instanceof Boolean) {
                                                                                setMandatory(((Boolean) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"mandatory\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("program".equals(name)) {
                                                                                if (value instanceof ProgramRef__4) {
                                                                                    setProgram(((ProgramRef__4) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"program\" is of type \"org.hisp.dhis.api.model.v40_2_2.ProgramRef__4\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("publicAccess".equals(name)) {
                                                                                    if (value instanceof String) {
                                                                                        setPublicAccess(((String) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("renderOptionsAsRadio".equals(name)) {
                                                                                        if (value instanceof Boolean) {
                                                                                            setRenderOptionsAsRadio(((Boolean) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"renderOptionsAsRadio\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("renderType".equals(name)) {
                                                                                            if (value instanceof Object) {
                                                                                                setRenderType(((Object) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"renderType\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("searchable".equals(name)) {
                                                                                                if (value instanceof Boolean) {
                                                                                                    setSearchable(((Boolean) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"searchable\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("sharing".equals(name)) {
                                                                                                    if (value instanceof Sharing) {
                                                                                                        setSharing(((Sharing) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v40_2_2.Sharing\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("sortOrder".equals(name)) {
                                                                                                        if (value instanceof Integer) {
                                                                                                            setSortOrder(((Integer) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"sortOrder\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("trackedEntityAttribute".equals(name)) {
                                                                                                            if (value instanceof TrackedEntityAttributeRef) {
                                                                                                                setTrackedEntityAttribute(((TrackedEntityAttributeRef) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"trackedEntityAttribute\" is of type \"org.hisp.dhis.api.model.v40_2_2.TrackedEntityAttributeRef\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("translations".equals(name)) {
                                                                                                                if (value instanceof List) {
                                                                                                                    setTranslations(((List<Translation> ) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.Translation>\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                if ("user".equals(name)) {
                                                                                                                    if (value instanceof UserRef__66) {
                                                                                                                        setUser(((UserRef__66) value));
                                                                                                                    } else {
                                                                                                                        throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v40_2_2.UserRef__66\", but got "+ value.getClass().toString()));
                                                                                                                    }
                                                                                                                    return true;
                                                                                                                } else {
                                                                                                                    if ("userAccesses".equals(name)) {
                                                                                                                        if (value instanceof List) {
                                                                                                                            setUserAccesses(((List<LegacyUserAccess> ) value));
                                                                                                                        } else {
                                                                                                                            throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.LegacyUserAccess>\", but got "+ value.getClass().toString()));
                                                                                                                        }
                                                                                                                        return true;
                                                                                                                    } else {
                                                                                                                        if ("userGroupAccesses".equals(name)) {
                                                                                                                            if (value instanceof List) {
                                                                                                                                setUserGroupAccesses(((List<LegacyUserGroupAccess> ) value));
                                                                                                                            } else {
                                                                                                                                throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.LegacyUserGroupAccess>\", but got "+ value.getClass().toString()));
                                                                                                                            }
                                                                                                                            return true;
                                                                                                                        } else {
                                                                                                                            if ("valueType".equals(name)) {
                                                                                                                                if (value instanceof ProgramTrackedEntityAttribute.ValueTypeRef) {
                                                                                                                                    setValueType(((ProgramTrackedEntityAttribute.ValueTypeRef) value));
                                                                                                                                } else {
                                                                                                                                    throw new IllegalArgumentException(("property \"valueType\" is of type \"org.hisp.dhis.api.model.v40_2_2.ProgramTrackedEntityAttribute.ValueTypeRef\", but got "+ value.getClass().toString()));
                                                                                                                                }
                                                                                                                                return true;
                                                                                                                            } else {
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("access".equals(name)) {
            return getAccess();
        } else {
            if ("allowFutureDate".equals(name)) {
                return getAllowFutureDate();
            } else {
                if ("attributeValues".equals(name)) {
                    return getAttributeValues();
                } else {
                    if ("code".equals(name)) {
                        return getCode();
                    } else {
                        if ("created".equals(name)) {
                            return getCreated();
                        } else {
                            if ("createdBy".equals(name)) {
                                return getCreatedBy();
                            } else {
                                if ("displayInList".equals(name)) {
                                    return getDisplayInList();
                                } else {
                                    if ("displayName".equals(name)) {
                                        return getDisplayName();
                                    } else {
                                        if ("displayShortName".equals(name)) {
                                            return getDisplayShortName();
                                        } else {
                                            if ("externalAccess".equals(name)) {
                                                return getExternalAccess();
                                            } else {
                                                if ("favorite".equals(name)) {
                                                    return getFavorite();
                                                } else {
                                                    if ("favorites".equals(name)) {
                                                        return getFavorites();
                                                    } else {
                                                        if ("href".equals(name)) {
                                                            return getHref();
                                                        } else {
                                                            if ("id".equals(name)) {
                                                                return getId();
                                                            } else {
                                                                if ("lastUpdated".equals(name)) {
                                                                    return getLastUpdated();
                                                                } else {
                                                                    if ("lastUpdatedBy".equals(name)) {
                                                                        return getLastUpdatedBy();
                                                                    } else {
                                                                        if ("mandatory".equals(name)) {
                                                                            return getMandatory();
                                                                        } else {
                                                                            if ("program".equals(name)) {
                                                                                return getProgram();
                                                                            } else {
                                                                                if ("publicAccess".equals(name)) {
                                                                                    return getPublicAccess();
                                                                                } else {
                                                                                    if ("renderOptionsAsRadio".equals(name)) {
                                                                                        return getRenderOptionsAsRadio();
                                                                                    } else {
                                                                                        if ("renderType".equals(name)) {
                                                                                            return getRenderType();
                                                                                        } else {
                                                                                            if ("searchable".equals(name)) {
                                                                                                return getSearchable();
                                                                                            } else {
                                                                                                if ("sharing".equals(name)) {
                                                                                                    return getSharing();
                                                                                                } else {
                                                                                                    if ("sortOrder".equals(name)) {
                                                                                                        return getSortOrder();
                                                                                                    } else {
                                                                                                        if ("trackedEntityAttribute".equals(name)) {
                                                                                                            return getTrackedEntityAttribute();
                                                                                                        } else {
                                                                                                            if ("translations".equals(name)) {
                                                                                                                return getTranslations();
                                                                                                            } else {
                                                                                                                if ("user".equals(name)) {
                                                                                                                    return getUser();
                                                                                                                } else {
                                                                                                                    if ("userAccesses".equals(name)) {
                                                                                                                        return getUserAccesses();
                                                                                                                    } else {
                                                                                                                        if ("userGroupAccesses".equals(name)) {
                                                                                                                            return getUserGroupAccesses();
                                                                                                                        } else {
                                                                                                                            if ("valueType".equals(name)) {
                                                                                                                                return getValueType();
                                                                                                                            } else {
                                                                                                                                return notFoundValue;
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ProgramTrackedEntityAttribute.NOT_FOUND_VALUE);
        if (ProgramTrackedEntityAttribute.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ProgramTrackedEntityAttribute with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ProgramTrackedEntityAttribute.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("allowFutureDate");
        sb.append('=');
        sb.append(((this.allowFutureDate == null)?"<null>":this.allowFutureDate));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("displayInList");
        sb.append('=');
        sb.append(((this.displayInList == null)?"<null>":this.displayInList));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("displayShortName");
        sb.append('=');
        sb.append(((this.displayShortName == null)?"<null>":this.displayShortName));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("mandatory");
        sb.append('=');
        sb.append(((this.mandatory == null)?"<null>":this.mandatory));
        sb.append(',');
        sb.append("program");
        sb.append('=');
        sb.append(((this.program == null)?"<null>":this.program));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("renderOptionsAsRadio");
        sb.append('=');
        sb.append(((this.renderOptionsAsRadio == null)?"<null>":this.renderOptionsAsRadio));
        sb.append(',');
        sb.append("renderType");
        sb.append('=');
        sb.append(((this.renderType == null)?"<null>":this.renderType));
        sb.append(',');
        sb.append("searchable");
        sb.append('=');
        sb.append(((this.searchable == null)?"<null>":this.searchable));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("sortOrder");
        sb.append('=');
        sb.append(((this.sortOrder == null)?"<null>":this.sortOrder));
        sb.append(',');
        sb.append("trackedEntityAttribute");
        sb.append('=');
        sb.append(((this.trackedEntityAttribute == null)?"<null>":this.trackedEntityAttribute));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("valueType");
        sb.append('=');
        sb.append(((this.valueType == null)?"<null>":this.valueType));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.program == null)? 0 :this.program.hashCode()));
        result = ((result* 31)+((this.mandatory == null)? 0 :this.mandatory.hashCode()));
        result = ((result* 31)+((this.displayShortName == null)? 0 :this.displayShortName.hashCode()));
        result = ((result* 31)+((this.trackedEntityAttribute == null)? 0 :this.trackedEntityAttribute.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.renderOptionsAsRadio == null)? 0 :this.renderOptionsAsRadio.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.valueType == null)? 0 :this.valueType.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.allowFutureDate == null)? 0 :this.allowFutureDate.hashCode()));
        result = ((result* 31)+((this.renderType == null)? 0 :this.renderType.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.searchable == null)? 0 :this.searchable.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.displayInList == null)? 0 :this.displayInList.hashCode()));
        result = ((result* 31)+((this.sortOrder == null)? 0 :this.sortOrder.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ProgramTrackedEntityAttribute) == false) {
            return false;
        }
        ProgramTrackedEntityAttribute rhs = ((ProgramTrackedEntityAttribute) other);
        return ((((((((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.program == rhs.program)||((this.program!= null)&&this.program.equals(rhs.program))))&&((this.mandatory == rhs.mandatory)||((this.mandatory!= null)&&this.mandatory.equals(rhs.mandatory))))&&((this.displayShortName == rhs.displayShortName)||((this.displayShortName!= null)&&this.displayShortName.equals(rhs.displayShortName))))&&((this.trackedEntityAttribute == rhs.trackedEntityAttribute)||((this.trackedEntityAttribute!= null)&&this.trackedEntityAttribute.equals(rhs.trackedEntityAttribute))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.renderOptionsAsRadio == rhs.renderOptionsAsRadio)||((this.renderOptionsAsRadio!= null)&&this.renderOptionsAsRadio.equals(rhs.renderOptionsAsRadio))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.valueType == rhs.valueType)||((this.valueType!= null)&&this.valueType.equals(rhs.valueType))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.allowFutureDate == rhs.allowFutureDate)||((this.allowFutureDate!= null)&&this.allowFutureDate.equals(rhs.allowFutureDate))))&&((this.renderType == rhs.renderType)||((this.renderType!= null)&&this.renderType.equals(rhs.renderType))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.searchable == rhs.searchable)||((this.searchable!= null)&&this.searchable.equals(rhs.searchable))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.displayInList == rhs.displayInList)||((this.displayInList!= null)&&this.displayInList.equals(rhs.displayInList))))&&((this.sortOrder == rhs.sortOrder)||((this.sortOrder!= null)&&this.sortOrder.equals(rhs.sortOrder))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

    @Generated("jsonschema2pojo")
    public enum ValueTypeRef {

        TEXT("TEXT"),
        LONG_TEXT("LONG_TEXT"),
        MULTI_TEXT("MULTI_TEXT"),
        LETTER("LETTER"),
        PHONE_NUMBER("PHONE_NUMBER"),
        EMAIL("EMAIL"),
        BOOLEAN("BOOLEAN"),
        TRUE_ONLY("TRUE_ONLY"),
        DATE("DATE"),
        DATETIME("DATETIME"),
        TIME("TIME"),
        NUMBER("NUMBER"),
        UNIT_INTERVAL("UNIT_INTERVAL"),
        PERCENTAGE("PERCENTAGE"),
        INTEGER("INTEGER"),
        INTEGER_POSITIVE("INTEGER_POSITIVE"),
        INTEGER_NEGATIVE("INTEGER_NEGATIVE"),
        INTEGER_ZERO_OR_POSITIVE("INTEGER_ZERO_OR_POSITIVE"),
        TRACKER_ASSOCIATE("TRACKER_ASSOCIATE"),
        USERNAME("USERNAME"),
        COORDINATE("COORDINATE"),
        ORGANISATION_UNIT("ORGANISATION_UNIT"),
        REFERENCE("REFERENCE"),
        AGE("AGE"),
        URL("URL"),
        FILE_RESOURCE("FILE_RESOURCE"),
        IMAGE("IMAGE"),
        GEOJSON("GEOJSON");
        private final String value;
        private final static Map<String, ProgramTrackedEntityAttribute.ValueTypeRef> CONSTANTS = new HashMap<String, ProgramTrackedEntityAttribute.ValueTypeRef>();

        static {
            for (ProgramTrackedEntityAttribute.ValueTypeRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ValueTypeRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ProgramTrackedEntityAttribute.ValueTypeRef fromValue(String value) {
            ProgramTrackedEntityAttribute.ValueTypeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
