
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "programInstance",
    "programStageInstance",
    "relationship",
    "trackedEntityInstance"
})
@Generated("jsonschema2pojo")
public class RelationshipItem implements Serializable
{

    /**
     * A UID reference to a ProgramInstance  
     * (Java name `org.hisp.dhis.program.ProgramInstance`)
     * 
     */
    @JsonProperty("programInstance")
    @JsonPropertyDescription("A UID reference to a ProgramInstance  \n(Java name `org.hisp.dhis.program.ProgramInstance`)")
    private ProgramInstanceRef__2 programInstance;
    /**
     * A UID reference to a ProgramStageInstance  
     * (Java name `org.hisp.dhis.program.ProgramStageInstance`)
     * 
     */
    @JsonProperty("programStageInstance")
    @JsonPropertyDescription("A UID reference to a ProgramStageInstance  \n(Java name `org.hisp.dhis.program.ProgramStageInstance`)")
    private ProgramStageInstanceRef__1 programStageInstance;
    /**
     * A UID reference to a Relationship  
     * (Java name `org.hisp.dhis.relationship.Relationship`)
     * 
     */
    @JsonProperty("relationship")
    @JsonPropertyDescription("A UID reference to a Relationship  \n(Java name `org.hisp.dhis.relationship.Relationship`)")
    private RelationshipRef relationship;
    /**
     * A UID reference to a TrackedEntityInstance  
     * (Java name `org.hisp.dhis.trackedentity.TrackedEntityInstance`)
     * 
     */
    @JsonProperty("trackedEntityInstance")
    @JsonPropertyDescription("A UID reference to a TrackedEntityInstance  \n(Java name `org.hisp.dhis.trackedentity.TrackedEntityInstance`)")
    private TrackedEntityInstanceRef__1 trackedEntityInstance;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 3204171152853813631L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public RelationshipItem() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public RelationshipItem(RelationshipItem source) {
        super();
        this.programInstance = source.programInstance;
        this.programStageInstance = source.programStageInstance;
        this.relationship = source.relationship;
        this.trackedEntityInstance = source.trackedEntityInstance;
    }

    /**
     * 
     * @param programInstance
     *     A UID reference to a ProgramInstance  
     *     (Java name `org.hisp.dhis.program.ProgramInstance`).
     * @param programStageInstance
     *     A UID reference to a ProgramStageInstance  
     *     (Java name `org.hisp.dhis.program.ProgramStageInstance`).
     * @param relationship
     *     A UID reference to a Relationship  
     *     (Java name `org.hisp.dhis.relationship.Relationship`).
     * @param trackedEntityInstance
     *     A UID reference to a TrackedEntityInstance  
     *     (Java name `org.hisp.dhis.trackedentity.TrackedEntityInstance`).
     */
    public RelationshipItem(ProgramInstanceRef__2 programInstance, ProgramStageInstanceRef__1 programStageInstance, RelationshipRef relationship, TrackedEntityInstanceRef__1 trackedEntityInstance) {
        super();
        this.programInstance = programInstance;
        this.programStageInstance = programStageInstance;
        this.relationship = relationship;
        this.trackedEntityInstance = trackedEntityInstance;
    }

    /**
     * A UID reference to a ProgramInstance  
     * (Java name `org.hisp.dhis.program.ProgramInstance`)
     * 
     */
    @JsonProperty("programInstance")
    public Optional<ProgramInstanceRef__2> getProgramInstance() {
        return Optional.ofNullable(programInstance);
    }

    /**
     * A UID reference to a ProgramInstance  
     * (Java name `org.hisp.dhis.program.ProgramInstance`)
     * 
     */
    @JsonProperty("programInstance")
    public void setProgramInstance(ProgramInstanceRef__2 programInstance) {
        this.programInstance = programInstance;
    }

    public RelationshipItem withProgramInstance(ProgramInstanceRef__2 programInstance) {
        this.programInstance = programInstance;
        return this;
    }

    /**
     * A UID reference to a ProgramStageInstance  
     * (Java name `org.hisp.dhis.program.ProgramStageInstance`)
     * 
     */
    @JsonProperty("programStageInstance")
    public Optional<ProgramStageInstanceRef__1> getProgramStageInstance() {
        return Optional.ofNullable(programStageInstance);
    }

    /**
     * A UID reference to a ProgramStageInstance  
     * (Java name `org.hisp.dhis.program.ProgramStageInstance`)
     * 
     */
    @JsonProperty("programStageInstance")
    public void setProgramStageInstance(ProgramStageInstanceRef__1 programStageInstance) {
        this.programStageInstance = programStageInstance;
    }

    public RelationshipItem withProgramStageInstance(ProgramStageInstanceRef__1 programStageInstance) {
        this.programStageInstance = programStageInstance;
        return this;
    }

    /**
     * A UID reference to a Relationship  
     * (Java name `org.hisp.dhis.relationship.Relationship`)
     * 
     */
    @JsonProperty("relationship")
    public Optional<RelationshipRef> getRelationship() {
        return Optional.ofNullable(relationship);
    }

    /**
     * A UID reference to a Relationship  
     * (Java name `org.hisp.dhis.relationship.Relationship`)
     * 
     */
    @JsonProperty("relationship")
    public void setRelationship(RelationshipRef relationship) {
        this.relationship = relationship;
    }

    public RelationshipItem withRelationship(RelationshipRef relationship) {
        this.relationship = relationship;
        return this;
    }

    /**
     * A UID reference to a TrackedEntityInstance  
     * (Java name `org.hisp.dhis.trackedentity.TrackedEntityInstance`)
     * 
     */
    @JsonProperty("trackedEntityInstance")
    public Optional<TrackedEntityInstanceRef__1> getTrackedEntityInstance() {
        return Optional.ofNullable(trackedEntityInstance);
    }

    /**
     * A UID reference to a TrackedEntityInstance  
     * (Java name `org.hisp.dhis.trackedentity.TrackedEntityInstance`)
     * 
     */
    @JsonProperty("trackedEntityInstance")
    public void setTrackedEntityInstance(TrackedEntityInstanceRef__1 trackedEntityInstance) {
        this.trackedEntityInstance = trackedEntityInstance;
    }

    public RelationshipItem withTrackedEntityInstance(TrackedEntityInstanceRef__1 trackedEntityInstance) {
        this.trackedEntityInstance = trackedEntityInstance;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public RelationshipItem withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("programInstance".equals(name)) {
            if (value instanceof ProgramInstanceRef__2) {
                setProgramInstance(((ProgramInstanceRef__2) value));
            } else {
                throw new IllegalArgumentException(("property \"programInstance\" is of type \"org.hisp.dhis.api.model.v40_2_2.ProgramInstanceRef__2\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("programStageInstance".equals(name)) {
                if (value instanceof ProgramStageInstanceRef__1) {
                    setProgramStageInstance(((ProgramStageInstanceRef__1) value));
                } else {
                    throw new IllegalArgumentException(("property \"programStageInstance\" is of type \"org.hisp.dhis.api.model.v40_2_2.ProgramStageInstanceRef__1\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("relationship".equals(name)) {
                    if (value instanceof RelationshipRef) {
                        setRelationship(((RelationshipRef) value));
                    } else {
                        throw new IllegalArgumentException(("property \"relationship\" is of type \"org.hisp.dhis.api.model.v40_2_2.RelationshipRef\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("trackedEntityInstance".equals(name)) {
                        if (value instanceof TrackedEntityInstanceRef__1) {
                            setTrackedEntityInstance(((TrackedEntityInstanceRef__1) value));
                        } else {
                            throw new IllegalArgumentException(("property \"trackedEntityInstance\" is of type \"org.hisp.dhis.api.model.v40_2_2.TrackedEntityInstanceRef__1\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("programInstance".equals(name)) {
            return getProgramInstance();
        } else {
            if ("programStageInstance".equals(name)) {
                return getProgramStageInstance();
            } else {
                if ("relationship".equals(name)) {
                    return getRelationship();
                } else {
                    if ("trackedEntityInstance".equals(name)) {
                        return getTrackedEntityInstance();
                    } else {
                        return notFoundValue;
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, RelationshipItem.NOT_FOUND_VALUE);
        if (RelationshipItem.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public RelationshipItem with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(RelationshipItem.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("programInstance");
        sb.append('=');
        sb.append(((this.programInstance == null)?"<null>":this.programInstance));
        sb.append(',');
        sb.append("programStageInstance");
        sb.append('=');
        sb.append(((this.programStageInstance == null)?"<null>":this.programStageInstance));
        sb.append(',');
        sb.append("relationship");
        sb.append('=');
        sb.append(((this.relationship == null)?"<null>":this.relationship));
        sb.append(',');
        sb.append("trackedEntityInstance");
        sb.append('=');
        sb.append(((this.trackedEntityInstance == null)?"<null>":this.trackedEntityInstance));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.programInstance == null)? 0 :this.programInstance.hashCode()));
        result = ((result* 31)+((this.programStageInstance == null)? 0 :this.programStageInstance.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.relationship == null)? 0 :this.relationship.hashCode()));
        result = ((result* 31)+((this.trackedEntityInstance == null)? 0 :this.trackedEntityInstance.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof RelationshipItem) == false) {
            return false;
        }
        RelationshipItem rhs = ((RelationshipItem) other);
        return ((((((this.programInstance == rhs.programInstance)||((this.programInstance!= null)&&this.programInstance.equals(rhs.programInstance)))&&((this.programStageInstance == rhs.programStageInstance)||((this.programStageInstance!= null)&&this.programStageInstance.equals(rhs.programStageInstance))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.relationship == rhs.relationship)||((this.relationship!= null)&&this.relationship.equals(rhs.relationship))))&&((this.trackedEntityInstance == rhs.trackedEntityInstance)||((this.trackedEntityInstance!= null)&&this.trackedEntityInstance.equals(rhs.trackedEntityInstance))));
    }

}
