
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "bindType",
    "compressed",
    "host",
    "id",
    "isDefault",
    "maxSmsLength",
    "name",
    "numberPlanIndicator",
    "password",
    "port",
    "sendUrlParameters",
    "systemId",
    "systemType",
    "typeOfNumber",
    "uid",
    "urlTemplate",
    "username"
})
@Generated("jsonschema2pojo")
public class SMPPGatewayConfig implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("bindType")
    private SMPPGatewayConfig.BindTypeRef bindType;
    @JsonProperty("compressed")
    private Boolean compressed;
    @JsonProperty("host")
    private String host;
    @JsonProperty("id")
    private String id;
    @JsonProperty("isDefault")
    private Boolean isDefault;
    @JsonProperty("maxSmsLength")
    private String maxSmsLength;
    @JsonProperty("name")
    private String name;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("numberPlanIndicator")
    private SMPPGatewayConfig.NumberPlanIndicatorRef numberPlanIndicator;
    @JsonProperty("password")
    private String password;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("port")
    private Integer port;
    @JsonProperty("sendUrlParameters")
    private Boolean sendUrlParameters;
    @JsonProperty("systemId")
    private String systemId;
    @JsonProperty("systemType")
    private String systemType;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("typeOfNumber")
    private SMPPGatewayConfig.TypeOfNumberRef typeOfNumber;
    @JsonProperty("uid")
    private String uid;
    @JsonProperty("urlTemplate")
    private String urlTemplate;
    @JsonProperty("username")
    private String username;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -1232818774977304975L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public SMPPGatewayConfig() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public SMPPGatewayConfig(SMPPGatewayConfig source) {
        super();
        this.bindType = source.bindType;
        this.compressed = source.compressed;
        this.host = source.host;
        this.id = source.id;
        this.isDefault = source.isDefault;
        this.maxSmsLength = source.maxSmsLength;
        this.name = source.name;
        this.numberPlanIndicator = source.numberPlanIndicator;
        this.password = source.password;
        this.port = source.port;
        this.sendUrlParameters = source.sendUrlParameters;
        this.systemId = source.systemId;
        this.systemType = source.systemType;
        this.typeOfNumber = source.typeOfNumber;
        this.uid = source.uid;
        this.urlTemplate = source.urlTemplate;
        this.username = source.username;
    }

    public SMPPGatewayConfig(SMPPGatewayConfig.BindTypeRef bindType, Boolean compressed, String host, String id, Boolean isDefault, String maxSmsLength, String name, SMPPGatewayConfig.NumberPlanIndicatorRef numberPlanIndicator, String password, Integer port, Boolean sendUrlParameters, String systemId, String systemType, SMPPGatewayConfig.TypeOfNumberRef typeOfNumber, String uid, String urlTemplate, String username) {
        super();
        this.bindType = bindType;
        this.compressed = compressed;
        this.host = host;
        this.id = id;
        this.isDefault = isDefault;
        this.maxSmsLength = maxSmsLength;
        this.name = name;
        this.numberPlanIndicator = numberPlanIndicator;
        this.password = password;
        this.port = port;
        this.sendUrlParameters = sendUrlParameters;
        this.systemId = systemId;
        this.systemType = systemType;
        this.typeOfNumber = typeOfNumber;
        this.uid = uid;
        this.urlTemplate = urlTemplate;
        this.username = username;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("bindType")
    public SMPPGatewayConfig.BindTypeRef getBindType() {
        return bindType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("bindType")
    public void setBindType(SMPPGatewayConfig.BindTypeRef bindType) {
        this.bindType = bindType;
    }

    public SMPPGatewayConfig withBindType(SMPPGatewayConfig.BindTypeRef bindType) {
        this.bindType = bindType;
        return this;
    }

    @JsonProperty("compressed")
    public Optional<Boolean> getCompressed() {
        return Optional.ofNullable(compressed);
    }

    @JsonProperty("compressed")
    public void setCompressed(Boolean compressed) {
        this.compressed = compressed;
    }

    public SMPPGatewayConfig withCompressed(Boolean compressed) {
        this.compressed = compressed;
        return this;
    }

    @JsonProperty("host")
    public Optional<String> getHost() {
        return Optional.ofNullable(host);
    }

    @JsonProperty("host")
    public void setHost(String host) {
        this.host = host;
    }

    public SMPPGatewayConfig withHost(String host) {
        this.host = host;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public SMPPGatewayConfig withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("isDefault")
    public Optional<Boolean> getIsDefault() {
        return Optional.ofNullable(isDefault);
    }

    @JsonProperty("isDefault")
    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public SMPPGatewayConfig withIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    @JsonProperty("maxSmsLength")
    public Optional<String> getMaxSmsLength() {
        return Optional.ofNullable(maxSmsLength);
    }

    @JsonProperty("maxSmsLength")
    public void setMaxSmsLength(String maxSmsLength) {
        this.maxSmsLength = maxSmsLength;
    }

    public SMPPGatewayConfig withMaxSmsLength(String maxSmsLength) {
        this.maxSmsLength = maxSmsLength;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public SMPPGatewayConfig withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("numberPlanIndicator")
    public SMPPGatewayConfig.NumberPlanIndicatorRef getNumberPlanIndicator() {
        return numberPlanIndicator;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("numberPlanIndicator")
    public void setNumberPlanIndicator(SMPPGatewayConfig.NumberPlanIndicatorRef numberPlanIndicator) {
        this.numberPlanIndicator = numberPlanIndicator;
    }

    public SMPPGatewayConfig withNumberPlanIndicator(SMPPGatewayConfig.NumberPlanIndicatorRef numberPlanIndicator) {
        this.numberPlanIndicator = numberPlanIndicator;
        return this;
    }

    @JsonProperty("password")
    public Optional<String> getPassword() {
        return Optional.ofNullable(password);
    }

    @JsonProperty("password")
    public void setPassword(String password) {
        this.password = password;
    }

    public SMPPGatewayConfig withPassword(String password) {
        this.password = password;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("port")
    public Integer getPort() {
        return port;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("port")
    public void setPort(Integer port) {
        this.port = port;
    }

    public SMPPGatewayConfig withPort(Integer port) {
        this.port = port;
        return this;
    }

    @JsonProperty("sendUrlParameters")
    public Optional<Boolean> getSendUrlParameters() {
        return Optional.ofNullable(sendUrlParameters);
    }

    @JsonProperty("sendUrlParameters")
    public void setSendUrlParameters(Boolean sendUrlParameters) {
        this.sendUrlParameters = sendUrlParameters;
    }

    public SMPPGatewayConfig withSendUrlParameters(Boolean sendUrlParameters) {
        this.sendUrlParameters = sendUrlParameters;
        return this;
    }

    @JsonProperty("systemId")
    public Optional<String> getSystemId() {
        return Optional.ofNullable(systemId);
    }

    @JsonProperty("systemId")
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public SMPPGatewayConfig withSystemId(String systemId) {
        this.systemId = systemId;
        return this;
    }

    @JsonProperty("systemType")
    public Optional<String> getSystemType() {
        return Optional.ofNullable(systemType);
    }

    @JsonProperty("systemType")
    public void setSystemType(String systemType) {
        this.systemType = systemType;
    }

    public SMPPGatewayConfig withSystemType(String systemType) {
        this.systemType = systemType;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("typeOfNumber")
    public SMPPGatewayConfig.TypeOfNumberRef getTypeOfNumber() {
        return typeOfNumber;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("typeOfNumber")
    public void setTypeOfNumber(SMPPGatewayConfig.TypeOfNumberRef typeOfNumber) {
        this.typeOfNumber = typeOfNumber;
    }

    public SMPPGatewayConfig withTypeOfNumber(SMPPGatewayConfig.TypeOfNumberRef typeOfNumber) {
        this.typeOfNumber = typeOfNumber;
        return this;
    }

    @JsonProperty("uid")
    public Optional<String> getUid() {
        return Optional.ofNullable(uid);
    }

    @JsonProperty("uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    public SMPPGatewayConfig withUid(String uid) {
        this.uid = uid;
        return this;
    }

    @JsonProperty("urlTemplate")
    public Optional<String> getUrlTemplate() {
        return Optional.ofNullable(urlTemplate);
    }

    @JsonProperty("urlTemplate")
    public void setUrlTemplate(String urlTemplate) {
        this.urlTemplate = urlTemplate;
    }

    public SMPPGatewayConfig withUrlTemplate(String urlTemplate) {
        this.urlTemplate = urlTemplate;
        return this;
    }

    @JsonProperty("username")
    public Optional<String> getUsername() {
        return Optional.ofNullable(username);
    }

    @JsonProperty("username")
    public void setUsername(String username) {
        this.username = username;
    }

    public SMPPGatewayConfig withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public SMPPGatewayConfig withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("bindType".equals(name)) {
            if (value instanceof SMPPGatewayConfig.BindTypeRef) {
                setBindType(((SMPPGatewayConfig.BindTypeRef) value));
            } else {
                throw new IllegalArgumentException(("property \"bindType\" is of type \"org.hisp.dhis.api.model.v40_2_2.SMPPGatewayConfig.BindTypeRef\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("compressed".equals(name)) {
                if (value instanceof Boolean) {
                    setCompressed(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"compressed\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("host".equals(name)) {
                    if (value instanceof String) {
                        setHost(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"host\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("id".equals(name)) {
                        if (value instanceof String) {
                            setId(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("isDefault".equals(name)) {
                            if (value instanceof Boolean) {
                                setIsDefault(((Boolean) value));
                            } else {
                                throw new IllegalArgumentException(("property \"isDefault\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("maxSmsLength".equals(name)) {
                                if (value instanceof String) {
                                    setMaxSmsLength(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"maxSmsLength\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("name".equals(name)) {
                                    if (value instanceof String) {
                                        setName(((String) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("numberPlanIndicator".equals(name)) {
                                        if (value instanceof SMPPGatewayConfig.NumberPlanIndicatorRef) {
                                            setNumberPlanIndicator(((SMPPGatewayConfig.NumberPlanIndicatorRef) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"numberPlanIndicator\" is of type \"org.hisp.dhis.api.model.v40_2_2.SMPPGatewayConfig.NumberPlanIndicatorRef\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("password".equals(name)) {
                                            if (value instanceof String) {
                                                setPassword(((String) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"password\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("port".equals(name)) {
                                                if (value instanceof Integer) {
                                                    setPort(((Integer) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"port\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("sendUrlParameters".equals(name)) {
                                                    if (value instanceof Boolean) {
                                                        setSendUrlParameters(((Boolean) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"sendUrlParameters\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("systemId".equals(name)) {
                                                        if (value instanceof String) {
                                                            setSystemId(((String) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"systemId\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("systemType".equals(name)) {
                                                            if (value instanceof String) {
                                                                setSystemType(((String) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"systemType\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("typeOfNumber".equals(name)) {
                                                                if (value instanceof SMPPGatewayConfig.TypeOfNumberRef) {
                                                                    setTypeOfNumber(((SMPPGatewayConfig.TypeOfNumberRef) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"typeOfNumber\" is of type \"org.hisp.dhis.api.model.v40_2_2.SMPPGatewayConfig.TypeOfNumberRef\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("uid".equals(name)) {
                                                                    if (value instanceof String) {
                                                                        setUid(((String) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"uid\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("urlTemplate".equals(name)) {
                                                                        if (value instanceof String) {
                                                                            setUrlTemplate(((String) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"urlTemplate\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("username".equals(name)) {
                                                                            if (value instanceof String) {
                                                                                setUsername(((String) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"username\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            return false;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("bindType".equals(name)) {
            return getBindType();
        } else {
            if ("compressed".equals(name)) {
                return getCompressed();
            } else {
                if ("host".equals(name)) {
                    return getHost();
                } else {
                    if ("id".equals(name)) {
                        return getId();
                    } else {
                        if ("isDefault".equals(name)) {
                            return getIsDefault();
                        } else {
                            if ("maxSmsLength".equals(name)) {
                                return getMaxSmsLength();
                            } else {
                                if ("name".equals(name)) {
                                    return getName();
                                } else {
                                    if ("numberPlanIndicator".equals(name)) {
                                        return getNumberPlanIndicator();
                                    } else {
                                        if ("password".equals(name)) {
                                            return getPassword();
                                        } else {
                                            if ("port".equals(name)) {
                                                return getPort();
                                            } else {
                                                if ("sendUrlParameters".equals(name)) {
                                                    return getSendUrlParameters();
                                                } else {
                                                    if ("systemId".equals(name)) {
                                                        return getSystemId();
                                                    } else {
                                                        if ("systemType".equals(name)) {
                                                            return getSystemType();
                                                        } else {
                                                            if ("typeOfNumber".equals(name)) {
                                                                return getTypeOfNumber();
                                                            } else {
                                                                if ("uid".equals(name)) {
                                                                    return getUid();
                                                                } else {
                                                                    if ("urlTemplate".equals(name)) {
                                                                        return getUrlTemplate();
                                                                    } else {
                                                                        if ("username".equals(name)) {
                                                                            return getUsername();
                                                                        } else {
                                                                            return notFoundValue;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, SMPPGatewayConfig.NOT_FOUND_VALUE);
        if (SMPPGatewayConfig.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public SMPPGatewayConfig with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SMPPGatewayConfig.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("bindType");
        sb.append('=');
        sb.append(((this.bindType == null)?"<null>":this.bindType));
        sb.append(',');
        sb.append("compressed");
        sb.append('=');
        sb.append(((this.compressed == null)?"<null>":this.compressed));
        sb.append(',');
        sb.append("host");
        sb.append('=');
        sb.append(((this.host == null)?"<null>":this.host));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("isDefault");
        sb.append('=');
        sb.append(((this.isDefault == null)?"<null>":this.isDefault));
        sb.append(',');
        sb.append("maxSmsLength");
        sb.append('=');
        sb.append(((this.maxSmsLength == null)?"<null>":this.maxSmsLength));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("numberPlanIndicator");
        sb.append('=');
        sb.append(((this.numberPlanIndicator == null)?"<null>":this.numberPlanIndicator));
        sb.append(',');
        sb.append("password");
        sb.append('=');
        sb.append(((this.password == null)?"<null>":this.password));
        sb.append(',');
        sb.append("port");
        sb.append('=');
        sb.append(((this.port == null)?"<null>":this.port));
        sb.append(',');
        sb.append("sendUrlParameters");
        sb.append('=');
        sb.append(((this.sendUrlParameters == null)?"<null>":this.sendUrlParameters));
        sb.append(',');
        sb.append("systemId");
        sb.append('=');
        sb.append(((this.systemId == null)?"<null>":this.systemId));
        sb.append(',');
        sb.append("systemType");
        sb.append('=');
        sb.append(((this.systemType == null)?"<null>":this.systemType));
        sb.append(',');
        sb.append("typeOfNumber");
        sb.append('=');
        sb.append(((this.typeOfNumber == null)?"<null>":this.typeOfNumber));
        sb.append(',');
        sb.append("uid");
        sb.append('=');
        sb.append(((this.uid == null)?"<null>":this.uid));
        sb.append(',');
        sb.append("urlTemplate");
        sb.append('=');
        sb.append(((this.urlTemplate == null)?"<null>":this.urlTemplate));
        sb.append(',');
        sb.append("username");
        sb.append('=');
        sb.append(((this.username == null)?"<null>":this.username));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.numberPlanIndicator == null)? 0 :this.numberPlanIndicator.hashCode()));
        result = ((result* 31)+((this.systemId == null)? 0 :this.systemId.hashCode()));
        result = ((result* 31)+((this.urlTemplate == null)? 0 :this.urlTemplate.hashCode()));
        result = ((result* 31)+((this.bindType == null)? 0 :this.bindType.hashCode()));
        result = ((result* 31)+((this.uid == null)? 0 :this.uid.hashCode()));
        result = ((result* 31)+((this.isDefault == null)? 0 :this.isDefault.hashCode()));
        result = ((result* 31)+((this.password == null)? 0 :this.password.hashCode()));
        result = ((result* 31)+((this.maxSmsLength == null)? 0 :this.maxSmsLength.hashCode()));
        result = ((result* 31)+((this.typeOfNumber == null)? 0 :this.typeOfNumber.hashCode()));
        result = ((result* 31)+((this.port == null)? 0 :this.port.hashCode()));
        result = ((result* 31)+((this.sendUrlParameters == null)? 0 :this.sendUrlParameters.hashCode()));
        result = ((result* 31)+((this.host == null)? 0 :this.host.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.systemType == null)? 0 :this.systemType.hashCode()));
        result = ((result* 31)+((this.compressed == null)? 0 :this.compressed.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.username == null)? 0 :this.username.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof SMPPGatewayConfig) == false) {
            return false;
        }
        SMPPGatewayConfig rhs = ((SMPPGatewayConfig) other);
        return (((((((((((((((((((this.numberPlanIndicator == rhs.numberPlanIndicator)||((this.numberPlanIndicator!= null)&&this.numberPlanIndicator.equals(rhs.numberPlanIndicator)))&&((this.systemId == rhs.systemId)||((this.systemId!= null)&&this.systemId.equals(rhs.systemId))))&&((this.urlTemplate == rhs.urlTemplate)||((this.urlTemplate!= null)&&this.urlTemplate.equals(rhs.urlTemplate))))&&((this.bindType == rhs.bindType)||((this.bindType!= null)&&this.bindType.equals(rhs.bindType))))&&((this.uid == rhs.uid)||((this.uid!= null)&&this.uid.equals(rhs.uid))))&&((this.isDefault == rhs.isDefault)||((this.isDefault!= null)&&this.isDefault.equals(rhs.isDefault))))&&((this.password == rhs.password)||((this.password!= null)&&this.password.equals(rhs.password))))&&((this.maxSmsLength == rhs.maxSmsLength)||((this.maxSmsLength!= null)&&this.maxSmsLength.equals(rhs.maxSmsLength))))&&((this.typeOfNumber == rhs.typeOfNumber)||((this.typeOfNumber!= null)&&this.typeOfNumber.equals(rhs.typeOfNumber))))&&((this.port == rhs.port)||((this.port!= null)&&this.port.equals(rhs.port))))&&((this.sendUrlParameters == rhs.sendUrlParameters)||((this.sendUrlParameters!= null)&&this.sendUrlParameters.equals(rhs.sendUrlParameters))))&&((this.host == rhs.host)||((this.host!= null)&&this.host.equals(rhs.host))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.systemType == rhs.systemType)||((this.systemType!= null)&&this.systemType.equals(rhs.systemType))))&&((this.compressed == rhs.compressed)||((this.compressed!= null)&&this.compressed.equals(rhs.compressed))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.username == rhs.username)||((this.username!= null)&&this.username.equals(rhs.username))));
    }

    @Generated("jsonschema2pojo")
    public enum BindTypeRef {

        BIND_TX("BIND_TX"),
        BIND_RX("BIND_RX"),
        BIND_TRX("BIND_TRX");
        private final String value;
        private final static Map<String, SMPPGatewayConfig.BindTypeRef> CONSTANTS = new HashMap<String, SMPPGatewayConfig.BindTypeRef>();

        static {
            for (SMPPGatewayConfig.BindTypeRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        BindTypeRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static SMPPGatewayConfig.BindTypeRef fromValue(String value) {
            SMPPGatewayConfig.BindTypeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum NumberPlanIndicatorRef {

        UNKNOWN("UNKNOWN"),
        ISDN("ISDN"),
        DATA("DATA"),
        TELEX("TELEX"),
        LAND_MOBILE("LAND_MOBILE"),
        NATIONAL("NATIONAL"),
        PRIVATE("PRIVATE"),
        ERMES("ERMES"),
        INTERNET("INTERNET"),
        WAP("WAP");
        private final String value;
        private final static Map<String, SMPPGatewayConfig.NumberPlanIndicatorRef> CONSTANTS = new HashMap<String, SMPPGatewayConfig.NumberPlanIndicatorRef>();

        static {
            for (SMPPGatewayConfig.NumberPlanIndicatorRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        NumberPlanIndicatorRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static SMPPGatewayConfig.NumberPlanIndicatorRef fromValue(String value) {
            SMPPGatewayConfig.NumberPlanIndicatorRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum TypeOfNumberRef {

        UNKNOWN("UNKNOWN"),
        INTERNATIONAL("INTERNATIONAL"),
        NATIONAL("NATIONAL"),
        NETWORK_SPECIFIC("NETWORK_SPECIFIC"),
        SUBSCRIBER_NUMBER("SUBSCRIBER_NUMBER"),
        ALPHANUMERIC("ALPHANUMERIC"),
        ABBREVIATED("ABBREVIATED");
        private final String value;
        private final static Map<String, SMPPGatewayConfig.TypeOfNumberRef> CONSTANTS = new HashMap<String, SMPPGatewayConfig.TypeOfNumberRef>();

        static {
            for (SMPPGatewayConfig.TypeOfNumberRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        TypeOfNumberRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static SMPPGatewayConfig.TypeOfNumberRef fromValue(String value) {
            SMPPGatewayConfig.TypeOfNumberRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
