
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "periodTypes"
})
@Generated("jsonschema2pojo")
public class SourceParams implements Serializable
{

    @JsonProperty("periodTypes")
    private List<PeriodTypesRefRef> periodTypes;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 807249317116683719L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public SourceParams() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public SourceParams(SourceParams source) {
        super();
        this.periodTypes = source.periodTypes;
    }

    public SourceParams(List<PeriodTypesRefRef> periodTypes) {
        super();
        this.periodTypes = periodTypes;
    }

    @JsonProperty("periodTypes")
    public Optional<List<PeriodTypesRefRef>> getPeriodTypes() {
        return Optional.ofNullable(periodTypes);
    }

    @JsonProperty("periodTypes")
    public void setPeriodTypes(List<PeriodTypesRefRef> periodTypes) {
        this.periodTypes = periodTypes;
    }

    public SourceParams withPeriodTypes(List<PeriodTypesRefRef> periodTypes) {
        this.periodTypes = periodTypes;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public SourceParams withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("periodTypes".equals(name)) {
            if (value instanceof List) {
                setPeriodTypes(((List<PeriodTypesRefRef> ) value));
            } else {
                throw new IllegalArgumentException(("property \"periodTypes\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.PeriodTypesRefRef>\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("periodTypes".equals(name)) {
            return getPeriodTypes();
        } else {
            return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, SourceParams.NOT_FOUND_VALUE);
        if (SourceParams.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public SourceParams with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SourceParams.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("periodTypes");
        sb.append('=');
        sb.append(((this.periodTypes == null)?"<null>":this.periodTypes));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.periodTypes == null)? 0 :this.periodTypes.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof SourceParams) == false) {
            return false;
        }
        SourceParams rhs = ((SourceParams) other);
        return (((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties)))&&((this.periodTypes == rhs.periodTypes)||((this.periodTypes!= null)&&this.periodTypes.equals(rhs.periodTypes))));
    }

}
