
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "fontStyle",
    "text",
    "textMode"
})
@Generated("jsonschema2pojo")
public class StyledObject implements Serializable
{

    @JsonProperty("fontStyle")
    private FontStyle fontStyle;
    @JsonProperty("text")
    private String text;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("textMode")
    private StyledObject.TextModeRef textMode;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 1919664267789181708L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public StyledObject() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public StyledObject(StyledObject source) {
        super();
        this.fontStyle = source.fontStyle;
        this.text = source.text;
        this.textMode = source.textMode;
    }

    public StyledObject(FontStyle fontStyle, String text, StyledObject.TextModeRef textMode) {
        super();
        this.fontStyle = fontStyle;
        this.text = text;
        this.textMode = textMode;
    }

    @JsonProperty("fontStyle")
    public Optional<FontStyle> getFontStyle() {
        return Optional.ofNullable(fontStyle);
    }

    @JsonProperty("fontStyle")
    public void setFontStyle(FontStyle fontStyle) {
        this.fontStyle = fontStyle;
    }

    public StyledObject withFontStyle(FontStyle fontStyle) {
        this.fontStyle = fontStyle;
        return this;
    }

    @JsonProperty("text")
    public Optional<String> getText() {
        return Optional.ofNullable(text);
    }

    @JsonProperty("text")
    public void setText(String text) {
        this.text = text;
    }

    public StyledObject withText(String text) {
        this.text = text;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("textMode")
    public StyledObject.TextModeRef getTextMode() {
        return textMode;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("textMode")
    public void setTextMode(StyledObject.TextModeRef textMode) {
        this.textMode = textMode;
    }

    public StyledObject withTextMode(StyledObject.TextModeRef textMode) {
        this.textMode = textMode;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public StyledObject withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("fontStyle".equals(name)) {
            if (value instanceof FontStyle) {
                setFontStyle(((FontStyle) value));
            } else {
                throw new IllegalArgumentException(("property \"fontStyle\" is of type \"org.hisp.dhis.api.model.v40_2_2.FontStyle\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("text".equals(name)) {
                if (value instanceof String) {
                    setText(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"text\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("textMode".equals(name)) {
                    if (value instanceof StyledObject.TextModeRef) {
                        setTextMode(((StyledObject.TextModeRef) value));
                    } else {
                        throw new IllegalArgumentException(("property \"textMode\" is of type \"org.hisp.dhis.api.model.v40_2_2.StyledObject.TextModeRef\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    return false;
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("fontStyle".equals(name)) {
            return getFontStyle();
        } else {
            if ("text".equals(name)) {
                return getText();
            } else {
                if ("textMode".equals(name)) {
                    return getTextMode();
                } else {
                    return notFoundValue;
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, StyledObject.NOT_FOUND_VALUE);
        if (StyledObject.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public StyledObject with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(StyledObject.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("fontStyle");
        sb.append('=');
        sb.append(((this.fontStyle == null)?"<null>":this.fontStyle));
        sb.append(',');
        sb.append("text");
        sb.append('=');
        sb.append(((this.text == null)?"<null>":this.text));
        sb.append(',');
        sb.append("textMode");
        sb.append('=');
        sb.append(((this.textMode == null)?"<null>":this.textMode));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.textMode == null)? 0 :this.textMode.hashCode()));
        result = ((result* 31)+((this.text == null)? 0 :this.text.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.fontStyle == null)? 0 :this.fontStyle.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof StyledObject) == false) {
            return false;
        }
        StyledObject rhs = ((StyledObject) other);
        return (((((this.textMode == rhs.textMode)||((this.textMode!= null)&&this.textMode.equals(rhs.textMode)))&&((this.text == rhs.text)||((this.text!= null)&&this.text.equals(rhs.text))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.fontStyle == rhs.fontStyle)||((this.fontStyle!= null)&&this.fontStyle.equals(rhs.fontStyle))));
    }

    @Generated("jsonschema2pojo")
    public enum TextModeRef {

        AUTO("AUTO"),
        CUSTOM("CUSTOM");
        private final String value;
        private final static Map<String, StyledObject.TextModeRef> CONSTANTS = new HashMap<String, StyledObject.TextModeRef>();

        static {
            for (StyledObject.TextModeRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        TextModeRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static StyledObject.TextModeRef fromValue(String value) {
            StyledObject.TextModeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
