
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "organisationUnit",
    "program",
    "trackedEntityInstance"
})
@Generated("jsonschema2pojo")
public class TrackedEntityProgramOwner implements Serializable
{

    /**
     * A UID reference to a OrganisationUnit  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)
     * 
     */
    @JsonProperty("organisationUnit")
    @JsonPropertyDescription("A UID reference to a OrganisationUnit  \n(Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)")
    private OrganisationUnitRef__4 organisationUnit;
    /**
     * A UID reference to a Program  
     * (Java name `org.hisp.dhis.program.Program`)
     * 
     */
    @JsonProperty("program")
    @JsonPropertyDescription("A UID reference to a Program  \n(Java name `org.hisp.dhis.program.Program`)")
    private ProgramRef__13 program;
    /**
     * A UID reference to a TrackedEntityInstance  
     * (Java name `org.hisp.dhis.trackedentity.TrackedEntityInstance`)
     * 
     */
    @JsonProperty("trackedEntityInstance")
    @JsonPropertyDescription("A UID reference to a TrackedEntityInstance  \n(Java name `org.hisp.dhis.trackedentity.TrackedEntityInstance`)")
    private TrackedEntityInstanceRef__3 trackedEntityInstance;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -278286959874659436L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrackedEntityProgramOwner() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public TrackedEntityProgramOwner(TrackedEntityProgramOwner source) {
        super();
        this.organisationUnit = source.organisationUnit;
        this.program = source.program;
        this.trackedEntityInstance = source.trackedEntityInstance;
    }

    /**
     * 
     * @param organisationUnit
     *     A UID reference to a OrganisationUnit  
     *     (Java name `org.hisp.dhis.organisationunit.OrganisationUnit`).
     * @param program
     *     A UID reference to a Program  
     *     (Java name `org.hisp.dhis.program.Program`).
     * @param trackedEntityInstance
     *     A UID reference to a TrackedEntityInstance  
     *     (Java name `org.hisp.dhis.trackedentity.TrackedEntityInstance`).
     */
    public TrackedEntityProgramOwner(OrganisationUnitRef__4 organisationUnit, ProgramRef__13 program, TrackedEntityInstanceRef__3 trackedEntityInstance) {
        super();
        this.organisationUnit = organisationUnit;
        this.program = program;
        this.trackedEntityInstance = trackedEntityInstance;
    }

    /**
     * A UID reference to a OrganisationUnit  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)
     * 
     */
    @JsonProperty("organisationUnit")
    public Optional<OrganisationUnitRef__4> getOrganisationUnit() {
        return Optional.ofNullable(organisationUnit);
    }

    /**
     * A UID reference to a OrganisationUnit  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)
     * 
     */
    @JsonProperty("organisationUnit")
    public void setOrganisationUnit(OrganisationUnitRef__4 organisationUnit) {
        this.organisationUnit = organisationUnit;
    }

    public TrackedEntityProgramOwner withOrganisationUnit(OrganisationUnitRef__4 organisationUnit) {
        this.organisationUnit = organisationUnit;
        return this;
    }

    /**
     * A UID reference to a Program  
     * (Java name `org.hisp.dhis.program.Program`)
     * 
     */
    @JsonProperty("program")
    public Optional<ProgramRef__13> getProgram() {
        return Optional.ofNullable(program);
    }

    /**
     * A UID reference to a Program  
     * (Java name `org.hisp.dhis.program.Program`)
     * 
     */
    @JsonProperty("program")
    public void setProgram(ProgramRef__13 program) {
        this.program = program;
    }

    public TrackedEntityProgramOwner withProgram(ProgramRef__13 program) {
        this.program = program;
        return this;
    }

    /**
     * A UID reference to a TrackedEntityInstance  
     * (Java name `org.hisp.dhis.trackedentity.TrackedEntityInstance`)
     * 
     */
    @JsonProperty("trackedEntityInstance")
    public Optional<TrackedEntityInstanceRef__3> getTrackedEntityInstance() {
        return Optional.ofNullable(trackedEntityInstance);
    }

    /**
     * A UID reference to a TrackedEntityInstance  
     * (Java name `org.hisp.dhis.trackedentity.TrackedEntityInstance`)
     * 
     */
    @JsonProperty("trackedEntityInstance")
    public void setTrackedEntityInstance(TrackedEntityInstanceRef__3 trackedEntityInstance) {
        this.trackedEntityInstance = trackedEntityInstance;
    }

    public TrackedEntityProgramOwner withTrackedEntityInstance(TrackedEntityInstanceRef__3 trackedEntityInstance) {
        this.trackedEntityInstance = trackedEntityInstance;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackedEntityProgramOwner withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("organisationUnit".equals(name)) {
            if (value instanceof OrganisationUnitRef__4) {
                setOrganisationUnit(((OrganisationUnitRef__4) value));
            } else {
                throw new IllegalArgumentException(("property \"organisationUnit\" is of type \"org.hisp.dhis.api.model.v40_2_2.OrganisationUnitRef__4\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("program".equals(name)) {
                if (value instanceof ProgramRef__13) {
                    setProgram(((ProgramRef__13) value));
                } else {
                    throw new IllegalArgumentException(("property \"program\" is of type \"org.hisp.dhis.api.model.v40_2_2.ProgramRef__13\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("trackedEntityInstance".equals(name)) {
                    if (value instanceof TrackedEntityInstanceRef__3) {
                        setTrackedEntityInstance(((TrackedEntityInstanceRef__3) value));
                    } else {
                        throw new IllegalArgumentException(("property \"trackedEntityInstance\" is of type \"org.hisp.dhis.api.model.v40_2_2.TrackedEntityInstanceRef__3\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    return false;
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("organisationUnit".equals(name)) {
            return getOrganisationUnit();
        } else {
            if ("program".equals(name)) {
                return getProgram();
            } else {
                if ("trackedEntityInstance".equals(name)) {
                    return getTrackedEntityInstance();
                } else {
                    return notFoundValue;
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TrackedEntityProgramOwner.NOT_FOUND_VALUE);
        if (TrackedEntityProgramOwner.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TrackedEntityProgramOwner with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackedEntityProgramOwner.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("organisationUnit");
        sb.append('=');
        sb.append(((this.organisationUnit == null)?"<null>":this.organisationUnit));
        sb.append(',');
        sb.append("program");
        sb.append('=');
        sb.append(((this.program == null)?"<null>":this.program));
        sb.append(',');
        sb.append("trackedEntityInstance");
        sb.append('=');
        sb.append(((this.trackedEntityInstance == null)?"<null>":this.trackedEntityInstance));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.program == null)? 0 :this.program.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.organisationUnit == null)? 0 :this.organisationUnit.hashCode()));
        result = ((result* 31)+((this.trackedEntityInstance == null)? 0 :this.trackedEntityInstance.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TrackedEntityProgramOwner) == false) {
            return false;
        }
        TrackedEntityProgramOwner rhs = ((TrackedEntityProgramOwner) other);
        return (((((this.program == rhs.program)||((this.program!= null)&&this.program.equals(rhs.program)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.organisationUnit == rhs.organisationUnit)||((this.organisationUnit!= null)&&this.organisationUnit.equals(rhs.organisationUnit))))&&((this.trackedEntityInstance == rhs.trackedEntityInstance)||((this.trackedEntityInstance!= null)&&this.trackedEntityInstance.equals(rhs.trackedEntityInstance))));
    }

}
