
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "created",
    "createdByUserInfo",
    "dataElement",
    "lastUpdated",
    "lastUpdatedByUserInfo",
    "providedElsewhere",
    "storedBy",
    "value"
})
@Generated("jsonschema2pojo")
public class TrackerDataValue implements Serializable
{

    @JsonProperty("created")
    private String created;
    @JsonProperty("createdByUserInfo")
    private UserInfoSnapshot createdByUserInfo;
    @JsonProperty("dataElement")
    private String dataElement;
    @JsonProperty("lastUpdated")
    private String lastUpdated;
    @JsonProperty("lastUpdatedByUserInfo")
    private UserInfoSnapshot lastUpdatedByUserInfo;
    @JsonProperty("providedElsewhere")
    private Boolean providedElsewhere;
    @JsonProperty("storedBy")
    private String storedBy;
    @JsonProperty("value")
    private String value;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 2539245469102779421L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrackerDataValue() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public TrackerDataValue(TrackerDataValue source) {
        super();
        this.created = source.created;
        this.createdByUserInfo = source.createdByUserInfo;
        this.dataElement = source.dataElement;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedByUserInfo = source.lastUpdatedByUserInfo;
        this.providedElsewhere = source.providedElsewhere;
        this.storedBy = source.storedBy;
        this.value = source.value;
    }

    public TrackerDataValue(String created, UserInfoSnapshot createdByUserInfo, String dataElement, String lastUpdated, UserInfoSnapshot lastUpdatedByUserInfo, Boolean providedElsewhere, String storedBy, String value) {
        super();
        this.created = created;
        this.createdByUserInfo = createdByUserInfo;
        this.dataElement = dataElement;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedByUserInfo = lastUpdatedByUserInfo;
        this.providedElsewhere = providedElsewhere;
        this.storedBy = storedBy;
        this.value = value;
    }

    @JsonProperty("created")
    public Optional<String> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(String created) {
        this.created = created;
    }

    public TrackerDataValue withCreated(String created) {
        this.created = created;
        return this;
    }

    @JsonProperty("createdByUserInfo")
    public Optional<UserInfoSnapshot> getCreatedByUserInfo() {
        return Optional.ofNullable(createdByUserInfo);
    }

    @JsonProperty("createdByUserInfo")
    public void setCreatedByUserInfo(UserInfoSnapshot createdByUserInfo) {
        this.createdByUserInfo = createdByUserInfo;
    }

    public TrackerDataValue withCreatedByUserInfo(UserInfoSnapshot createdByUserInfo) {
        this.createdByUserInfo = createdByUserInfo;
        return this;
    }

    @JsonProperty("dataElement")
    public Optional<String> getDataElement() {
        return Optional.ofNullable(dataElement);
    }

    @JsonProperty("dataElement")
    public void setDataElement(String dataElement) {
        this.dataElement = dataElement;
    }

    public TrackerDataValue withDataElement(String dataElement) {
        this.dataElement = dataElement;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<String> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public TrackerDataValue withLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedByUserInfo")
    public Optional<UserInfoSnapshot> getLastUpdatedByUserInfo() {
        return Optional.ofNullable(lastUpdatedByUserInfo);
    }

    @JsonProperty("lastUpdatedByUserInfo")
    public void setLastUpdatedByUserInfo(UserInfoSnapshot lastUpdatedByUserInfo) {
        this.lastUpdatedByUserInfo = lastUpdatedByUserInfo;
    }

    public TrackerDataValue withLastUpdatedByUserInfo(UserInfoSnapshot lastUpdatedByUserInfo) {
        this.lastUpdatedByUserInfo = lastUpdatedByUserInfo;
        return this;
    }

    @JsonProperty("providedElsewhere")
    public Optional<Boolean> getProvidedElsewhere() {
        return Optional.ofNullable(providedElsewhere);
    }

    @JsonProperty("providedElsewhere")
    public void setProvidedElsewhere(Boolean providedElsewhere) {
        this.providedElsewhere = providedElsewhere;
    }

    public TrackerDataValue withProvidedElsewhere(Boolean providedElsewhere) {
        this.providedElsewhere = providedElsewhere;
        return this;
    }

    @JsonProperty("storedBy")
    public Optional<String> getStoredBy() {
        return Optional.ofNullable(storedBy);
    }

    @JsonProperty("storedBy")
    public void setStoredBy(String storedBy) {
        this.storedBy = storedBy;
    }

    public TrackerDataValue withStoredBy(String storedBy) {
        this.storedBy = storedBy;
        return this;
    }

    @JsonProperty("value")
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    @JsonProperty("value")
    public void setValue(String value) {
        this.value = value;
    }

    public TrackerDataValue withValue(String value) {
        this.value = value;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackerDataValue withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("created".equals(name)) {
            if (value instanceof String) {
                setCreated(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"created\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("createdByUserInfo".equals(name)) {
                if (value instanceof UserInfoSnapshot) {
                    setCreatedByUserInfo(((UserInfoSnapshot) value));
                } else {
                    throw new IllegalArgumentException(("property \"createdByUserInfo\" is of type \"org.hisp.dhis.api.model.v40_2_2.UserInfoSnapshot\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("dataElement".equals(name)) {
                    if (value instanceof String) {
                        setDataElement(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"dataElement\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("lastUpdated".equals(name)) {
                        if (value instanceof String) {
                            setLastUpdated(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("lastUpdatedByUserInfo".equals(name)) {
                            if (value instanceof UserInfoSnapshot) {
                                setLastUpdatedByUserInfo(((UserInfoSnapshot) value));
                            } else {
                                throw new IllegalArgumentException(("property \"lastUpdatedByUserInfo\" is of type \"org.hisp.dhis.api.model.v40_2_2.UserInfoSnapshot\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("providedElsewhere".equals(name)) {
                                if (value instanceof Boolean) {
                                    setProvidedElsewhere(((Boolean) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"providedElsewhere\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("storedBy".equals(name)) {
                                    if (value instanceof String) {
                                        setStoredBy(((String) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"storedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("value".equals(name)) {
                                        if (value instanceof String) {
                                            setValue(((String) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"value\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        return false;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("created".equals(name)) {
            return getCreated();
        } else {
            if ("createdByUserInfo".equals(name)) {
                return getCreatedByUserInfo();
            } else {
                if ("dataElement".equals(name)) {
                    return getDataElement();
                } else {
                    if ("lastUpdated".equals(name)) {
                        return getLastUpdated();
                    } else {
                        if ("lastUpdatedByUserInfo".equals(name)) {
                            return getLastUpdatedByUserInfo();
                        } else {
                            if ("providedElsewhere".equals(name)) {
                                return getProvidedElsewhere();
                            } else {
                                if ("storedBy".equals(name)) {
                                    return getStoredBy();
                                } else {
                                    if ("value".equals(name)) {
                                        return getValue();
                                    } else {
                                        return notFoundValue;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TrackerDataValue.NOT_FOUND_VALUE);
        if (TrackerDataValue.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TrackerDataValue with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackerDataValue.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdByUserInfo");
        sb.append('=');
        sb.append(((this.createdByUserInfo == null)?"<null>":this.createdByUserInfo));
        sb.append(',');
        sb.append("dataElement");
        sb.append('=');
        sb.append(((this.dataElement == null)?"<null>":this.dataElement));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedByUserInfo");
        sb.append('=');
        sb.append(((this.lastUpdatedByUserInfo == null)?"<null>":this.lastUpdatedByUserInfo));
        sb.append(',');
        sb.append("providedElsewhere");
        sb.append('=');
        sb.append(((this.providedElsewhere == null)?"<null>":this.providedElsewhere));
        sb.append(',');
        sb.append("storedBy");
        sb.append('=');
        sb.append(((this.storedBy == null)?"<null>":this.storedBy));
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(((this.value == null)?"<null>":this.value));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.storedBy == null)? 0 :this.storedBy.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.dataElement == null)? 0 :this.dataElement.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.createdByUserInfo == null)? 0 :this.createdByUserInfo.hashCode()));
        result = ((result* 31)+((this.value == null)? 0 :this.value.hashCode()));
        result = ((result* 31)+((this.providedElsewhere == null)? 0 :this.providedElsewhere.hashCode()));
        result = ((result* 31)+((this.lastUpdatedByUserInfo == null)? 0 :this.lastUpdatedByUserInfo.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TrackerDataValue) == false) {
            return false;
        }
        TrackerDataValue rhs = ((TrackerDataValue) other);
        return ((((((((((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated)))&&((this.storedBy == rhs.storedBy)||((this.storedBy!= null)&&this.storedBy.equals(rhs.storedBy))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.dataElement == rhs.dataElement)||((this.dataElement!= null)&&this.dataElement.equals(rhs.dataElement))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.createdByUserInfo == rhs.createdByUserInfo)||((this.createdByUserInfo!= null)&&this.createdByUserInfo.equals(rhs.createdByUserInfo))))&&((this.value == rhs.value)||((this.value!= null)&&this.value.equals(rhs.value))))&&((this.providedElsewhere == rhs.providedElsewhere)||((this.providedElsewhere!= null)&&this.providedElsewhere.equals(rhs.providedElsewhere))))&&((this.lastUpdatedByUserInfo == rhs.lastUpdatedByUserInfo)||((this.lastUpdatedByUserInfo!= null)&&this.lastUpdatedByUserInfo.equals(rhs.lastUpdatedByUserInfo))));
    }

}
