
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "errorReports",
    "warningReports"
})
@Generated("jsonschema2pojo")
public class ValidationReport implements Serializable
{

    @JsonProperty("errorReports")
    private List<Error> errorReports;
    @JsonProperty("warningReports")
    private List<Warning> warningReports;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -2105706473219453549L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ValidationReport() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ValidationReport(ValidationReport source) {
        super();
        this.errorReports = source.errorReports;
        this.warningReports = source.warningReports;
    }

    public ValidationReport(List<Error> errorReports, List<Warning> warningReports) {
        super();
        this.errorReports = errorReports;
        this.warningReports = warningReports;
    }

    @JsonProperty("errorReports")
    public Optional<List<Error>> getErrorReports() {
        return Optional.ofNullable(errorReports);
    }

    @JsonProperty("errorReports")
    public void setErrorReports(List<Error> errorReports) {
        this.errorReports = errorReports;
    }

    public ValidationReport withErrorReports(List<Error> errorReports) {
        this.errorReports = errorReports;
        return this;
    }

    @JsonProperty("warningReports")
    public Optional<List<Warning>> getWarningReports() {
        return Optional.ofNullable(warningReports);
    }

    @JsonProperty("warningReports")
    public void setWarningReports(List<Warning> warningReports) {
        this.warningReports = warningReports;
    }

    public ValidationReport withWarningReports(List<Warning> warningReports) {
        this.warningReports = warningReports;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ValidationReport withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("errorReports".equals(name)) {
            if (value instanceof List) {
                setErrorReports(((List<Error> ) value));
            } else {
                throw new IllegalArgumentException(("property \"errorReports\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.Error>\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("warningReports".equals(name)) {
                if (value instanceof List) {
                    setWarningReports(((List<Warning> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"warningReports\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.Warning>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                return false;
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("errorReports".equals(name)) {
            return getErrorReports();
        } else {
            if ("warningReports".equals(name)) {
                return getWarningReports();
            } else {
                return notFoundValue;
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ValidationReport.NOT_FOUND_VALUE);
        if (ValidationReport.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ValidationReport with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ValidationReport.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("errorReports");
        sb.append('=');
        sb.append(((this.errorReports == null)?"<null>":this.errorReports));
        sb.append(',');
        sb.append("warningReports");
        sb.append('=');
        sb.append(((this.warningReports == null)?"<null>":this.warningReports));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.errorReports == null)? 0 :this.errorReports.hashCode()));
        result = ((result* 31)+((this.warningReports == null)? 0 :this.warningReports.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ValidationReport) == false) {
            return false;
        }
        ValidationReport rhs = ((ValidationReport) other);
        return ((((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties)))&&((this.errorReports == rhs.errorReports)||((this.errorReports!= null)&&this.errorReports.equals(rhs.errorReports))))&&((this.warningReports == rhs.warningReports)||((this.warningReports!= null)&&this.warningReports.equals(rhs.warningReports))));
    }

}
