/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_35_13;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum Compression {
    NONE("NONE"),
    GZIP("GZIP"),
    ZIP("ZIP");

    private final String value;
    private static final Map<String, Compression> CONSTANTS;

    private Compression(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static Compression fromValue(String value) {
        Compression constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, Compression>();
        for (Compression c : Compression.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

