/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_35_13;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum TrackerObjectType {
    EVENT("EVENT"),
    ENROLLMENT("ENROLLMENT");

    private final String value;
    private static final Map<String, TrackerObjectType> CONSTANTS;

    private TrackerObjectType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static TrackerObjectType fromValue(String value) {
        TrackerObjectType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, TrackerObjectType>();
        for (TrackerObjectType c : TrackerObjectType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

