/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_36_11;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum AccessLevel {
    OPEN("OPEN"),
    AUDITED("AUDITED"),
    PROTECTED("PROTECTED"),
    CLOSED("CLOSED");

    private final String value;
    private static final Map<String, AccessLevel> CONSTANTS;

    private AccessLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static AccessLevel fromValue(String value) {
        AccessLevel constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, AccessLevel>();
        for (AccessLevel c : AccessLevel.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

