/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_36_11;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum AnalyticsMetaDataKey {
    ITEMS("ITEMS"),
    DIMENSIONS("DIMENSIONS"),
    PAGER("PAGER"),
    ORG_UNIT_HIERARCHY("ORG_UNIT_HIERARCHY"),
    ORG_UNIT_NAME_HIERARCHY("ORG_UNIT_NAME_HIERARCHY"),
    ORG_UNIT_ANCESTORS("ORG_UNIT_ANCESTORS");

    private final String value;
    private static final Map<String, AnalyticsMetaDataKey> CONSTANTS;

    private AnalyticsMetaDataKey(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static AnalyticsMetaDataKey fromValue(String value) {
        AnalyticsMetaDataKey constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, AnalyticsMetaDataKey>();
        for (AnalyticsMetaDataKey c : AnalyticsMetaDataKey.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

