/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_36_11;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum AttributeType {
    DATA_ELEMENT("DATA_ELEMENT"),
    TRACKED_ENTITY_ATTRIBUTE("TRACKED_ENTITY_ATTRIBUTE"),
    UNKNOWN("UNKNOWN");

    private final String value;
    private static final Map<String, AttributeType> CONSTANTS;

    private AttributeType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static AttributeType fromValue(String value) {
        AttributeType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, AttributeType>();
        for (AttributeType c : AttributeType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

