/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_36_11;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum DeliveryChannel {
    SMS("SMS"),
    EMAIL("EMAIL");

    private final String value;
    private static final Map<String, DeliveryChannel> CONSTANTS;

    private DeliveryChannel(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static DeliveryChannel fromValue(String value) {
        DeliveryChannel constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, DeliveryChannel>();
        for (DeliveryChannel c : DeliveryChannel.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

