/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_36_11;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hisp.dhis.api.model.v2_36_11.Order;
import org.hisp.dhis.api.model.v2_36_11.OutlierDetectionAlgorithm;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"algorithm", "dataEndDate", "dataStartDate", "de", "ds", "endDate", "maxResults", "orderBy", "ou", "startDate", "threshold"})
public class OutlierDetectionQuery
implements Serializable {
    @JsonProperty(value="algorithm")
    private OutlierDetectionAlgorithm algorithm;
    @JsonProperty(value="dataEndDate")
    private Date dataEndDate;
    @JsonProperty(value="dataStartDate")
    private Date dataStartDate;
    @JsonProperty(value="de")
    private List<String> de;
    @JsonProperty(value="ds")
    private List<String> ds;
    @JsonProperty(value="endDate")
    private Date endDate;
    @JsonProperty(value="maxResults")
    private Integer maxResults;
    @JsonProperty(value="orderBy")
    private Order orderBy;
    @JsonProperty(value="ou")
    private List<String> ou;
    @JsonProperty(value="startDate")
    private Date startDate;
    @JsonProperty(value="threshold")
    private Double threshold;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected static final Object NOT_FOUND_VALUE = new Object();
    private static final long serialVersionUID = -4864202572613563233L;

    public OutlierDetectionQuery() {
    }

    public OutlierDetectionQuery(OutlierDetectionQuery source) {
        this.algorithm = source.algorithm;
        this.dataEndDate = source.dataEndDate;
        this.dataStartDate = source.dataStartDate;
        this.de = source.de;
        this.ds = source.ds;
        this.endDate = source.endDate;
        this.maxResults = source.maxResults;
        this.orderBy = source.orderBy;
        this.ou = source.ou;
        this.startDate = source.startDate;
        this.threshold = source.threshold;
    }

    public OutlierDetectionQuery(OutlierDetectionAlgorithm algorithm, Date dataEndDate, Date dataStartDate, List<String> de, List<String> ds, Date endDate, Integer maxResults, Order orderBy, List<String> ou, Date startDate, Double threshold) {
        this.algorithm = algorithm;
        this.dataEndDate = dataEndDate;
        this.dataStartDate = dataStartDate;
        this.de = de;
        this.ds = ds;
        this.endDate = endDate;
        this.maxResults = maxResults;
        this.orderBy = orderBy;
        this.ou = ou;
        this.startDate = startDate;
        this.threshold = threshold;
    }

    @JsonProperty(value="algorithm")
    public Optional<OutlierDetectionAlgorithm> getAlgorithm() {
        return Optional.ofNullable(this.algorithm);
    }

    @JsonProperty(value="algorithm")
    public void setAlgorithm(OutlierDetectionAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public OutlierDetectionQuery withAlgorithm(OutlierDetectionAlgorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    @JsonProperty(value="dataEndDate")
    public Optional<Date> getDataEndDate() {
        return Optional.ofNullable(this.dataEndDate);
    }

    @JsonProperty(value="dataEndDate")
    public void setDataEndDate(Date dataEndDate) {
        this.dataEndDate = dataEndDate;
    }

    public OutlierDetectionQuery withDataEndDate(Date dataEndDate) {
        this.dataEndDate = dataEndDate;
        return this;
    }

    @JsonProperty(value="dataStartDate")
    public Optional<Date> getDataStartDate() {
        return Optional.ofNullable(this.dataStartDate);
    }

    @JsonProperty(value="dataStartDate")
    public void setDataStartDate(Date dataStartDate) {
        this.dataStartDate = dataStartDate;
    }

    public OutlierDetectionQuery withDataStartDate(Date dataStartDate) {
        this.dataStartDate = dataStartDate;
        return this;
    }

    @JsonProperty(value="de")
    public Optional<List<String>> getDe() {
        return Optional.ofNullable(this.de);
    }

    @JsonProperty(value="de")
    public void setDe(List<String> de) {
        this.de = de;
    }

    public OutlierDetectionQuery withDe(List<String> de) {
        this.de = de;
        return this;
    }

    @JsonProperty(value="ds")
    public Optional<List<String>> getDs() {
        return Optional.ofNullable(this.ds);
    }

    @JsonProperty(value="ds")
    public void setDs(List<String> ds) {
        this.ds = ds;
    }

    public OutlierDetectionQuery withDs(List<String> ds) {
        this.ds = ds;
        return this;
    }

    @JsonProperty(value="endDate")
    public Optional<Date> getEndDate() {
        return Optional.ofNullable(this.endDate);
    }

    @JsonProperty(value="endDate")
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public OutlierDetectionQuery withEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    @JsonProperty(value="maxResults")
    public Optional<Integer> getMaxResults() {
        return Optional.ofNullable(this.maxResults);
    }

    @JsonProperty(value="maxResults")
    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public OutlierDetectionQuery withMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    @JsonProperty(value="orderBy")
    public Optional<Order> getOrderBy() {
        return Optional.ofNullable(this.orderBy);
    }

    @JsonProperty(value="orderBy")
    public void setOrderBy(Order orderBy) {
        this.orderBy = orderBy;
    }

    public OutlierDetectionQuery withOrderBy(Order orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    @JsonProperty(value="ou")
    public Optional<List<String>> getOu() {
        return Optional.ofNullable(this.ou);
    }

    @JsonProperty(value="ou")
    public void setOu(List<String> ou) {
        this.ou = ou;
    }

    public OutlierDetectionQuery withOu(List<String> ou) {
        this.ou = ou;
        return this;
    }

    @JsonProperty(value="startDate")
    public Optional<Date> getStartDate() {
        return Optional.ofNullable(this.startDate);
    }

    @JsonProperty(value="startDate")
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public OutlierDetectionQuery withStartDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @JsonProperty(value="threshold")
    public Optional<Double> getThreshold() {
        return Optional.ofNullable(this.threshold);
    }

    @JsonProperty(value="threshold")
    public void setThreshold(Double threshold) {
        this.threshold = threshold;
    }

    public OutlierDetectionQuery withThreshold(Double threshold) {
        this.threshold = threshold;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public OutlierDetectionQuery withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("algorithm".equals(name)) {
            if (!(value instanceof OutlierDetectionAlgorithm)) {
                throw new IllegalArgumentException("property \"algorithm\" is of type \"org.hisp.dhis.api.model.v2_36_11.OutlierDetectionAlgorithm\", but got " + value.getClass().toString());
            }
            this.setAlgorithm((OutlierDetectionAlgorithm)((Object)value));
            return true;
        }
        if ("dataEndDate".equals(name)) {
            if (!(value instanceof Date)) {
                throw new IllegalArgumentException("property \"dataEndDate\" is of type \"java.util.Date\", but got " + value.getClass().toString());
            }
            this.setDataEndDate((Date)value);
            return true;
        }
        if ("dataStartDate".equals(name)) {
            if (!(value instanceof Date)) {
                throw new IllegalArgumentException("property \"dataStartDate\" is of type \"java.util.Date\", but got " + value.getClass().toString());
            }
            this.setDataStartDate((Date)value);
            return true;
        }
        if ("de".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"de\" is of type \"java.util.List<java.lang.String>\", but got " + value.getClass().toString());
            }
            this.setDe((List)value);
            return true;
        }
        if ("ds".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"ds\" is of type \"java.util.List<java.lang.String>\", but got " + value.getClass().toString());
            }
            this.setDs((List)value);
            return true;
        }
        if ("endDate".equals(name)) {
            if (!(value instanceof Date)) {
                throw new IllegalArgumentException("property \"endDate\" is of type \"java.util.Date\", but got " + value.getClass().toString());
            }
            this.setEndDate((Date)value);
            return true;
        }
        if ("maxResults".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"maxResults\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setMaxResults((Integer)value);
            return true;
        }
        if ("orderBy".equals(name)) {
            if (!(value instanceof Order)) {
                throw new IllegalArgumentException("property \"orderBy\" is of type \"org.hisp.dhis.api.model.v2_36_11.Order\", but got " + value.getClass().toString());
            }
            this.setOrderBy((Order)((Object)value));
            return true;
        }
        if ("ou".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"ou\" is of type \"java.util.List<java.lang.String>\", but got " + value.getClass().toString());
            }
            this.setOu((List)value);
            return true;
        }
        if ("startDate".equals(name)) {
            if (!(value instanceof Date)) {
                throw new IllegalArgumentException("property \"startDate\" is of type \"java.util.Date\", but got " + value.getClass().toString());
            }
            this.setStartDate((Date)value);
            return true;
        }
        if ("threshold".equals(name)) {
            if (!(value instanceof Double)) {
                throw new IllegalArgumentException("property \"threshold\" is of type \"java.lang.Double\", but got " + value.getClass().toString());
            }
            this.setThreshold((Double)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("algorithm".equals(name)) {
            return this.getAlgorithm();
        }
        if ("dataEndDate".equals(name)) {
            return this.getDataEndDate();
        }
        if ("dataStartDate".equals(name)) {
            return this.getDataStartDate();
        }
        if ("de".equals(name)) {
            return this.getDe();
        }
        if ("ds".equals(name)) {
            return this.getDs();
        }
        if ("endDate".equals(name)) {
            return this.getEndDate();
        }
        if ("maxResults".equals(name)) {
            return this.getMaxResults();
        }
        if ("orderBy".equals(name)) {
            return this.getOrderBy();
        }
        if ("ou".equals(name)) {
            return this.getOu();
        }
        if ("startDate".equals(name)) {
            return this.getStartDate();
        }
        if ("threshold".equals(name)) {
            return this.getThreshold();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        return (T)this.getAdditionalProperties().get(name);
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
    }

    public OutlierDetectionQuery with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OutlierDetectionQuery.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("algorithm");
        sb.append('=');
        sb.append(this.algorithm == null ? "<null>" : this.algorithm);
        sb.append(',');
        sb.append("dataEndDate");
        sb.append('=');
        sb.append(this.dataEndDate == null ? "<null>" : this.dataEndDate);
        sb.append(',');
        sb.append("dataStartDate");
        sb.append('=');
        sb.append(this.dataStartDate == null ? "<null>" : this.dataStartDate);
        sb.append(',');
        sb.append("de");
        sb.append('=');
        sb.append(this.de == null ? "<null>" : this.de);
        sb.append(',');
        sb.append("ds");
        sb.append('=');
        sb.append(this.ds == null ? "<null>" : this.ds);
        sb.append(',');
        sb.append("endDate");
        sb.append('=');
        sb.append(this.endDate == null ? "<null>" : this.endDate);
        sb.append(',');
        sb.append("maxResults");
        sb.append('=');
        sb.append(this.maxResults == null ? "<null>" : this.maxResults);
        sb.append(',');
        sb.append("orderBy");
        sb.append('=');
        sb.append(this.orderBy == null ? "<null>" : this.orderBy);
        sb.append(',');
        sb.append("ou");
        sb.append('=');
        sb.append(this.ou == null ? "<null>" : this.ou);
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(this.startDate == null ? "<null>" : this.startDate);
        sb.append(',');
        sb.append("threshold");
        sb.append('=');
        sb.append(this.threshold == null ? "<null>" : this.threshold);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.de == null ? 0 : this.de.hashCode());
        result = result * 31 + (this.endDate == null ? 0 : this.endDate.hashCode());
        result = result * 31 + (this.ou == null ? 0 : this.ou.hashCode());
        result = result * 31 + (this.orderBy == null ? 0 : this.orderBy.hashCode());
        result = result * 31 + (this.threshold == null ? 0 : this.threshold.hashCode());
        result = result * 31 + (this.ds == null ? 0 : this.ds.hashCode());
        result = result * 31 + (this.dataStartDate == null ? 0 : this.dataStartDate.hashCode());
        result = result * 31 + (this.maxResults == null ? 0 : this.maxResults.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.dataEndDate == null ? 0 : this.dataEndDate.hashCode());
        result = result * 31 + (this.startDate == null ? 0 : this.startDate.hashCode());
        result = result * 31 + (this.algorithm == null ? 0 : this.algorithm.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OutlierDetectionQuery)) {
            return false;
        }
        OutlierDetectionQuery rhs = (OutlierDetectionQuery)other;
        return (this.de == rhs.de || this.de != null && this.de.equals(rhs.de)) && (this.endDate == rhs.endDate || this.endDate != null && this.endDate.equals(rhs.endDate)) && (this.ou == rhs.ou || this.ou != null && this.ou.equals(rhs.ou)) && (this.orderBy == rhs.orderBy || this.orderBy != null && this.orderBy.equals((Object)rhs.orderBy)) && (this.threshold == rhs.threshold || this.threshold != null && this.threshold.equals(rhs.threshold)) && (this.ds == rhs.ds || this.ds != null && this.ds.equals(rhs.ds)) && (this.dataStartDate == rhs.dataStartDate || this.dataStartDate != null && this.dataStartDate.equals(rhs.dataStartDate)) && (this.maxResults == rhs.maxResults || this.maxResults != null && this.maxResults.equals(rhs.maxResults)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.dataEndDate == rhs.dataEndDate || this.dataEndDate != null && this.dataEndDate.equals(rhs.dataEndDate)) && (this.startDate == rhs.startDate || this.startDate != null && this.startDate.equals(rhs.startDate)) && (this.algorithm == rhs.algorithm || this.algorithm != null && this.algorithm.equals((Object)rhs.algorithm));
    }
}

