/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_37_7;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum DateUnitType {
    DAILY("DAILY"),
    WEEKLY("WEEKLY"),
    WEEKLY_WEDNESDAY("WEEKLY_WEDNESDAY"),
    WEEKLY_THURSDAY("WEEKLY_THURSDAY"),
    WEEKLY_SATURDAY("WEEKLY_SATURDAY"),
    WEEKLY_SUNDAY("WEEKLY_SUNDAY"),
    BI_WEEKLY("BI_WEEKLY"),
    MONTHLY("MONTHLY"),
    BI_MONTHLY("BI_MONTHLY"),
    QUARTERLY("QUARTERLY"),
    SIX_MONTHLY("SIX_MONTHLY"),
    SIX_MONTHLY_APRIL("SIX_MONTHLY_APRIL"),
    SIX_MONTHLY_NOVEMBER("SIX_MONTHLY_NOVEMBER"),
    YEARLY("YEARLY"),
    FINANCIAL_APRIL("FINANCIAL_APRIL"),
    FINANCIAL_JULY("FINANCIAL_JULY"),
    FINANCIAL_OCTOBER("FINANCIAL_OCTOBER"),
    FINANCIAL_NOVEMBER("FINANCIAL_NOVEMBER");

    private final String value;
    private static final Map<String, DateUnitType> CONSTANTS;

    private DateUnitType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static DateUnitType fromValue(String value) {
        DateUnitType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, DateUnitType>();
        for (DateUnitType c : DateUnitType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

