/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_37_7;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum IssueType {
    WARNING("WARNING"),
    ERROR("ERROR");

    private final String value;
    private static final Map<String, IssueType> CONSTANTS;

    private IssueType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static IssueType fromValue(String value) {
        IssueType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, IssueType>();
        for (IssueType c : IssueType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

