/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_37_7;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ItemValueType {
    NUMBER("NUMBER"),
    DATE("DATE"),
    TEXT("TEXT"),
    BOOLEAN("BOOLEAN");

    private final String value;
    private static final Map<String, ItemValueType> CONSTANTS;

    private ItemValueType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static ItemValueType fromValue(String value) {
        ItemValueType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ItemValueType>();
        for (ItemValueType c : ItemValueType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

