/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_37_7;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum OutlierDetectionAlgorithm {
    Z_SCORE("Z_SCORE"),
    MIN_MAX("MIN_MAX"),
    MOD_Z_SCORE("MOD_Z_SCORE");

    private final String value;
    private static final Map<String, OutlierDetectionAlgorithm> CONSTANTS;

    private OutlierDetectionAlgorithm(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static OutlierDetectionAlgorithm fromValue(String value) {
        OutlierDetectionAlgorithm constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, OutlierDetectionAlgorithm>();
        for (OutlierDetectionAlgorithm c : OutlierDetectionAlgorithm.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

