/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_37_7;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum SyncEndpoint {
    TRACKED_ENTITY_INSTANCES("TRACKED_ENTITY_INSTANCES"),
    ENROLLMENTS("ENROLLMENTS"),
    EVENTS("EVENTS"),
    COMPLETE_DATA_SET_REGISTRATIONS("COMPLETE_DATA_SET_REGISTRATIONS"),
    DATA_VALUE_SETS("DATA_VALUE_SETS");

    private final String value;
    private static final Map<String, SyncEndpoint> CONSTANTS;

    private SyncEndpoint(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static SyncEndpoint fromValue(String value) {
        SyncEndpoint constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, SyncEndpoint>();
        for (SyncEndpoint c : SyncEndpoint.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

