/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_37_7;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum TranslationProperty {
    NAME("NAME"),
    SHORT_NAME("SHORT_NAME"),
    DESCRIPTION("DESCRIPTION"),
    FORM_NAME("FORM_NAME"),
    NUMERATOR_DESCRIPTION("NUMERATOR_DESCRIPTION"),
    DENOMINATOR_DESCRIPTION("DENOMINATOR_DESCRIPTION"),
    RELATIONSHIP_FROM_TO_NAME("RELATIONSHIP_FROM_TO_NAME"),
    RELATIONSHIP_TO_FROM_NAME("RELATIONSHIP_TO_FROM_NAME"),
    INSTRUCTION("INSTRUCTION"),
    INCIDENT_DATE_LABEL("INCIDENT_DATE_LABEL"),
    ENROLLMENT_DATE_LABEL("ENROLLMENT_DATE_LABEL"),
    EXECUTION_DATE_LABEL("EXECUTION_DATE_LABEL"),
    DUE_DATE_LABEL("DUE_DATE_LABEL"),
    CONTENT("CONTENT");

    private final String value;
    private static final Map<String, TranslationProperty> CONSTANTS;

    private TranslationProperty(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static TranslationProperty fromValue(String value) {
        TranslationProperty constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, TranslationProperty>();
        for (TranslationProperty c : TranslationProperty.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

