/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_38_1;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.hisp.dhis.api.model.v2_38_1.ArtemisEmbeddedConfig;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"embedded", "host", "mode", "port", "sendAsync"})
public class ArtemisConfigData
implements Serializable {
    @JsonProperty(value="embedded")
    private ArtemisEmbeddedConfig embedded;
    @JsonProperty(value="host")
    private String host;
    @JsonProperty(value="mode")
    private ArtemisMode mode;
    @JsonProperty(value="port")
    private Integer port;
    @JsonProperty(value="sendAsync")
    private Boolean sendAsync;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected static final Object NOT_FOUND_VALUE = new Object();
    private static final long serialVersionUID = 6981990483693176826L;

    public ArtemisConfigData() {
    }

    public ArtemisConfigData(ArtemisConfigData source) {
        this.embedded = source.embedded;
        this.host = source.host;
        this.mode = source.mode;
        this.port = source.port;
        this.sendAsync = source.sendAsync;
    }

    public ArtemisConfigData(ArtemisEmbeddedConfig embedded, String host, ArtemisMode mode, Integer port, Boolean sendAsync) {
        this.embedded = embedded;
        this.host = host;
        this.mode = mode;
        this.port = port;
        this.sendAsync = sendAsync;
    }

    @JsonProperty(value="embedded")
    public Optional<ArtemisEmbeddedConfig> getEmbedded() {
        return Optional.ofNullable(this.embedded);
    }

    @JsonProperty(value="embedded")
    public void setEmbedded(ArtemisEmbeddedConfig embedded) {
        this.embedded = embedded;
    }

    public ArtemisConfigData withEmbedded(ArtemisEmbeddedConfig embedded) {
        this.embedded = embedded;
        return this;
    }

    @JsonProperty(value="host")
    public Optional<String> getHost() {
        return Optional.ofNullable(this.host);
    }

    @JsonProperty(value="host")
    public void setHost(String host) {
        this.host = host;
    }

    public ArtemisConfigData withHost(String host) {
        this.host = host;
        return this;
    }

    @JsonProperty(value="mode")
    public Optional<ArtemisMode> getMode() {
        return Optional.ofNullable(this.mode);
    }

    @JsonProperty(value="mode")
    public void setMode(ArtemisMode mode) {
        this.mode = mode;
    }

    public ArtemisConfigData withMode(ArtemisMode mode) {
        this.mode = mode;
        return this;
    }

    @JsonProperty(value="port")
    public Optional<Integer> getPort() {
        return Optional.ofNullable(this.port);
    }

    @JsonProperty(value="port")
    public void setPort(Integer port) {
        this.port = port;
    }

    public ArtemisConfigData withPort(Integer port) {
        this.port = port;
        return this;
    }

    @JsonProperty(value="sendAsync")
    public Optional<Boolean> getSendAsync() {
        return Optional.ofNullable(this.sendAsync);
    }

    @JsonProperty(value="sendAsync")
    public void setSendAsync(Boolean sendAsync) {
        this.sendAsync = sendAsync;
    }

    public ArtemisConfigData withSendAsync(Boolean sendAsync) {
        this.sendAsync = sendAsync;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ArtemisConfigData withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("embedded".equals(name)) {
            if (!(value instanceof ArtemisEmbeddedConfig)) {
                throw new IllegalArgumentException("property \"embedded\" is of type \"org.hisp.dhis.api.model.v2_38_1.ArtemisEmbeddedConfig\", but got " + value.getClass().toString());
            }
            this.setEmbedded((ArtemisEmbeddedConfig)value);
            return true;
        }
        if ("host".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"host\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setHost((String)value);
            return true;
        }
        if ("mode".equals(name)) {
            if (!(value instanceof ArtemisMode)) {
                throw new IllegalArgumentException("property \"mode\" is of type \"org.hisp.dhis.api.model.v2_38_1.ArtemisConfigData.ArtemisMode\", but got " + value.getClass().toString());
            }
            this.setMode((ArtemisMode)((Object)value));
            return true;
        }
        if ("port".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"port\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setPort((Integer)value);
            return true;
        }
        if ("sendAsync".equals(name)) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("property \"sendAsync\" is of type \"java.lang.Boolean\", but got " + value.getClass().toString());
            }
            this.setSendAsync((Boolean)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("embedded".equals(name)) {
            return this.getEmbedded();
        }
        if ("host".equals(name)) {
            return this.getHost();
        }
        if ("mode".equals(name)) {
            return this.getMode();
        }
        if ("port".equals(name)) {
            return this.getPort();
        }
        if ("sendAsync".equals(name)) {
            return this.getSendAsync();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        return (T)this.getAdditionalProperties().get(name);
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
    }

    public ArtemisConfigData with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ArtemisConfigData.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("embedded");
        sb.append('=');
        sb.append(this.embedded == null ? "<null>" : this.embedded);
        sb.append(',');
        sb.append("host");
        sb.append('=');
        sb.append(this.host == null ? "<null>" : this.host);
        sb.append(',');
        sb.append("mode");
        sb.append('=');
        sb.append(this.mode == null ? "<null>" : this.mode);
        sb.append(',');
        sb.append("port");
        sb.append('=');
        sb.append(this.port == null ? "<null>" : this.port);
        sb.append(',');
        sb.append("sendAsync");
        sb.append('=');
        sb.append(this.sendAsync == null ? "<null>" : this.sendAsync);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.mode == null ? 0 : this.mode.hashCode());
        result = result * 31 + (this.sendAsync == null ? 0 : this.sendAsync.hashCode());
        result = result * 31 + (this.port == null ? 0 : this.port.hashCode());
        result = result * 31 + (this.host == null ? 0 : this.host.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.embedded == null ? 0 : this.embedded.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ArtemisConfigData)) {
            return false;
        }
        ArtemisConfigData rhs = (ArtemisConfigData)other;
        return (this.mode == rhs.mode || this.mode != null && this.mode.equals((Object)rhs.mode)) && (this.sendAsync == rhs.sendAsync || this.sendAsync != null && this.sendAsync.equals(rhs.sendAsync)) && (this.port == rhs.port || this.port != null && this.port.equals(rhs.port)) && (this.host == rhs.host || this.host != null && this.host.equals(rhs.host)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.embedded == rhs.embedded || this.embedded != null && this.embedded.equals(rhs.embedded));
    }

    public static enum ArtemisMode {
        EMBEDDED("EMBEDDED"),
        NATIVE("NATIVE");

        private final String value;
        private static final Map<String, ArtemisMode> CONSTANTS;

        private ArtemisMode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ArtemisMode fromValue(String value) {
            ArtemisMode constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ArtemisMode>();
            for (ArtemisMode c : ArtemisMode.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

