/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_38_1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum DataIntegrityCheckType {
    DATA_ELEMENTS_WITHOUT_DATA_SETS("DATA_ELEMENTS_WITHOUT_DATA_SETS"),
    DATA_ELEMENTS_WITHOUT_GROUPS("DATA_ELEMENTS_WITHOUT_GROUPS"),
    DATA_ELEMENTS_ASSIGNED_TO_DATA_SETS_WITH_DIFFERENT_PERIOD_TYPES("DATA_ELEMENTS_ASSIGNED_TO_DATA_SETS_WITH_DIFFERENT_PERIOD_TYPES"),
    DATA_ELEMENTS_VIOLATING_EXCLUSIVE_GROUP_SETS("DATA_ELEMENTS_VIOLATING_EXCLUSIVE_GROUP_SETS"),
    DATA_ELEMENTS_IN_DATA_SET_NOT_IN_FORM("DATA_ELEMENTS_IN_DATA_SET_NOT_IN_FORM"),
    CATEGORY_COMBOS_BEING_INVALID("CATEGORY_COMBOS_BEING_INVALID"),
    DATA_SETS_NOT_ASSIGNED_TO_ORG_UNITS("DATA_SETS_NOT_ASSIGNED_TO_ORG_UNITS"),
    INDICATORS_WITH_IDENTICAL_FORMULAS("INDICATORS_WITH_IDENTICAL_FORMULAS"),
    INDICATORS_WITHOUT_GROUPS("INDICATORS_WITHOUT_GROUPS"),
    INDICATORS_WITH_INVALID_NUMERATOR("INDICATORS_WITH_INVALID_NUMERATOR"),
    INDICATORS_WITH_INVALID_DENOMINATOR("INDICATORS_WITH_INVALID_DENOMINATOR"),
    INDICATORS_VIOLATING_EXCLUSIVE_GROUP_SETS("INDICATORS_VIOLATING_EXCLUSIVE_GROUP_SETS"),
    PERIODS_DUPLICATES("PERIODS_DUPLICATES"),
    ORG_UNITS_WITH_CYCLIC_REFERENCES("ORG_UNITS_WITH_CYCLIC_REFERENCES"),
    ORG_UNITS_BEING_ORPHANED("ORG_UNITS_BEING_ORPHANED"),
    ORG_UNITS_WITHOUT_GROUPS("ORG_UNITS_WITHOUT_GROUPS"),
    ORG_UNITS_VIOLATING_EXCLUSIVE_GROUP_SETS("ORG_UNITS_VIOLATING_EXCLUSIVE_GROUP_SETS"),
    ORG_UNIT_GROUPS_WITHOUT_GROUP_SETS("ORG_UNIT_GROUPS_WITHOUT_GROUP_SETS"),
    VALIDATION_RULES_WITHOUT_GROUPS("VALIDATION_RULES_WITHOUT_GROUPS"),
    VALIDATION_RULES_WITH_INVALID_LEFT_SIDE_EXPRESSION("VALIDATION_RULES_WITH_INVALID_LEFT_SIDE_EXPRESSION"),
    VALIDATION_RULES_WITH_INVALID_RIGHT_SIDE_EXPRESSION("VALIDATION_RULES_WITH_INVALID_RIGHT_SIDE_EXPRESSION"),
    PROGRAM_INDICATORS_WITH_INVALID_EXPRESSIONS("PROGRAM_INDICATORS_WITH_INVALID_EXPRESSIONS"),
    PROGRAM_INDICATORS_WITH_INVALID_FILTERS("PROGRAM_INDICATORS_WITH_INVALID_FILTERS"),
    PROGRAM_INDICATORS_WITHOUT_EXPRESSION("PROGRAM_INDICATORS_WITHOUT_EXPRESSION"),
    PROGRAM_RULES_WITHOUT_CONDITION("PROGRAM_RULES_WITHOUT_CONDITION"),
    PROGRAM_RULES_WITHOUT_PRIORITY("PROGRAM_RULES_WITHOUT_PRIORITY"),
    PROGRAM_RULES_WITHOUT_ACTION("PROGRAM_RULES_WITHOUT_ACTION"),
    PROGRAM_RULE_VARIABLES_WITHOUT_DATA_ELEMENT("PROGRAM_RULE_VARIABLES_WITHOUT_DATA_ELEMENT"),
    PROGRAM_RULE_VARIABLES_WITHOUT_ATTRIBUTE("PROGRAM_RULE_VARIABLES_WITHOUT_ATTRIBUTE"),
    PROGRAM_RULE_ACTIONS_WITHOUT_DATA_OBJECT("PROGRAM_RULE_ACTIONS_WITHOUT_DATA_OBJECT"),
    PROGRAM_RULE_ACTIONS_WITHOUT_NOTIFICATION("PROGRAM_RULE_ACTIONS_WITHOUT_NOTIFICATION"),
    PROGRAM_RULE_ACTIONS_WITHOUT_SECTION("PROGRAM_RULE_ACTIONS_WITHOUT_SECTION"),
    PROGRAM_RULE_ACTIONS_WITHOUT_STAGE("PROGRAM_RULE_ACTIONS_WITHOUT_STAGE");

    private final String value;
    private static final Map<String, DataIntegrityCheckType> CONSTANTS;

    private DataIntegrityCheckType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static DataIntegrityCheckType fromValue(String value) {
        DataIntegrityCheckType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, DataIntegrityCheckType>();
        for (DataIntegrityCheckType c : DataIntegrityCheckType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

