/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_38_1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ExpressionType {
    VARIABLE("VARIABLE"),
    TRACKED_ENTITY_ATTRIBUTE("TRACKED_ENTITY_ATTRIBUTE"),
    DATA_ELEMENT("DATA_ELEMENT");

    private final String value;
    private static final Map<String, ExpressionType> CONSTANTS;

    private ExpressionType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static ExpressionType fromValue(String value) {
        ExpressionType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ExpressionType>();
        for (ExpressionType c : ExpressionType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

