/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_38_1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum MatchMode {
    EXACT("EXACT"),
    START("START"),
    END("END"),
    ANYWHERE("ANYWHERE");

    private final String value;
    private static final Map<String, MatchMode> CONSTANTS;

    private MatchMode(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static MatchMode fromValue(String value) {
        MatchMode constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, MatchMode>();
        for (MatchMode c : MatchMode.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

