/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_38_1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum QueryOperator {
    EQ("EQ"),
    GT("GT"),
    GE("GE"),
    LT("LT"),
    LE("LE"),
    LIKE("LIKE"),
    IN("IN"),
    SW("SW"),
    EW("EW"),
    IEQ("IEQ"),
    NE("NE"),
    NEQ("NEQ"),
    NIEQ("NIEQ"),
    NLIKE("NLIKE"),
    ILIKE("ILIKE"),
    NILIKE("NILIKE");

    private final String value;
    private static final Map<String, QueryOperator> CONSTANTS;

    private QueryOperator(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static QueryOperator fromValue(String value) {
        QueryOperator constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, QueryOperator>();
        for (QueryOperator c : QueryOperator.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

