/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_38_1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum TimeField {
    EVENT_DATE("EVENT_DATE"),
    ENROLLMENT_DATE("ENROLLMENT_DATE"),
    INCIDENT_DATE("INCIDENT_DATE"),
    SCHEDULED_DATE("SCHEDULED_DATE"),
    COMPLETED_DATE("COMPLETED_DATE"),
    CREATED("CREATED"),
    LAST_UPDATED("LAST_UPDATED");

    private final String value;
    private static final Map<String, TimeField> CONSTANTS;

    private TimeField(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static TimeField fromValue(String value) {
        TimeField constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, TimeField>();
        for (TimeField c : TimeField.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

