/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_38_1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum UserSettingKey {
    STYLE("STYLE"),
    MESSAGE_EMAIL_NOTIFICATION("MESSAGE_EMAIL_NOTIFICATION"),
    MESSAGE_SMS_NOTIFICATION("MESSAGE_SMS_NOTIFICATION"),
    UI_LOCALE("UI_LOCALE"),
    DB_LOCALE("DB_LOCALE"),
    ANALYSIS_DISPLAY_PROPERTY("ANALYSIS_DISPLAY_PROPERTY"),
    TRACKER_DASHBOARD_LAYOUT("TRACKER_DASHBOARD_LAYOUT");

    private final String value;
    private static final Map<String, UserSettingKey> CONSTANTS;

    private UserSettingKey(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static UserSettingKey fromValue(String value) {
        UserSettingKey constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, UserSettingKey>();
        for (UserSettingKey c : UserSettingKey.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

