/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_39_1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum Type {
    EVENT_DATE("EVENT_DATE"),
    ENROLLMENT_DATE("ENROLLMENT_DATE"),
    INCIDENT_DATE("INCIDENT_DATE"),
    SCHEDULE_DATE("SCHEDULE_DATE"),
    LAST_UPDATE_DATE("LAST_UPDATE_DATE"),
    EVENT_STATUS("EVENT_STATUS"),
    PROGRAM_STATUS("PROGRAM_STATUS"),
    CREATED_BY("CREATED_BY"),
    LAST_UPDATED_BY("LAST_UPDATED_BY");

    private final String value;
    private static final Map<String, Type> CONSTANTS;

    private Type(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static Type fromValue(String value) {
        Type constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, Type>();
        for (Type c : Type.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

