/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v40_0;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.hisp.dhis.api.model.v40_0.DataApprovalPermissions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"aoc", "level", "ou", "ouName", "pe", "permissions", "state", "wf"})
public class ApprovalStatusDto
implements Serializable {
    @JsonProperty(value="aoc")
    @JsonPropertyDescription(value="A UID for an CategoryOptionCombo object  \n(Java name `org.hisp.dhis.category.CategoryOptionCombo`)")
    private String aoc;
    @JsonProperty(value="level")
    private String level;
    @JsonProperty(value="ou")
    @JsonPropertyDescription(value="A UID for an OrganisationUnit object  \n(Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)")
    private String ou;
    @JsonProperty(value="ouName")
    private String ouName;
    @JsonProperty(value="pe")
    private String pe;
    @JsonProperty(value="permissions")
    private DataApprovalPermissions permissions;
    @JsonProperty(value="state")
    private State state;
    @JsonProperty(value="wf")
    @JsonPropertyDescription(value="A UID for an DataApprovalWorkflow object  \n(Java name `org.hisp.dhis.dataapproval.DataApprovalWorkflow`)")
    private String wf;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected static final Object NOT_FOUND_VALUE = new Object();
    private static final long serialVersionUID = -5813058425260907255L;

    public ApprovalStatusDto() {
    }

    public ApprovalStatusDto(ApprovalStatusDto source) {
        this.aoc = source.aoc;
        this.level = source.level;
        this.ou = source.ou;
        this.ouName = source.ouName;
        this.pe = source.pe;
        this.permissions = source.permissions;
        this.state = source.state;
        this.wf = source.wf;
    }

    public ApprovalStatusDto(String aoc, String level, String ou, String ouName, String pe, DataApprovalPermissions permissions, State state, String wf) {
        this.aoc = aoc;
        this.level = level;
        this.ou = ou;
        this.ouName = ouName;
        this.pe = pe;
        this.permissions = permissions;
        this.state = state;
        this.wf = wf;
    }

    @JsonProperty(value="aoc")
    public Optional<String> getAoc() {
        return Optional.ofNullable(this.aoc);
    }

    @JsonProperty(value="aoc")
    public void setAoc(String aoc) {
        this.aoc = aoc;
    }

    public ApprovalStatusDto withAoc(String aoc) {
        this.aoc = aoc;
        return this;
    }

    @JsonProperty(value="level")
    public Optional<String> getLevel() {
        return Optional.ofNullable(this.level);
    }

    @JsonProperty(value="level")
    public void setLevel(String level) {
        this.level = level;
    }

    public ApprovalStatusDto withLevel(String level) {
        this.level = level;
        return this;
    }

    @JsonProperty(value="ou")
    public Optional<String> getOu() {
        return Optional.ofNullable(this.ou);
    }

    @JsonProperty(value="ou")
    public void setOu(String ou) {
        this.ou = ou;
    }

    public ApprovalStatusDto withOu(String ou) {
        this.ou = ou;
        return this;
    }

    @JsonProperty(value="ouName")
    public Optional<String> getOuName() {
        return Optional.ofNullable(this.ouName);
    }

    @JsonProperty(value="ouName")
    public void setOuName(String ouName) {
        this.ouName = ouName;
    }

    public ApprovalStatusDto withOuName(String ouName) {
        this.ouName = ouName;
        return this;
    }

    @JsonProperty(value="pe")
    public Optional<String> getPe() {
        return Optional.ofNullable(this.pe);
    }

    @JsonProperty(value="pe")
    public void setPe(String pe) {
        this.pe = pe;
    }

    public ApprovalStatusDto withPe(String pe) {
        this.pe = pe;
        return this;
    }

    @JsonProperty(value="permissions")
    public Optional<DataApprovalPermissions> getPermissions() {
        return Optional.ofNullable(this.permissions);
    }

    @JsonProperty(value="permissions")
    public void setPermissions(DataApprovalPermissions permissions) {
        this.permissions = permissions;
    }

    public ApprovalStatusDto withPermissions(DataApprovalPermissions permissions) {
        this.permissions = permissions;
        return this;
    }

    @JsonProperty(value="state")
    public State getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    public void setState(State state) {
        this.state = state;
    }

    public ApprovalStatusDto withState(State state) {
        this.state = state;
        return this;
    }

    @JsonProperty(value="wf")
    public Optional<String> getWf() {
        return Optional.ofNullable(this.wf);
    }

    @JsonProperty(value="wf")
    public void setWf(String wf) {
        this.wf = wf;
    }

    public ApprovalStatusDto withWf(String wf) {
        this.wf = wf;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ApprovalStatusDto withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("aoc".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"aoc\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setAoc((String)value);
            return true;
        }
        if ("level".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"level\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setLevel((String)value);
            return true;
        }
        if ("ou".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"ou\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setOu((String)value);
            return true;
        }
        if ("ouName".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"ouName\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setOuName((String)value);
            return true;
        }
        if ("pe".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"pe\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setPe((String)value);
            return true;
        }
        if ("permissions".equals(name)) {
            if (!(value instanceof DataApprovalPermissions)) {
                throw new IllegalArgumentException("property \"permissions\" is of type \"org.hisp.dhis.api.model.v40_0.DataApprovalPermissions\", but got " + value.getClass().toString());
            }
            this.setPermissions((DataApprovalPermissions)value);
            return true;
        }
        if ("state".equals(name)) {
            if (!(value instanceof State)) {
                throw new IllegalArgumentException("property \"state\" is of type \"org.hisp.dhis.api.model.v40_0.ApprovalStatusDto.State\", but got " + value.getClass().toString());
            }
            this.setState((State)((Object)value));
            return true;
        }
        if ("wf".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"wf\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setWf((String)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("aoc".equals(name)) {
            return this.getAoc();
        }
        if ("level".equals(name)) {
            return this.getLevel();
        }
        if ("ou".equals(name)) {
            return this.getOu();
        }
        if ("ouName".equals(name)) {
            return this.getOuName();
        }
        if ("pe".equals(name)) {
            return this.getPe();
        }
        if ("permissions".equals(name)) {
            return this.getPermissions();
        }
        if ("state".equals(name)) {
            return this.getState();
        }
        if ("wf".equals(name)) {
            return this.getWf();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        return (T)this.getAdditionalProperties().get(name);
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
    }

    public ApprovalStatusDto with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApprovalStatusDto.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("aoc");
        sb.append('=');
        sb.append(this.aoc == null ? "<null>" : this.aoc);
        sb.append(',');
        sb.append("level");
        sb.append('=');
        sb.append(this.level == null ? "<null>" : this.level);
        sb.append(',');
        sb.append("ou");
        sb.append('=');
        sb.append(this.ou == null ? "<null>" : this.ou);
        sb.append(',');
        sb.append("ouName");
        sb.append('=');
        sb.append(this.ouName == null ? "<null>" : this.ouName);
        sb.append(',');
        sb.append("pe");
        sb.append('=');
        sb.append(this.pe == null ? "<null>" : this.pe);
        sb.append(',');
        sb.append("permissions");
        sb.append('=');
        sb.append(this.permissions == null ? "<null>" : this.permissions);
        sb.append(',');
        sb.append("state");
        sb.append('=');
        sb.append(this.state == null ? "<null>" : this.state);
        sb.append(',');
        sb.append("wf");
        sb.append('=');
        sb.append(this.wf == null ? "<null>" : this.wf);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.aoc == null ? 0 : this.aoc.hashCode());
        result = result * 31 + (this.level == null ? 0 : this.level.hashCode());
        result = result * 31 + (this.pe == null ? 0 : this.pe.hashCode());
        result = result * 31 + (this.ou == null ? 0 : this.ou.hashCode());
        result = result * 31 + (this.permissions == null ? 0 : this.permissions.hashCode());
        result = result * 31 + (this.state == null ? 0 : this.state.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.ouName == null ? 0 : this.ouName.hashCode());
        result = result * 31 + (this.wf == null ? 0 : this.wf.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApprovalStatusDto)) {
            return false;
        }
        ApprovalStatusDto rhs = (ApprovalStatusDto)other;
        return (this.aoc == rhs.aoc || this.aoc != null && this.aoc.equals(rhs.aoc)) && (this.level == rhs.level || this.level != null && this.level.equals(rhs.level)) && (this.pe == rhs.pe || this.pe != null && this.pe.equals(rhs.pe)) && (this.ou == rhs.ou || this.ou != null && this.ou.equals(rhs.ou)) && (this.permissions == rhs.permissions || this.permissions != null && this.permissions.equals(rhs.permissions)) && (this.state == rhs.state || this.state != null && this.state.equals((Object)rhs.state)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.ouName == rhs.ouName || this.ouName != null && this.ouName.equals(rhs.ouName)) && (this.wf == rhs.wf || this.wf != null && this.wf.equals(rhs.wf));
    }

    public static enum State {
        UNAPPROVABLE("UNAPPROVABLE"),
        UNAPPROVED_ABOVE("UNAPPROVED_ABOVE"),
        UNAPPROVED_WAITING("UNAPPROVED_WAITING"),
        UNAPPROVED_READY("UNAPPROVED_READY"),
        APPROVED_ABOVE("APPROVED_ABOVE"),
        APPROVED_HERE("APPROVED_HERE"),
        ACCEPTED_HERE("ACCEPTED_HERE");

        private final String value;
        private static final Map<String, State> CONSTANTS;

        private State(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static State fromValue(String value) {
            State constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, State>();
            for (State c : State.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

