/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v40_0;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"attribute", "code", "created", "displayName", "lastUpdated", "storedBy", "value", "valueType"})
public class Dxf2EventsTrackedentityAttribute
implements Serializable {
    @JsonProperty(value="attribute")
    private String attribute;
    @JsonProperty(value="code")
    private String code;
    @JsonProperty(value="created")
    private String created;
    @JsonProperty(value="displayName")
    private String displayName;
    @JsonProperty(value="lastUpdated")
    private String lastUpdated;
    @JsonProperty(value="storedBy")
    private String storedBy;
    @JsonProperty(value="value")
    private String value;
    @JsonProperty(value="valueType")
    private ValueType valueType;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected static final Object NOT_FOUND_VALUE = new Object();
    private static final long serialVersionUID = 1968666787895511864L;

    public Dxf2EventsTrackedentityAttribute() {
    }

    public Dxf2EventsTrackedentityAttribute(Dxf2EventsTrackedentityAttribute source) {
        this.attribute = source.attribute;
        this.code = source.code;
        this.created = source.created;
        this.displayName = source.displayName;
        this.lastUpdated = source.lastUpdated;
        this.storedBy = source.storedBy;
        this.value = source.value;
        this.valueType = source.valueType;
    }

    public Dxf2EventsTrackedentityAttribute(String attribute, String code, String created, String displayName, String lastUpdated, String storedBy, String value, ValueType valueType) {
        this.attribute = attribute;
        this.code = code;
        this.created = created;
        this.displayName = displayName;
        this.lastUpdated = lastUpdated;
        this.storedBy = storedBy;
        this.value = value;
        this.valueType = valueType;
    }

    @JsonProperty(value="attribute")
    public Optional<String> getAttribute() {
        return Optional.ofNullable(this.attribute);
    }

    @JsonProperty(value="attribute")
    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public Dxf2EventsTrackedentityAttribute withAttribute(String attribute) {
        this.attribute = attribute;
        return this;
    }

    @JsonProperty(value="code")
    public Optional<String> getCode() {
        return Optional.ofNullable(this.code);
    }

    @JsonProperty(value="code")
    public void setCode(String code) {
        this.code = code;
    }

    public Dxf2EventsTrackedentityAttribute withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty(value="created")
    public Optional<String> getCreated() {
        return Optional.ofNullable(this.created);
    }

    @JsonProperty(value="created")
    public void setCreated(String created) {
        this.created = created;
    }

    public Dxf2EventsTrackedentityAttribute withCreated(String created) {
        this.created = created;
        return this;
    }

    @JsonProperty(value="displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(this.displayName);
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Dxf2EventsTrackedentityAttribute withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty(value="lastUpdated")
    public Optional<String> getLastUpdated() {
        return Optional.ofNullable(this.lastUpdated);
    }

    @JsonProperty(value="lastUpdated")
    public void setLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public Dxf2EventsTrackedentityAttribute withLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty(value="storedBy")
    public Optional<String> getStoredBy() {
        return Optional.ofNullable(this.storedBy);
    }

    @JsonProperty(value="storedBy")
    public void setStoredBy(String storedBy) {
        this.storedBy = storedBy;
    }

    public Dxf2EventsTrackedentityAttribute withStoredBy(String storedBy) {
        this.storedBy = storedBy;
        return this;
    }

    @JsonProperty(value="value")
    public Optional<String> getValue() {
        return Optional.ofNullable(this.value);
    }

    @JsonProperty(value="value")
    public void setValue(String value) {
        this.value = value;
    }

    public Dxf2EventsTrackedentityAttribute withValue(String value) {
        this.value = value;
        return this;
    }

    @JsonProperty(value="valueType")
    public ValueType getValueType() {
        return this.valueType;
    }

    @JsonProperty(value="valueType")
    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    public Dxf2EventsTrackedentityAttribute withValueType(ValueType valueType) {
        this.valueType = valueType;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Dxf2EventsTrackedentityAttribute withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("attribute".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"attribute\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setAttribute((String)value);
            return true;
        }
        if ("code".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"code\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setCode((String)value);
            return true;
        }
        if ("created".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"created\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setCreated((String)value);
            return true;
        }
        if ("displayName".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"displayName\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setDisplayName((String)value);
            return true;
        }
        if ("lastUpdated".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"lastUpdated\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setLastUpdated((String)value);
            return true;
        }
        if ("storedBy".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"storedBy\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setStoredBy((String)value);
            return true;
        }
        if ("value".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"value\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setValue((String)value);
            return true;
        }
        if ("valueType".equals(name)) {
            if (!(value instanceof ValueType)) {
                throw new IllegalArgumentException("property \"valueType\" is of type \"org.hisp.dhis.api.model.v40_0.Dxf2EventsTrackedentityAttribute.ValueType\", but got " + value.getClass().toString());
            }
            this.setValueType((ValueType)((Object)value));
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("attribute".equals(name)) {
            return this.getAttribute();
        }
        if ("code".equals(name)) {
            return this.getCode();
        }
        if ("created".equals(name)) {
            return this.getCreated();
        }
        if ("displayName".equals(name)) {
            return this.getDisplayName();
        }
        if ("lastUpdated".equals(name)) {
            return this.getLastUpdated();
        }
        if ("storedBy".equals(name)) {
            return this.getStoredBy();
        }
        if ("value".equals(name)) {
            return this.getValue();
        }
        if ("valueType".equals(name)) {
            return this.getValueType();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        return (T)this.getAdditionalProperties().get(name);
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
    }

    public Dxf2EventsTrackedentityAttribute with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Dxf2EventsTrackedentityAttribute.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("attribute");
        sb.append('=');
        sb.append(this.attribute == null ? "<null>" : this.attribute);
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(this.code == null ? "<null>" : this.code);
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(this.created == null ? "<null>" : this.created);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(this.lastUpdated == null ? "<null>" : this.lastUpdated);
        sb.append(',');
        sb.append("storedBy");
        sb.append('=');
        sb.append(this.storedBy == null ? "<null>" : this.storedBy);
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(this.value == null ? "<null>" : this.value);
        sb.append(',');
        sb.append("valueType");
        sb.append('=');
        sb.append(this.valueType == null ? "<null>" : this.valueType);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.lastUpdated == null ? 0 : this.lastUpdated.hashCode());
        result = result * 31 + (this.code == null ? 0 : this.code.hashCode());
        result = result * 31 + (this.storedBy == null ? 0 : this.storedBy.hashCode());
        result = result * 31 + (this.created == null ? 0 : this.created.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.valueType == null ? 0 : this.valueType.hashCode());
        result = result * 31 + (this.attribute == null ? 0 : this.attribute.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Dxf2EventsTrackedentityAttribute)) {
            return false;
        }
        Dxf2EventsTrackedentityAttribute rhs = (Dxf2EventsTrackedentityAttribute)other;
        return (this.lastUpdated == rhs.lastUpdated || this.lastUpdated != null && this.lastUpdated.equals(rhs.lastUpdated)) && (this.code == rhs.code || this.code != null && this.code.equals(rhs.code)) && (this.storedBy == rhs.storedBy || this.storedBy != null && this.storedBy.equals(rhs.storedBy)) && (this.created == rhs.created || this.created != null && this.created.equals(rhs.created)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.valueType == rhs.valueType || this.valueType != null && this.valueType.equals((Object)rhs.valueType)) && (this.attribute == rhs.attribute || this.attribute != null && this.attribute.equals(rhs.attribute)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.value == rhs.value || this.value != null && this.value.equals(rhs.value));
    }

    public static enum ValueType {
        TEXT("TEXT"),
        LONG_TEXT("LONG_TEXT"),
        MULTI_TEXT("MULTI_TEXT"),
        LETTER("LETTER"),
        PHONE_NUMBER("PHONE_NUMBER"),
        EMAIL("EMAIL"),
        BOOLEAN("BOOLEAN"),
        TRUE_ONLY("TRUE_ONLY"),
        DATE("DATE"),
        DATETIME("DATETIME"),
        TIME("TIME"),
        NUMBER("NUMBER"),
        UNIT_INTERVAL("UNIT_INTERVAL"),
        PERCENTAGE("PERCENTAGE"),
        INTEGER("INTEGER"),
        INTEGER_POSITIVE("INTEGER_POSITIVE"),
        INTEGER_NEGATIVE("INTEGER_NEGATIVE"),
        INTEGER_ZERO_OR_POSITIVE("INTEGER_ZERO_OR_POSITIVE"),
        TRACKER_ASSOCIATE("TRACKER_ASSOCIATE"),
        USERNAME("USERNAME"),
        COORDINATE("COORDINATE"),
        ORGANISATION_UNIT("ORGANISATION_UNIT"),
        REFERENCE("REFERENCE"),
        AGE("AGE"),
        URL("URL"),
        FILE_RESOURCE("FILE_RESOURCE"),
        IMAGE("IMAGE"),
        GEOJSON("GEOJSON");

        private final String value;
        private static final Map<String, ValueType> CONSTANTS;

        private ValueType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ValueType fromValue(String value) {
            ValueType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ValueType>();
            for (ValueType c : ValueType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

