/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v40_0;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"aggregationType", "maxDate", "minDate", "periodOffset", "subExpression", "valueType", "yearToDate"})
public class QueryModifiers
implements Serializable {
    @JsonProperty(value="aggregationType")
    private AggregationType aggregationType;
    @JsonProperty(value="maxDate")
    private Date maxDate;
    @JsonProperty(value="minDate")
    private Date minDate;
    @JsonProperty(value="periodOffset")
    private Integer periodOffset;
    @JsonProperty(value="subExpression")
    private String subExpression;
    @JsonProperty(value="valueType")
    private ValueType valueType;
    @JsonProperty(value="yearToDate")
    private Boolean yearToDate;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected static final Object NOT_FOUND_VALUE = new Object();
    private static final long serialVersionUID = -1595011996633304417L;

    public QueryModifiers() {
    }

    public QueryModifiers(QueryModifiers source) {
        this.aggregationType = source.aggregationType;
        this.maxDate = source.maxDate;
        this.minDate = source.minDate;
        this.periodOffset = source.periodOffset;
        this.subExpression = source.subExpression;
        this.valueType = source.valueType;
        this.yearToDate = source.yearToDate;
    }

    public QueryModifiers(AggregationType aggregationType, Date maxDate, Date minDate, Integer periodOffset, String subExpression, ValueType valueType, Boolean yearToDate) {
        this.aggregationType = aggregationType;
        this.maxDate = maxDate;
        this.minDate = minDate;
        this.periodOffset = periodOffset;
        this.subExpression = subExpression;
        this.valueType = valueType;
        this.yearToDate = yearToDate;
    }

    @JsonProperty(value="aggregationType")
    public AggregationType getAggregationType() {
        return this.aggregationType;
    }

    @JsonProperty(value="aggregationType")
    public void setAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
    }

    public QueryModifiers withAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
        return this;
    }

    @JsonProperty(value="maxDate")
    public Optional<Date> getMaxDate() {
        return Optional.ofNullable(this.maxDate);
    }

    @JsonProperty(value="maxDate")
    public void setMaxDate(Date maxDate) {
        this.maxDate = maxDate;
    }

    public QueryModifiers withMaxDate(Date maxDate) {
        this.maxDate = maxDate;
        return this;
    }

    @JsonProperty(value="minDate")
    public Optional<Date> getMinDate() {
        return Optional.ofNullable(this.minDate);
    }

    @JsonProperty(value="minDate")
    public void setMinDate(Date minDate) {
        this.minDate = minDate;
    }

    public QueryModifiers withMinDate(Date minDate) {
        this.minDate = minDate;
        return this;
    }

    @JsonProperty(value="periodOffset")
    public Integer getPeriodOffset() {
        return this.periodOffset;
    }

    @JsonProperty(value="periodOffset")
    public void setPeriodOffset(Integer periodOffset) {
        this.periodOffset = periodOffset;
    }

    public QueryModifiers withPeriodOffset(Integer periodOffset) {
        this.periodOffset = periodOffset;
        return this;
    }

    @JsonProperty(value="subExpression")
    public Optional<String> getSubExpression() {
        return Optional.ofNullable(this.subExpression);
    }

    @JsonProperty(value="subExpression")
    public void setSubExpression(String subExpression) {
        this.subExpression = subExpression;
    }

    public QueryModifiers withSubExpression(String subExpression) {
        this.subExpression = subExpression;
        return this;
    }

    @JsonProperty(value="valueType")
    public ValueType getValueType() {
        return this.valueType;
    }

    @JsonProperty(value="valueType")
    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    public QueryModifiers withValueType(ValueType valueType) {
        this.valueType = valueType;
        return this;
    }

    @JsonProperty(value="yearToDate")
    public Boolean getYearToDate() {
        return this.yearToDate;
    }

    @JsonProperty(value="yearToDate")
    public void setYearToDate(Boolean yearToDate) {
        this.yearToDate = yearToDate;
    }

    public QueryModifiers withYearToDate(Boolean yearToDate) {
        this.yearToDate = yearToDate;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public QueryModifiers withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("aggregationType".equals(name)) {
            if (!(value instanceof AggregationType)) {
                throw new IllegalArgumentException("property \"aggregationType\" is of type \"org.hisp.dhis.api.model.v40_0.QueryModifiers.AggregationType\", but got " + value.getClass().toString());
            }
            this.setAggregationType((AggregationType)((Object)value));
            return true;
        }
        if ("maxDate".equals(name)) {
            if (!(value instanceof Date)) {
                throw new IllegalArgumentException("property \"maxDate\" is of type \"java.util.Date\", but got " + value.getClass().toString());
            }
            this.setMaxDate((Date)value);
            return true;
        }
        if ("minDate".equals(name)) {
            if (!(value instanceof Date)) {
                throw new IllegalArgumentException("property \"minDate\" is of type \"java.util.Date\", but got " + value.getClass().toString());
            }
            this.setMinDate((Date)value);
            return true;
        }
        if ("periodOffset".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"periodOffset\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setPeriodOffset((Integer)value);
            return true;
        }
        if ("subExpression".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"subExpression\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setSubExpression((String)value);
            return true;
        }
        if ("valueType".equals(name)) {
            if (!(value instanceof ValueType)) {
                throw new IllegalArgumentException("property \"valueType\" is of type \"org.hisp.dhis.api.model.v40_0.QueryModifiers.ValueType\", but got " + value.getClass().toString());
            }
            this.setValueType((ValueType)((Object)value));
            return true;
        }
        if ("yearToDate".equals(name)) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("property \"yearToDate\" is of type \"java.lang.Boolean\", but got " + value.getClass().toString());
            }
            this.setYearToDate((Boolean)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("aggregationType".equals(name)) {
            return this.getAggregationType();
        }
        if ("maxDate".equals(name)) {
            return this.getMaxDate();
        }
        if ("minDate".equals(name)) {
            return this.getMinDate();
        }
        if ("periodOffset".equals(name)) {
            return this.getPeriodOffset();
        }
        if ("subExpression".equals(name)) {
            return this.getSubExpression();
        }
        if ("valueType".equals(name)) {
            return this.getValueType();
        }
        if ("yearToDate".equals(name)) {
            return this.getYearToDate();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        return (T)this.getAdditionalProperties().get(name);
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
    }

    public QueryModifiers with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(QueryModifiers.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("aggregationType");
        sb.append('=');
        sb.append(this.aggregationType == null ? "<null>" : this.aggregationType);
        sb.append(',');
        sb.append("maxDate");
        sb.append('=');
        sb.append(this.maxDate == null ? "<null>" : this.maxDate);
        sb.append(',');
        sb.append("minDate");
        sb.append('=');
        sb.append(this.minDate == null ? "<null>" : this.minDate);
        sb.append(',');
        sb.append("periodOffset");
        sb.append('=');
        sb.append(this.periodOffset == null ? "<null>" : this.periodOffset);
        sb.append(',');
        sb.append("subExpression");
        sb.append('=');
        sb.append(this.subExpression == null ? "<null>" : this.subExpression);
        sb.append(',');
        sb.append("valueType");
        sb.append('=');
        sb.append(this.valueType == null ? "<null>" : this.valueType);
        sb.append(',');
        sb.append("yearToDate");
        sb.append('=');
        sb.append(this.yearToDate == null ? "<null>" : this.yearToDate);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.aggregationType == null ? 0 : this.aggregationType.hashCode());
        result = result * 31 + (this.minDate == null ? 0 : this.minDate.hashCode());
        result = result * 31 + (this.periodOffset == null ? 0 : this.periodOffset.hashCode());
        result = result * 31 + (this.yearToDate == null ? 0 : this.yearToDate.hashCode());
        result = result * 31 + (this.valueType == null ? 0 : this.valueType.hashCode());
        result = result * 31 + (this.maxDate == null ? 0 : this.maxDate.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.subExpression == null ? 0 : this.subExpression.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof QueryModifiers)) {
            return false;
        }
        QueryModifiers rhs = (QueryModifiers)other;
        return (this.aggregationType == rhs.aggregationType || this.aggregationType != null && this.aggregationType.equals((Object)rhs.aggregationType)) && (this.minDate == rhs.minDate || this.minDate != null && this.minDate.equals(rhs.minDate)) && (this.periodOffset == rhs.periodOffset || this.periodOffset != null && this.periodOffset.equals(rhs.periodOffset)) && (this.yearToDate == rhs.yearToDate || this.yearToDate != null && this.yearToDate.equals(rhs.yearToDate)) && (this.valueType == rhs.valueType || this.valueType != null && this.valueType.equals((Object)rhs.valueType)) && (this.maxDate == rhs.maxDate || this.maxDate != null && this.maxDate.equals(rhs.maxDate)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.subExpression == rhs.subExpression || this.subExpression != null && this.subExpression.equals(rhs.subExpression));
    }

    public static enum ValueType {
        TEXT("TEXT"),
        LONG_TEXT("LONG_TEXT"),
        MULTI_TEXT("MULTI_TEXT"),
        LETTER("LETTER"),
        PHONE_NUMBER("PHONE_NUMBER"),
        EMAIL("EMAIL"),
        BOOLEAN("BOOLEAN"),
        TRUE_ONLY("TRUE_ONLY"),
        DATE("DATE"),
        DATETIME("DATETIME"),
        TIME("TIME"),
        NUMBER("NUMBER"),
        UNIT_INTERVAL("UNIT_INTERVAL"),
        PERCENTAGE("PERCENTAGE"),
        INTEGER("INTEGER"),
        INTEGER_POSITIVE("INTEGER_POSITIVE"),
        INTEGER_NEGATIVE("INTEGER_NEGATIVE"),
        INTEGER_ZERO_OR_POSITIVE("INTEGER_ZERO_OR_POSITIVE"),
        TRACKER_ASSOCIATE("TRACKER_ASSOCIATE"),
        USERNAME("USERNAME"),
        COORDINATE("COORDINATE"),
        ORGANISATION_UNIT("ORGANISATION_UNIT"),
        REFERENCE("REFERENCE"),
        AGE("AGE"),
        URL("URL"),
        FILE_RESOURCE("FILE_RESOURCE"),
        IMAGE("IMAGE"),
        GEOJSON("GEOJSON");

        private final String value;
        private static final Map<String, ValueType> CONSTANTS;

        private ValueType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ValueType fromValue(String value) {
            ValueType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ValueType>();
            for (ValueType c : ValueType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum AggregationType {
        SUM("SUM"),
        AVERAGE("AVERAGE"),
        AVERAGE_SUM_ORG_UNIT("AVERAGE_SUM_ORG_UNIT"),
        LAST("LAST"),
        LAST_AVERAGE_ORG_UNIT("LAST_AVERAGE_ORG_UNIT"),
        LAST_LAST_ORG_UNIT("LAST_LAST_ORG_UNIT"),
        LAST_IN_PERIOD("LAST_IN_PERIOD"),
        LAST_IN_PERIOD_AVERAGE_ORG_UNIT("LAST_IN_PERIOD_AVERAGE_ORG_UNIT"),
        FIRST("FIRST"),
        FIRST_AVERAGE_ORG_UNIT("FIRST_AVERAGE_ORG_UNIT"),
        FIRST_FIRST_ORG_UNIT("FIRST_FIRST_ORG_UNIT"),
        COUNT("COUNT"),
        STDDEV("STDDEV"),
        VARIANCE("VARIANCE"),
        MIN("MIN"),
        MAX("MAX"),
        MIN_SUM_ORG_UNIT("MIN_SUM_ORG_UNIT"),
        MAX_SUM_ORG_UNIT("MAX_SUM_ORG_UNIT"),
        NONE("NONE"),
        CUSTOM("CUSTOM"),
        DEFAULT("DEFAULT");

        private final String value;
        private static final Map<String, AggregationType> CONSTANTS;

        private AggregationType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AggregationType fromValue(String value) {
            AggregationType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, AggregationType>();
            for (AggregationType c : AggregationType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

