/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v40_0;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.hisp.dhis.api.model.v40_0.Api;
import org.hisp.dhis.api.model.v40_0.TargetRequest;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"api", "request", "type"})
public class Target
implements Serializable {
    @JsonProperty(value="api")
    private Api api;
    @JsonProperty(value="request")
    private TargetRequest request;
    @JsonProperty(value="type")
    private Type type;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected static final Object NOT_FOUND_VALUE = new Object();
    private static final long serialVersionUID = -3008446554621335779L;

    public Target() {
    }

    public Target(Target source) {
        this.api = source.api;
        this.request = source.request;
        this.type = source.type;
    }

    public Target(Api api, TargetRequest request, Type type) {
        this.api = api;
        this.request = request;
        this.type = type;
    }

    @JsonProperty(value="api")
    public Optional<Api> getApi() {
        return Optional.ofNullable(this.api);
    }

    @JsonProperty(value="api")
    public void setApi(Api api) {
        this.api = api;
    }

    public Target withApi(Api api) {
        this.api = api;
        return this;
    }

    @JsonProperty(value="request")
    public Optional<TargetRequest> getRequest() {
        return Optional.ofNullable(this.request);
    }

    @JsonProperty(value="request")
    public void setRequest(TargetRequest request) {
        this.request = request;
    }

    public Target withRequest(TargetRequest request) {
        this.request = request;
        return this;
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(Type type) {
        this.type = type;
    }

    public Target withType(Type type) {
        this.type = type;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Target withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("api".equals(name)) {
            if (!(value instanceof Api)) {
                throw new IllegalArgumentException("property \"api\" is of type \"org.hisp.dhis.api.model.v40_0.Api\", but got " + value.getClass().toString());
            }
            this.setApi((Api)value);
            return true;
        }
        if ("request".equals(name)) {
            if (!(value instanceof TargetRequest)) {
                throw new IllegalArgumentException("property \"request\" is of type \"org.hisp.dhis.api.model.v40_0.TargetRequest\", but got " + value.getClass().toString());
            }
            this.setRequest((TargetRequest)value);
            return true;
        }
        if ("type".equals(name)) {
            if (!(value instanceof Type)) {
                throw new IllegalArgumentException("property \"type\" is of type \"org.hisp.dhis.api.model.v40_0.Target.Type\", but got " + value.getClass().toString());
            }
            this.setType((Type)((Object)value));
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("api".equals(name)) {
            return this.getApi();
        }
        if ("request".equals(name)) {
            return this.getRequest();
        }
        if ("type".equals(name)) {
            return this.getType();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        return (T)this.getAdditionalProperties().get(name);
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
    }

    public Target with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Target.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("api");
        sb.append('=');
        sb.append(this.api == null ? "<null>" : this.api);
        sb.append(',');
        sb.append("request");
        sb.append('=');
        sb.append(this.request == null ? "<null>" : this.request);
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.request == null ? 0 : this.request.hashCode());
        result = result * 31 + (this.api == null ? 0 : this.api.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Target)) {
            return false;
        }
        Target rhs = (Target)other;
        return (this.request == rhs.request || this.request != null && this.request.equals(rhs.request)) && (this.api == rhs.api || this.api != null && this.api.equals(rhs.api)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type));
    }

    public static enum Type {
        INTERNAL("INTERNAL"),
        EXTERNAL("EXTERNAL");

        private final String value;
        private static final Map<String, Type> CONSTANTS;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Type fromValue(String value) {
            Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Type>();
            for (Type c : Type.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

