/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v40_2_2;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.hisp.dhis.api.model.v40_2_2.PersistenceReport;
import org.hisp.dhis.api.model.v40_2_2.TimingsStats;
import org.hisp.dhis.api.model.v40_2_2.TrackerStats;
import org.hisp.dhis.api.model.v40_2_2.ValidationReport;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"bundleReport", "message", "stats", "status", "timingsStats", "validationReport"})
public class TrackerImportReport
implements Serializable {
    @JsonProperty(value="bundleReport")
    private PersistenceReport bundleReport;
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="stats")
    private TrackerStats stats;
    @JsonProperty(value="status")
    private StatusRef status;
    @JsonProperty(value="timingsStats")
    private TimingsStats timingsStats;
    @JsonProperty(value="validationReport")
    private ValidationReport validationReport;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected static final Object NOT_FOUND_VALUE = new Object();
    private static final long serialVersionUID = -5481629495930859206L;

    public TrackerImportReport() {
    }

    public TrackerImportReport(TrackerImportReport source) {
        this.bundleReport = source.bundleReport;
        this.message = source.message;
        this.stats = source.stats;
        this.status = source.status;
        this.timingsStats = source.timingsStats;
        this.validationReport = source.validationReport;
    }

    public TrackerImportReport(PersistenceReport bundleReport, String message, TrackerStats stats, StatusRef status, TimingsStats timingsStats, ValidationReport validationReport) {
        this.bundleReport = bundleReport;
        this.message = message;
        this.stats = stats;
        this.status = status;
        this.timingsStats = timingsStats;
        this.validationReport = validationReport;
    }

    @JsonProperty(value="bundleReport")
    public Optional<PersistenceReport> getBundleReport() {
        return Optional.ofNullable(this.bundleReport);
    }

    @JsonProperty(value="bundleReport")
    public void setBundleReport(PersistenceReport bundleReport) {
        this.bundleReport = bundleReport;
    }

    public TrackerImportReport withBundleReport(PersistenceReport bundleReport) {
        this.bundleReport = bundleReport;
        return this;
    }

    @JsonProperty(value="message")
    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    @JsonProperty(value="message")
    public void setMessage(String message) {
        this.message = message;
    }

    public TrackerImportReport withMessage(String message) {
        this.message = message;
        return this;
    }

    @JsonProperty(value="stats")
    public Optional<TrackerStats> getStats() {
        return Optional.ofNullable(this.stats);
    }

    @JsonProperty(value="stats")
    public void setStats(TrackerStats stats) {
        this.stats = stats;
    }

    public TrackerImportReport withStats(TrackerStats stats) {
        this.stats = stats;
        return this;
    }

    @JsonProperty(value="status")
    public StatusRef getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(StatusRef status) {
        this.status = status;
    }

    public TrackerImportReport withStatus(StatusRef status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="timingsStats")
    public Optional<TimingsStats> getTimingsStats() {
        return Optional.ofNullable(this.timingsStats);
    }

    @JsonProperty(value="timingsStats")
    public void setTimingsStats(TimingsStats timingsStats) {
        this.timingsStats = timingsStats;
    }

    public TrackerImportReport withTimingsStats(TimingsStats timingsStats) {
        this.timingsStats = timingsStats;
        return this;
    }

    @JsonProperty(value="validationReport")
    public Optional<ValidationReport> getValidationReport() {
        return Optional.ofNullable(this.validationReport);
    }

    @JsonProperty(value="validationReport")
    public void setValidationReport(ValidationReport validationReport) {
        this.validationReport = validationReport;
    }

    public TrackerImportReport withValidationReport(ValidationReport validationReport) {
        this.validationReport = validationReport;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackerImportReport withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("bundleReport".equals(name)) {
            if (!(value instanceof PersistenceReport)) {
                throw new IllegalArgumentException("property \"bundleReport\" is of type \"org.hisp.dhis.api.model.v40_2_2.PersistenceReport\", but got " + value.getClass().toString());
            }
            this.setBundleReport((PersistenceReport)value);
            return true;
        }
        if ("message".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"message\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setMessage((String)value);
            return true;
        }
        if ("stats".equals(name)) {
            if (!(value instanceof TrackerStats)) {
                throw new IllegalArgumentException("property \"stats\" is of type \"org.hisp.dhis.api.model.v40_2_2.TrackerStats\", but got " + value.getClass().toString());
            }
            this.setStats((TrackerStats)value);
            return true;
        }
        if ("status".equals(name)) {
            if (!(value instanceof StatusRef)) {
                throw new IllegalArgumentException("property \"status\" is of type \"org.hisp.dhis.api.model.v40_2_2.TrackerImportReport.StatusRef\", but got " + value.getClass().toString());
            }
            this.setStatus((StatusRef)((Object)value));
            return true;
        }
        if ("timingsStats".equals(name)) {
            if (!(value instanceof TimingsStats)) {
                throw new IllegalArgumentException("property \"timingsStats\" is of type \"org.hisp.dhis.api.model.v40_2_2.TimingsStats\", but got " + value.getClass().toString());
            }
            this.setTimingsStats((TimingsStats)value);
            return true;
        }
        if ("validationReport".equals(name)) {
            if (!(value instanceof ValidationReport)) {
                throw new IllegalArgumentException("property \"validationReport\" is of type \"org.hisp.dhis.api.model.v40_2_2.ValidationReport\", but got " + value.getClass().toString());
            }
            this.setValidationReport((ValidationReport)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("bundleReport".equals(name)) {
            return this.getBundleReport();
        }
        if ("message".equals(name)) {
            return this.getMessage();
        }
        if ("stats".equals(name)) {
            return this.getStats();
        }
        if ("status".equals(name)) {
            return this.getStatus();
        }
        if ("timingsStats".equals(name)) {
            return this.getTimingsStats();
        }
        if ("validationReport".equals(name)) {
            return this.getValidationReport();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        return (T)this.getAdditionalProperties().get(name);
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
    }

    public TrackerImportReport with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackerImportReport.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("bundleReport");
        sb.append('=');
        sb.append(this.bundleReport == null ? "<null>" : this.bundleReport);
        sb.append(',');
        sb.append("message");
        sb.append('=');
        sb.append(this.message == null ? "<null>" : this.message);
        sb.append(',');
        sb.append("stats");
        sb.append('=');
        sb.append(this.stats == null ? "<null>" : this.stats);
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(this.status == null ? "<null>" : this.status);
        sb.append(',');
        sb.append("timingsStats");
        sb.append('=');
        sb.append(this.timingsStats == null ? "<null>" : this.timingsStats);
        sb.append(',');
        sb.append("validationReport");
        sb.append('=');
        sb.append(this.validationReport == null ? "<null>" : this.validationReport);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.bundleReport == null ? 0 : this.bundleReport.hashCode());
        result = result * 31 + (this.stats == null ? 0 : this.stats.hashCode());
        result = result * 31 + (this.validationReport == null ? 0 : this.validationReport.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.message == null ? 0 : this.message.hashCode());
        result = result * 31 + (this.timingsStats == null ? 0 : this.timingsStats.hashCode());
        result = result * 31 + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TrackerImportReport)) {
            return false;
        }
        TrackerImportReport rhs = (TrackerImportReport)other;
        return (this.bundleReport == rhs.bundleReport || this.bundleReport != null && this.bundleReport.equals(rhs.bundleReport)) && (this.stats == rhs.stats || this.stats != null && this.stats.equals(rhs.stats)) && (this.validationReport == rhs.validationReport || this.validationReport != null && this.validationReport.equals(rhs.validationReport)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.message == rhs.message || this.message != null && this.message.equals(rhs.message)) && (this.timingsStats == rhs.timingsStats || this.timingsStats != null && this.timingsStats.equals(rhs.timingsStats)) && (this.status == rhs.status || this.status != null && this.status.equals((Object)rhs.status));
    }

    public static enum StatusRef {
        OK("OK"),
        WARNING("WARNING"),
        ERROR("ERROR");

        private final String value;
        private static final Map<String, StatusRef> CONSTANTS;

        private StatusRef(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static StatusRef fromValue(String value) {
            StatusRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, StatusRef>();
            for (StatusRef c : StatusRef.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

