/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_39_1;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"alias", "attribute", "name", "propertyPath", "transformation", "transformationArgument", "translate"})
public class Field
implements Serializable {
    @JsonProperty(value="alias")
    private String alias;
    @JsonProperty(value="attribute")
    private Boolean attribute;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="propertyPath")
    private String propertyPath;
    @JsonProperty(value="transformation")
    private Transform transformation;
    @JsonProperty(value="transformationArgument")
    private String transformationArgument;
    @JsonProperty(value="translate")
    private Boolean translate;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected static final Object NOT_FOUND_VALUE = new Object();
    private static final long serialVersionUID = -6521993928909487677L;

    public Field() {
    }

    public Field(Field source) {
        this.alias = source.alias;
        this.attribute = source.attribute;
        this.name = source.name;
        this.propertyPath = source.propertyPath;
        this.transformation = source.transformation;
        this.transformationArgument = source.transformationArgument;
        this.translate = source.translate;
    }

    public Field(String alias, Boolean attribute, String name, String propertyPath, Transform transformation, String transformationArgument, Boolean translate) {
        this.alias = alias;
        this.attribute = attribute;
        this.name = name;
        this.propertyPath = propertyPath;
        this.transformation = transformation;
        this.transformationArgument = transformationArgument;
        this.translate = translate;
    }

    @JsonProperty(value="alias")
    public Optional<String> getAlias() {
        return Optional.ofNullable(this.alias);
    }

    @JsonProperty(value="alias")
    public void setAlias(String alias) {
        this.alias = alias;
    }

    public Field withAlias(String alias) {
        this.alias = alias;
        return this;
    }

    @JsonProperty(value="attribute")
    public Optional<Boolean> getAttribute() {
        return Optional.ofNullable(this.attribute);
    }

    @JsonProperty(value="attribute")
    public void setAttribute(Boolean attribute) {
        this.attribute = attribute;
    }

    public Field withAttribute(Boolean attribute) {
        this.attribute = attribute;
        return this;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Field withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="propertyPath")
    public Optional<String> getPropertyPath() {
        return Optional.ofNullable(this.propertyPath);
    }

    @JsonProperty(value="propertyPath")
    public void setPropertyPath(String propertyPath) {
        this.propertyPath = propertyPath;
    }

    public Field withPropertyPath(String propertyPath) {
        this.propertyPath = propertyPath;
        return this;
    }

    @JsonProperty(value="transformation")
    public Optional<Transform> getTransformation() {
        return Optional.ofNullable(this.transformation);
    }

    @JsonProperty(value="transformation")
    public void setTransformation(Transform transformation) {
        this.transformation = transformation;
    }

    public Field withTransformation(Transform transformation) {
        this.transformation = transformation;
        return this;
    }

    @JsonProperty(value="transformationArgument")
    public Optional<String> getTransformationArgument() {
        return Optional.ofNullable(this.transformationArgument);
    }

    @JsonProperty(value="transformationArgument")
    public void setTransformationArgument(String transformationArgument) {
        this.transformationArgument = transformationArgument;
    }

    public Field withTransformationArgument(String transformationArgument) {
        this.transformationArgument = transformationArgument;
        return this;
    }

    @JsonProperty(value="translate")
    public Optional<Boolean> getTranslate() {
        return Optional.ofNullable(this.translate);
    }

    @JsonProperty(value="translate")
    public void setTranslate(Boolean translate) {
        this.translate = translate;
    }

    public Field withTranslate(Boolean translate) {
        this.translate = translate;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Field withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("alias".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"alias\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setAlias((String)value);
            return true;
        }
        if ("attribute".equals(name)) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("property \"attribute\" is of type \"java.lang.Boolean\", but got " + value.getClass().toString());
            }
            this.setAttribute((Boolean)value);
            return true;
        }
        if ("name".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"name\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setName((String)value);
            return true;
        }
        if ("propertyPath".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"propertyPath\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setPropertyPath((String)value);
            return true;
        }
        if ("transformation".equals(name)) {
            if (!(value instanceof Transform)) {
                throw new IllegalArgumentException("property \"transformation\" is of type \"org.hisp.dhis.api.model.v2_39_1.Field.Transform\", but got " + value.getClass().toString());
            }
            this.setTransformation((Transform)((Object)value));
            return true;
        }
        if ("transformationArgument".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"transformationArgument\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setTransformationArgument((String)value);
            return true;
        }
        if ("translate".equals(name)) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("property \"translate\" is of type \"java.lang.Boolean\", but got " + value.getClass().toString());
            }
            this.setTranslate((Boolean)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("alias".equals(name)) {
            return this.getAlias();
        }
        if ("attribute".equals(name)) {
            return this.getAttribute();
        }
        if ("name".equals(name)) {
            return this.getName();
        }
        if ("propertyPath".equals(name)) {
            return this.getPropertyPath();
        }
        if ("transformation".equals(name)) {
            return this.getTransformation();
        }
        if ("transformationArgument".equals(name)) {
            return this.getTransformationArgument();
        }
        if ("translate".equals(name)) {
            return this.getTranslate();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        return (T)this.getAdditionalProperties().get(name);
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
    }

    public Field with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Field.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("alias");
        sb.append('=');
        sb.append(this.alias == null ? "<null>" : this.alias);
        sb.append(',');
        sb.append("attribute");
        sb.append('=');
        sb.append(this.attribute == null ? "<null>" : this.attribute);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("propertyPath");
        sb.append('=');
        sb.append(this.propertyPath == null ? "<null>" : this.propertyPath);
        sb.append(',');
        sb.append("transformation");
        sb.append('=');
        sb.append(this.transformation == null ? "<null>" : this.transformation);
        sb.append(',');
        sb.append("transformationArgument");
        sb.append('=');
        sb.append(this.transformationArgument == null ? "<null>" : this.transformationArgument);
        sb.append(',');
        sb.append("translate");
        sb.append('=');
        sb.append(this.translate == null ? "<null>" : this.translate);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.transformationArgument == null ? 0 : this.transformationArgument.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.alias == null ? 0 : this.alias.hashCode());
        result = result * 31 + (this.attribute == null ? 0 : this.attribute.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.propertyPath == null ? 0 : this.propertyPath.hashCode());
        result = result * 31 + (this.transformation == null ? 0 : this.transformation.hashCode());
        result = result * 31 + (this.translate == null ? 0 : this.translate.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Field)) {
            return false;
        }
        Field rhs = (Field)other;
        return (this.transformationArgument == rhs.transformationArgument || this.transformationArgument != null && this.transformationArgument.equals(rhs.transformationArgument)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.alias == rhs.alias || this.alias != null && this.alias.equals(rhs.alias)) && (this.attribute == rhs.attribute || this.attribute != null && this.attribute.equals(rhs.attribute)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.propertyPath == rhs.propertyPath || this.propertyPath != null && this.propertyPath.equals(rhs.propertyPath)) && (this.transformation == rhs.transformation || this.transformation != null && this.transformation.equals((Object)rhs.transformation)) && (this.translate == rhs.translate || this.translate != null && this.translate.equals(rhs.translate));
    }

    public static enum Transform {
        AUTO("AUTO"),
        NONE("NONE"),
        IS_EMPTY("IS_EMPTY"),
        IS_NOT_EMPTY("IS_NOT_EMPTY"),
        SIZE("SIZE"),
        MEMBER("MEMBER"),
        NOT_MEMBER("NOT_MEMBER"),
        IDS("IDS"),
        ID_OBJECTS("ID_OBJECTS"),
        PLUCK("PLUCK"),
        FROM("FROM");

        private final String value;
        private static final Map<String, Transform> CONSTANTS;

        private Transform(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Transform fromValue(String value) {
            Transform constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Transform>();
            for (Transform c : Transform.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

