/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.csp.directive;

import java.util.List;
import java.util.Locale;
import org.htmlunit.csp.Directive;
import org.htmlunit.csp.Policy;
import org.htmlunit.csp.directive.HostSourceDirective;

public class FrameAncestorsDirective
extends HostSourceDirective {
    public FrameAncestorsDirective(List<String> values, Directive.DirectiveErrorConsumer errors) {
        super(values);
        int index = 0;
        for (String token : values) {
            String lowcaseToken = token.toLowerCase(Locale.ROOT);
            this.addHostOrSchemeDuringConstruction(token, lowcaseToken, "ancestor-source", index, errors);
            ++index;
        }
        if (this.getNone() != null && values.size() > 1) {
            errors.add(Policy.Severity.Error, "'none' must not be combined with any other ancestor-source", index);
        }
        if (values.isEmpty()) {
            errors.add(Policy.Severity.Error, "Ancestor-source lists cannot be empty (use 'none' instead)", -1);
        }
    }
}

